/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.tools.subsetter;

import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import java.util.Map;

public class GlyphRenumberer {
    public static ReadableFontData renumberGlyph(ReadableFontData glyph, Map<Integer, Integer> mapping) {
        return GlyphRenumberer.isCompositeGlyph(glyph) ? GlyphRenumberer.renumberCompositeGlyph(glyph, mapping) : glyph;
    }

    private static boolean isCompositeGlyph(ReadableFontData glyph) {
        return glyph.length() > 0 && glyph.readShort(Offset.numberOfContours.offset) < 0;
    }

    private static ReadableFontData renumberCompositeGlyph(ReadableFontData glyph, Map<Integer, Integer> mapping) {
        WritableFontData result = WritableFontData.createWritableFontData(glyph.length());
        glyph.copyTo(result);
        int flags = 32;
        int index = Offset.headerEnd.offset;
        while ((flags & 0x20) != 0) {
            flags = glyph.readUShort(index + Offset.compositeFlags.offset);
            int oldGlyphIndex = glyph.readUShort(index + Offset.compositeGlyphIndex.offset);
            int newGlyphIndex = mapping.get(oldGlyphIndex);
            result.writeUShort(index + Offset.compositeGlyphIndex.offset, newGlyphIndex);
            index += GlyphRenumberer.compositeReferenceSize(flags);
        }
        return result;
    }

    private static int compositeReferenceSize(int flags) {
        int result = 6;
        if ((flags & 1) != 0) {
            result += 2;
        }
        if ((flags & 8) != 0) {
            result += 2;
        } else if ((flags & 0x40) != 0) {
            result += 4;
        } else if ((flags & 0x80) != 0) {
            result += 8;
        }
        return result;
    }

    private static enum Offset {
        numberOfContours(0),
        headerEnd(10),
        compositeFlags(0),
        compositeGlyphIndex(2);

        private final int offset;

        private Offset(int offset) {
            this.offset = offset;
        }
    }
}

