/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf;

import cfca.com.itextpdf.text.pdf.PdfArray;
import cfca.com.itextpdf.text.pdf.PdfLiteral;
import cfca.com.itextpdf.text.pdf.PdfName;
import cfca.com.itextpdf.text.pdf.PdfNumber;
import cfca.com.itextpdf.text.pdf.PdfRectangle;
import cfca.com.itextpdf.text.pdf.PdfStream;
import cfca.com.itextpdf.text.pdf.PdfTemplate;

public class PdfFormXObject
extends PdfStream {
    public static final PdfNumber ZERO = new PdfNumber(0);
    public static final PdfNumber ONE = new PdfNumber(1);
    public static final PdfLiteral MATRIX = new PdfLiteral("[1 0 0 1 0 0]");

    PdfFormXObject(PdfTemplate template, int compressionLevel) {
        PdfArray matrix;
        this.put(PdfName.TYPE, PdfName.XOBJECT);
        this.put(PdfName.SUBTYPE, PdfName.FORM);
        this.put(PdfName.RESOURCES, template.getResources());
        this.put(PdfName.BBOX, new PdfRectangle(template.getBoundingBox()));
        this.put(PdfName.FORMTYPE, ONE);
        if (template.getLayer() != null) {
            this.put(PdfName.OC, template.getLayer().getRef());
        }
        if (template.getGroup() != null) {
            this.put(PdfName.GROUP, template.getGroup());
        }
        if ((matrix = template.getMatrix()) == null) {
            this.put(PdfName.MATRIX, MATRIX);
        } else {
            this.put(PdfName.MATRIX, matrix);
        }
        this.bytes = template.toPdf(null);
        this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
        if (template.getAdditional() != null) {
            this.putAll(template.getAdditional());
        }
        this.flateCompress(compressionLevel);
    }
}

