/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.oss;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.DeleteBucketRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.SetBucketPolicyRequest;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springblade.core.oss.OssTemplate;
import org.springblade.core.oss.enums.PolicyType;
import org.springblade.core.oss.model.BladeFile;
import org.springblade.core.oss.model.OssFile;
import org.springblade.core.oss.props.OssProperties;
import org.springblade.core.oss.rule.OssRule;
import org.springblade.core.tool.utils.Func;
import org.springframework.web.multipart.MultipartFile;

public class S3Template
implements OssTemplate {
    private final AmazonS3 client;
    private final OssRule ossRule;
    private final OssProperties ossProperties;

    @Override
    public void makeBucket(String bucketName) {
        if (!this.client.doesBucketExistV2(this.getBucketName(bucketName))) {
            this.client.createBucket(this.getBucketName(bucketName));
            this.client.setBucketPolicy(new SetBucketPolicyRequest(this.getBucketName(bucketName), S3Template.getPolicyType(this.getBucketName(bucketName), PolicyType.READ)));
        }
    }

    public Bucket getBucket() {
        return this.getBucket(this.getBucketName());
    }

    public Bucket getBucket(String bucketName) {
        Optional<Bucket> bucketOptional = this.client.listBuckets().stream().filter(bucket -> bucket.getName().equals(this.getBucketName(bucketName))).findFirst();
        return bucketOptional.orElse(null);
    }

    public List<Bucket> listBuckets() {
        return this.client.listBuckets();
    }

    @Override
    public void removeBucket(String bucketName) {
        this.client.deleteBucket(new DeleteBucketRequest(this.getBucketName(bucketName)));
    }

    @Override
    public boolean bucketExists(String bucketName) {
        return this.client.doesBucketExistV2(this.getBucketName(bucketName));
    }

    @Override
    public void copyFile(String bucketName, String fileName, String destBucketName) {
        this.copyFile(bucketName, fileName, destBucketName, fileName);
    }

    @Override
    public void copyFile(String bucketName, String fileName, String destBucketName, String destFileName) {
        this.client.copyObject(new CopyObjectRequest(this.getBucketName(bucketName), fileName, this.getBucketName(destBucketName), destFileName));
    }

    @Override
    public OssFile statFile(String fileName) {
        return this.statFile(this.ossProperties.getBucketName(), fileName);
    }

    @Override
    public OssFile statFile(String bucketName, String fileName) {
        S3Object stat = this.client.getObject(new GetObjectRequest(this.getBucketName(bucketName), fileName));
        OssFile ossFile = new OssFile();
        ossFile.setName(Func.isEmpty((Object)stat.getKey()) ? fileName : stat.getKey());
        ossFile.setLink(this.fileLink(ossFile.getName()));
        ossFile.setHash(String.valueOf(stat.hashCode()));
        ossFile.setLength(stat.getObjectMetadata().getContentLength());
        ossFile.setPutTime(stat.getObjectMetadata().getLastModified());
        ossFile.setContentType(stat.getObjectMetadata().getContentType());
        return ossFile;
    }

    @Override
    public InputStream statFileStream(String fileName) {
        return this.statFileStream(this.getBucketName(), fileName);
    }

    @Override
    public InputStream statFileStream(String bucketName, String fileName) {
        return this.client.getObject(new GetObjectRequest(this.getBucketName(bucketName), fileName)).getObjectContent();
    }

    @Override
    public String filePath(String fileName) {
        return this.getBucketName().concat("/").concat(fileName);
    }

    @Override
    public String filePath(String bucketName, String fileName) {
        return this.getBucketName(bucketName).concat("/").concat(fileName);
    }

    @Override
    public String fileLink(String fileName) {
        return this.ossProperties.getEndpoint().concat("/").concat(this.getBucketName()).concat("/").concat(fileName);
    }

    @Override
    public String fileLink(String bucketName, String fileName) {
        return this.ossProperties.getEndpoint().concat("/").concat(this.getBucketName(bucketName)).concat("/").concat(fileName);
    }

    @Override
    public BladeFile putFile(MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), file.getOriginalFilename(), file);
    }

    @Override
    public BladeFile putFile(String fileName, MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, file);
    }

    @Override
    public BladeFile putFile(String bucketName, String fileName, MultipartFile file) {
        return this.putFile(bucketName, file.getOriginalFilename(), file.getInputStream());
    }

    @Override
    public BladeFile putFile(String fileName, InputStream stream) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, stream);
    }

    @Override
    public BladeFile putFile(String bucketName, String fileName, InputStream stream) {
        return this.putFile(bucketName, fileName, stream, "application/octet-stream");
    }

    public BladeFile putFile(String bucketName, String fileName, InputStream stream, String contentType) {
        this.makeBucket(bucketName);
        String originalName = fileName;
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentType(contentType);
        fileName = this.getFileName(fileName);
        PutObjectRequest putObst = new PutObjectRequest(this.getBucketName(bucketName), fileName, stream, objectMetadata);
        putObst.setCannedAcl(CannedAccessControlList.PublicReadWrite);
        this.client.putObject(putObst);
        BladeFile file = new BladeFile();
        file.setOriginalName(originalName);
        file.setName(fileName);
        file.setDomain(this.getOssHost(bucketName));
        file.setLink(this.fileLink(bucketName, fileName));
        return file;
    }

    @Override
    public void removeFile(String fileName) {
        this.removeFile(this.ossProperties.getBucketName(), fileName);
    }

    @Override
    public void removeFile(String bucketName, String fileName) {
        this.client.deleteObject(bucketName, fileName);
    }

    @Override
    public void removeFiles(List<String> fileNames) {
        this.removeFiles(this.ossProperties.getBucketName(), fileNames);
    }

    @Override
    public void removeFiles(String bucketName, List<String> fileNames) {
        List keyVersions = fileNames.stream().map(DeleteObjectsRequest.KeyVersion::new).collect(Collectors.toList());
        DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(this.getBucketName());
        this.client.deleteObjects(deleteObjectsRequest.withKeys(keyVersions));
    }

    private String getBucketName() {
        return this.getBucketName(this.ossProperties.getBucketName());
    }

    private String getBucketName(String bucketName) {
        return this.ossRule.bucketName(bucketName);
    }

    private String getFileName(String originalFilename) {
        return this.ossRule.fileName(originalFilename);
    }

    public static String getPolicyType(String bucketName, PolicyType policyType) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        builder.append("    \"Statement\": [\n");
        builder.append("        {\n");
        builder.append("            \"Action\": [\n");
        switch (policyType) {
            case WRITE: {
                builder.append("                \"s3:GetBucketLocation\",\n");
                builder.append("                \"s3:ListBucketMultipartUploads\"\n");
                break;
            }
            case READ_WRITE: {
                builder.append("                \"s3:GetBucketLocation\",\n");
                builder.append("                \"s3:ListBucket\",\n");
                builder.append("                \"s3:ListBucketMultipartUploads\"\n");
                break;
            }
            default: {
                builder.append("                \"s3:GetBucketLocation\"\n");
            }
        }
        builder.append("            ],\n");
        builder.append("            \"Effect\": \"Allow\",\n");
        builder.append("            \"Principal\": \"*\",\n");
        builder.append("            \"Resource\": \"arn:aws:s3:::");
        builder.append(bucketName);
        builder.append("\"\n");
        builder.append("        },\n");
        if (PolicyType.READ.equals((Object)policyType)) {
            builder.append("        {\n");
            builder.append("            \"Action\": [\n");
            builder.append("                \"s3:ListBucket\"\n");
            builder.append("            ],\n");
            builder.append("            \"Effect\": \"Deny\",\n");
            builder.append("            \"Principal\": \"*\",\n");
            builder.append("            \"Resource\": \"arn:aws:s3:::");
            builder.append(bucketName);
            builder.append("\"\n");
            builder.append("        },\n");
        }
        builder.append("        {\n");
        builder.append("            \"Action\": ");
        switch (policyType) {
            case WRITE: {
                builder.append("[\n");
                builder.append("                \"s3:AbortMultipartUpload\",\n");
                builder.append("                \"s3:DeleteObject\",\n");
                builder.append("                \"s3:ListMultipartUploadParts\",\n");
                builder.append("                \"s3:PutObject\"\n");
                builder.append("            ],\n");
                break;
            }
            case READ_WRITE: {
                builder.append("[\n");
                builder.append("                \"s3:AbortMultipartUpload\",\n");
                builder.append("                \"s3:DeleteObject\",\n");
                builder.append("                \"s3:GetObject\",\n");
                builder.append("                \"s3:ListMultipartUploadParts\",\n");
                builder.append("                \"s3:PutObject\"\n");
                builder.append("            ],\n");
                break;
            }
            default: {
                builder.append("\"s3:GetObject\",\n");
            }
        }
        builder.append("            \"Effect\": \"Allow\",\n");
        builder.append("            \"Principal\": \"*\",\n");
        builder.append("            \"Resource\": \"arn:aws:s3:::");
        builder.append(bucketName);
        builder.append("/*\"\n");
        builder.append("        }\n");
        builder.append("    ],\n");
        builder.append("    \"Version\": \"2012-10-17\"\n");
        builder.append("}\n");
        return builder.toString();
    }

    public String getOssHost(String bucketName) {
        return this.ossProperties.getEndpoint() + "/" + this.getBucketName(bucketName);
    }

    public String getOssHost() {
        return this.getOssHost(this.ossProperties.getBucketName());
    }

    public S3Template(AmazonS3 client, OssRule ossRule, OssProperties ossProperties) {
        this.client = client;
        this.ossRule = ossRule;
        this.ossProperties = ossProperties;
    }
}

