/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.paperless.base.exception.CodeException;
import cfca.sadk.com.itextpdf.io.image.ImageData;
import cfca.sadk.com.itextpdf.io.image.ImageDataFactory;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfWriter;
import cfca.sadk.com.itextpdf.layout.Document;
import cfca.sadk.com.itextpdf.layout.element.AreaBreak;
import cfca.sadk.com.itextpdf.layout.element.Image;
import cfca.sadk.com.itextpdf.layout.property.HorizontalAlignment;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageToPdfUtil {
    private static final Logger logger = LoggerFactory.getLogger(ImageToPdfUtil.class);

    public static byte[] imageToPdf(ArrayList<byte[]> imagelist) throws Exception {
        if (imagelist == null || imagelist.isEmpty()) {
            throw new CodeException("600401", "imagelist is empty!");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document document = null;
        try {
            PdfDocument pdfDocument = new PdfDocument(new PdfWriter((OutputStream)baos));
            document = new Document(pdfDocument);
            int size = imagelist.size();
            for (int i = 0; i < size; ++i) {
                try {
                    ImageData imageData = ImageDataFactory.create((byte[])imagelist.get(i));
                    Image image = new Image(imageData);
                    int xDPI = imageData.getDpiX() == 0 ? 96 : imageData.getDpiX();
                    int yDPI = imageData.getDpiY() == 0 ? 96 : imageData.getDpiY();
                    float width = imageData.getWidth() * 72.0f / (float)xDPI;
                    float height = imageData.getHeight() * 72.0f / (float)yDPI;
                    image.setHorizontalAlignment(HorizontalAlignment.CENTER);
                    image.setHeight(height);
                    image.setWidth(width);
                    document.add(image);
                    if (i >= size - 1) continue;
                    AreaBreak areaBreak = new AreaBreak();
                    document.add(areaBreak);
                    continue;
                }
                catch (Exception e) {
                    logger.error(i + 1 + "th image decode error", (Throwable)e);
                    throw new CodeException("600702", " " + (i + 1) + "th image decode error", (Throwable)e);
                }
            }
            document.close();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (CodeException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("600709", (Throwable)e);
            throw new CodeException("600709", e);
        }
        finally {
            if (null != document) {
                document.close();
            }
        }
    }
}

