/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.paperless.base.util.CloseUtil;
import cfca.paperless.base.util.StringUtil;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLContextUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLContext createSSLContext(String sslProtocol, String keystorePath, String keystorePassword, String keyStoreType, String truststorePath, String truststorePassword, String trustStoreType) throws Exception {
        KeyManager[] keyManagerArray = null;
        if (StringUtil.isNotEmpty(keystorePath)) {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            String kmfTypeName = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(kmfTypeName);
            FileInputStream keyStoreInputStream = null;
            try {
                keyStoreInputStream = new FileInputStream(keystorePath);
                keyStore.load(keyStoreInputStream, keystorePassword.toCharArray());
                keyManagerFactory.init(keyStore, keystorePassword.toCharArray());
                keyManagerArray = keyManagerFactory.getKeyManagers();
            }
            catch (Throwable throwable) {
                CloseUtil.closeQuietly(keyStoreInputStream);
                throw throwable;
            }
            CloseUtil.closeQuietly(keyStoreInputStream);
        }
        TrustManager[] trustManagerArray = null;
        KeyStore trustKeyStore = KeyStore.getInstance(trustStoreType);
        String tmfTypeName = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(tmfTypeName);
        FileInputStream trustStoreInputStream = null;
        try {
            trustStoreInputStream = new FileInputStream(truststorePath);
            trustKeyStore.load(trustStoreInputStream, truststorePassword.toCharArray());
            trustManagerFactory.init(trustKeyStore);
            trustManagerArray = trustManagerFactory.getTrustManagers();
        }
        finally {
            if (trustStoreInputStream != null) {
                ((InputStream)trustStoreInputStream).close();
            }
        }
        SSLContext sslcontext = SSLContext.getInstance(sslProtocol);
        sslcontext.init(keyManagerArray, trustManagerArray, null);
        return sslcontext;
    }

    public static SSLContext createDefaultSSLContextForRA(String keystorePath, String keystorePassword, String truststorePath, String truststorePassword) throws Exception {
        String sslProtocol = "TLS";
        String keyStoreType = KeyStore.getDefaultType();
        return SSLContextUtil.createSSLContext(sslProtocol, keystorePath, keystorePassword, keyStoreType, truststorePath, truststorePassword, keyStoreType);
    }
}

