/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.layout.element;

import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import cfca.sadk.com.itextpdf.layout.Document;
import cfca.sadk.com.itextpdf.layout.border.Border;
import cfca.sadk.com.itextpdf.layout.element.BlockElement;
import cfca.sadk.com.itextpdf.layout.element.Cell;
import cfca.sadk.com.itextpdf.layout.element.IElement;
import cfca.sadk.com.itextpdf.layout.element.ILargeElement;
import cfca.sadk.com.itextpdf.layout.element.Image;
import cfca.sadk.com.itextpdf.layout.element.Paragraph;
import cfca.sadk.com.itextpdf.layout.property.UnitValue;
import cfca.sadk.com.itextpdf.layout.renderer.IRenderer;
import cfca.sadk.com.itextpdf.layout.renderer.TableRenderer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Table
extends BlockElement<Table>
implements ILargeElement {
    protected PdfName role = PdfName.Table;
    protected AccessibilityProperties tagProperties;
    private List<Cell[]> rows;
    private UnitValue[] columnWidths;
    private int currentColumn = 0;
    private int currentRow = -1;
    private Table header;
    private Table footer;
    private boolean skipFirstHeader;
    private boolean skipLastFooter;
    private boolean isComplete;
    private List<RowRange> lastAddedRowGroups;
    private int rowWindowStart = 0;
    private Document document;
    private Cell[] lastAddedRow;

    public Table(float[] columnWidths, boolean largeTable) {
        if (columnWidths == null) {
            throw new NullPointerException("The widths array in table constructor can not be null.");
        }
        if (columnWidths.length == 0) {
            throw new IllegalArgumentException("The widths array in table constructor can not have zero length.");
        }
        this.columnWidths = Table.normalizeColumnWidths(columnWidths);
        this.initializeLargeTable(largeTable);
        this.initializeRows();
    }

    public Table(UnitValue[] columnWidths, boolean largeTable) {
        if (columnWidths == null) {
            throw new NullPointerException("The widths array in table constructor can not be null.");
        }
        if (columnWidths.length == 0) {
            throw new IllegalArgumentException("The widths array in table constructor can not have zero length.");
        }
        if (largeTable && Table.hasOnlyPercents(columnWidths)) {
            this.useAllAvailableWidth();
        }
        this.columnWidths = Table.normalizeColumnWidths(columnWidths);
        this.initializeLargeTable(largeTable);
        this.initializeRows();
    }

    public Table(UnitValue[] columnWidths) {
        this(columnWidths, false);
    }

    public Table(float[] pointColumnWidths) {
        this(pointColumnWidths, false);
    }

    @Deprecated
    public Table(int numColumns, boolean largeTable) {
        if (numColumns <= 0) {
            throw new IllegalArgumentException("The number of columns in Table constructor must be greater than zero");
        }
        this.columnWidths = new UnitValue[numColumns];
        for (int k = 0; k < numColumns; ++k) {
            this.columnWidths[k] = UnitValue.createPercentValue(100.0f / (float)numColumns);
        }
        this.useAllAvailableWidth();
        this.columnWidths = Table.normalizeColumnWidths(numColumns);
        this.initializeLargeTable(largeTable);
        this.initializeRows();
    }

    @Deprecated
    public Table(int numColumns) {
        this(numColumns, false);
    }

    private static boolean hasOnlyPercents(UnitValue[] columnWidths) {
        for (UnitValue col : columnWidths) {
            if (col != null && !col.isPointValue() && !(col.getValue() < 0.0f)) continue;
            return false;
        }
        return true;
    }

    private static UnitValue[] normalizeColumnWidths(float[] pointColumnWidths) {
        UnitValue[] normalized = new UnitValue[pointColumnWidths.length];
        for (int i = 0; i < normalized.length; ++i) {
            if (!(pointColumnWidths[i] >= 0.0f)) continue;
            normalized[i] = UnitValue.createPointValue(pointColumnWidths[i]);
        }
        return normalized;
    }

    private static UnitValue[] normalizeColumnWidths(UnitValue[] unitColumnWidths) {
        UnitValue[] normalized = new UnitValue[unitColumnWidths.length];
        for (int i = 0; i < unitColumnWidths.length; ++i) {
            normalized[i] = unitColumnWidths[i] != null && unitColumnWidths[i].getValue() >= 0.0f ? new UnitValue(unitColumnWidths[i]) : null;
        }
        return normalized;
    }

    private static UnitValue[] normalizeColumnWidths(int numberOfColumns) {
        UnitValue[] normalized = new UnitValue[numberOfColumns];
        for (int i = 0; i < numberOfColumns; ++i) {
            normalized[i] = UnitValue.createPercentValue(100.0f / (float)numberOfColumns);
        }
        return normalized;
    }

    public Table setFixedLayout() {
        this.setProperty(93, "fixed");
        return this;
    }

    public Table setAutoLayout() {
        this.setProperty(93, "auto");
        return this;
    }

    public Table useAllAvailableWidth() {
        this.setProperty(77, UnitValue.createPercentValue(100.0f));
        return this;
    }

    public UnitValue getColumnWidth(int column) {
        return this.columnWidths[column];
    }

    public int getNumberOfColumns() {
        return this.columnWidths.length;
    }

    public int getNumberOfRows() {
        return this.rows.size();
    }

    public Table addHeaderCell(Cell headerCell) {
        this.ensureHeaderIsInitialized();
        this.header.addCell(headerCell);
        return this;
    }

    public <T extends IElement> Table addHeaderCell(BlockElement<T> blockElement) {
        this.ensureHeaderIsInitialized();
        this.header.addCell(blockElement);
        return this;
    }

    public Table addHeaderCell(Image image) {
        this.ensureHeaderIsInitialized();
        this.header.addCell(image);
        return this;
    }

    public Table addHeaderCell(String content) {
        this.ensureHeaderIsInitialized();
        this.header.addCell(content);
        return this;
    }

    public Table getHeader() {
        return this.header;
    }

    public Table addFooterCell(Cell footerCell) {
        this.ensureFooterIsInitialized();
        this.footer.addCell(footerCell);
        return this;
    }

    public <T extends IElement> Table addFooterCell(BlockElement<T> blockElement) {
        this.ensureFooterIsInitialized();
        this.footer.addCell(blockElement);
        return this;
    }

    public Table addFooterCell(Image image) {
        this.ensureFooterIsInitialized();
        this.footer.addCell(image);
        return this;
    }

    public Table addFooterCell(String content) {
        this.ensureFooterIsInitialized();
        this.footer.addCell(content);
        return this;
    }

    public Table getFooter() {
        return this.footer;
    }

    public boolean isSkipFirstHeader() {
        return this.skipFirstHeader;
    }

    public Table setSkipFirstHeader(boolean skipFirstHeader) {
        this.skipFirstHeader = skipFirstHeader;
        return this;
    }

    public boolean isSkipLastFooter() {
        return this.skipLastFooter;
    }

    public Table setSkipLastFooter(boolean skipLastFooter) {
        this.skipLastFooter = skipLastFooter;
        return this;
    }

    public Table startNewRow() {
        this.currentColumn = 0;
        ++this.currentRow;
        if (this.currentRow >= this.rows.size()) {
            this.rows.add(new Cell[this.columnWidths.length]);
        }
        return this;
    }

    public Table addCell(Cell cell) {
        while (true) {
            if (this.currentColumn >= this.columnWidths.length || this.currentColumn == -1) {
                this.startNewRow();
            }
            if (this.rows.get(this.currentRow - this.rowWindowStart)[this.currentColumn] == null) break;
            ++this.currentColumn;
        }
        this.childElements.add(cell);
        cell.updateCellIndexes(this.currentRow, this.currentColumn, this.columnWidths.length);
        while (this.currentRow - this.rowWindowStart + cell.getRowspan() > this.rows.size()) {
            this.rows.add(new Cell[this.columnWidths.length]);
        }
        for (int i = this.currentRow; i < this.currentRow + cell.getRowspan(); ++i) {
            Cell[] row = this.rows.get(i - this.rowWindowStart);
            for (int j = this.currentColumn; j < this.currentColumn + cell.getColspan(); ++j) {
                if (row[j] != null) continue;
                row[j] = cell;
            }
        }
        this.currentColumn += cell.getColspan();
        return this;
    }

    public <T extends IElement> Table addCell(BlockElement<T> blockElement) {
        return this.addCell(new Cell().add(blockElement));
    }

    public Table addCell(Image image) {
        return this.addCell(new Cell().add(image));
    }

    public Table addCell(String content) {
        return this.addCell(new Cell().add(new Paragraph(content)));
    }

    public Cell getCell(int row, int column) {
        Cell cell;
        if (row - this.rowWindowStart < this.rows.size() && (cell = this.rows.get(row - this.rowWindowStart)[column]) != null && cell.getRow() == row && cell.getCol() == column) {
            return cell;
        }
        return null;
    }

    @Override
    public IRenderer createRendererSubTree() {
        TableRenderer rendererRoot = (TableRenderer)this.getRenderer();
        for (IElement child : this.childElements) {
            boolean childShouldBeAdded = this.isComplete || this.cellBelongsToAnyRowGroup((Cell)child, this.lastAddedRowGroups);
            if (!childShouldBeAdded) continue;
            rendererRoot.addChild(child.createRendererSubTree());
        }
        return rendererRoot;
    }

    @Override
    protected IRenderer makeNewRenderer() {
        return new TableRenderer(this);
    }

    @Override
    public IRenderer getRenderer() {
        if (this.nextRenderer != null) {
            if (this.nextRenderer instanceof TableRenderer) {
                IRenderer renderer = this.nextRenderer;
                this.nextRenderer = this.nextRenderer.getNextRenderer();
                return renderer;
            }
            Logger logger = LoggerFactory.getLogger(Table.class);
            logger.error("Invalid renderer for Table: must be inherited from TableRenderer");
        }
        List<RowRange> list = this.lastAddedRowGroups = this.isComplete ? null : this.getRowGroups();
        if (this.isComplete) {
            return new TableRenderer(this, new RowRange(this.rowWindowStart, this.rowWindowStart + this.rows.size() - 1));
        }
        int rowWindowFinish = this.lastAddedRowGroups.size() != 0 ? this.lastAddedRowGroups.get((int)(this.lastAddedRowGroups.size() - 1)).finishRow : -1;
        return new TableRenderer(this, new RowRange(this.rowWindowStart, rowWindowFinish));
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public void complete() {
        assert (!this.isComplete);
        this.isComplete = true;
        this.flush();
    }

    @Override
    public void flush() {
        Cell[] row = null;
        int rowNum = this.rows.size();
        if (!this.rows.isEmpty()) {
            row = this.rows.get(this.rows.size() - 1);
        }
        this.document.add(this);
        if (row != null && rowNum != this.rows.size()) {
            this.lastAddedRow = row;
        }
    }

    @Override
    public void flushContent() {
        if (this.lastAddedRowGroups == null || this.lastAddedRowGroups.isEmpty()) {
            return;
        }
        int firstRow = this.lastAddedRowGroups.get((int)0).startRow;
        int lastRow = this.lastAddedRowGroups.get((int)(this.lastAddedRowGroups.size() - 1)).finishRow;
        ArrayList<IElement> toRemove = new ArrayList<IElement>();
        for (IElement cell : this.childElements) {
            if (((Cell)cell).getRow() < firstRow || ((Cell)cell).getRow() > lastRow) continue;
            toRemove.add(cell);
        }
        this.childElements.removeAll(toRemove);
        for (int i = 0; i < lastRow - firstRow; ++i) {
            this.rows.remove(firstRow - this.rowWindowStart);
        }
        this.lastAddedRow = this.rows.remove(firstRow - this.rowWindowStart);
        this.rowWindowStart = this.lastAddedRowGroups.get(this.lastAddedRowGroups.size() - 1).getFinishRow() + 1;
        this.lastAddedRowGroups = null;
    }

    @Override
    public void setDocument(Document document) {
        this.document = document;
    }

    public List<Border> getLastRowBottomBorder() {
        ArrayList<Border> horizontalBorder = new ArrayList<Border>();
        if (this.lastAddedRow != null) {
            for (int i = 0; i < this.lastAddedRow.length; ++i) {
                Cell cell = this.lastAddedRow[i];
                Border border = null;
                if (cell != null) {
                    border = cell.hasProperty(10) ? (Border)cell.getProperty(10) : (cell.hasProperty(9) ? (Border)cell.getProperty(9) : (Border)cell.getDefaultProperty(9));
                }
                horizontalBorder.add(border);
            }
        }
        return horizontalBorder;
    }

    @Override
    public PdfName getRole() {
        return this.role;
    }

    @Override
    public void setRole(PdfName role) {
        this.role = role;
        if (PdfName.Artifact.equals(role)) {
            this.propagateArtifactRoleToChildElements();
        }
    }

    public Table setExtendBottomRow(boolean isExtended) {
        this.setProperty(86, isExtended);
        return this;
    }

    public Table setExtendBottomRowOnSplit(boolean isExtended) {
        this.setProperty(87, isExtended);
        return this;
    }

    @Override
    public AccessibilityProperties getAccessibilityProperties() {
        if (this.tagProperties == null) {
            this.tagProperties = new AccessibilityProperties();
        }
        return this.tagProperties;
    }

    @Deprecated
    protected void calculateWidths() {
    }

    protected List<RowRange> getRowGroups() {
        int lastRowWeCanFlush = this.currentColumn == this.columnWidths.length ? this.currentRow : this.currentRow - 1;
        int[] cellBottomRows = new int[this.columnWidths.length];
        int currentRowGroupStart = this.rowWindowStart;
        ArrayList<RowRange> rowGroups = new ArrayList<RowRange>();
        while (currentRowGroupStart <= lastRowWeCanFlush) {
            for (int i = 0; i < this.columnWidths.length; ++i) {
                cellBottomRows[i] = currentRowGroupStart;
            }
            int maxRowGroupFinish = cellBottomRows[0] + this.rows.get(cellBottomRows[0] - this.rowWindowStart)[0].getRowspan() - 1;
            boolean converged = false;
            boolean rowGroupComplete = true;
            while (!converged) {
                converged = true;
                for (int i = 0; i < this.columnWidths.length; ++i) {
                    while (cellBottomRows[i] < lastRowWeCanFlush && cellBottomRows[i] + this.rows.get(cellBottomRows[i] - this.rowWindowStart)[i].getRowspan() - 1 < maxRowGroupFinish) {
                        int n = i;
                        cellBottomRows[n] = cellBottomRows[n] + this.rows.get(cellBottomRows[i] - this.rowWindowStart)[i].getRowspan();
                    }
                    if (cellBottomRows[i] + this.rows.get(cellBottomRows[i] - this.rowWindowStart)[i].getRowspan() - 1 > maxRowGroupFinish) {
                        maxRowGroupFinish = cellBottomRows[i] + this.rows.get(cellBottomRows[i] - this.rowWindowStart)[i].getRowspan() - 1;
                        converged = false;
                        continue;
                    }
                    if (cellBottomRows[i] + this.rows.get(cellBottomRows[i] - this.rowWindowStart)[i].getRowspan() - 1 >= maxRowGroupFinish) continue;
                    rowGroupComplete = false;
                }
            }
            if (rowGroupComplete) {
                rowGroups.add(new RowRange(currentRowGroupStart, maxRowGroupFinish));
            }
            currentRowGroupStart = maxRowGroupFinish + 1;
        }
        return rowGroups;
    }

    private void initializeRows() {
        this.rows = new ArrayList<Cell[]>();
        this.currentColumn = -1;
    }

    private boolean cellBelongsToAnyRowGroup(Cell cell, List<RowRange> rowGroups) {
        return rowGroups != null && rowGroups.size() > 0 && cell.getRow() >= rowGroups.get(0).getStartRow() && cell.getRow() <= rowGroups.get(rowGroups.size() - 1).getFinishRow();
    }

    private void ensureHeaderIsInitialized() {
        if (this.header == null) {
            this.header = new Table(this.columnWidths);
            UnitValue width = this.getWidth();
            if (width != null) {
                this.header.setWidth(width);
            }
            this.header.setRole(PdfName.THead);
        }
    }

    private void ensureFooterIsInitialized() {
        if (this.footer == null) {
            this.footer = new Table(this.columnWidths);
            UnitValue width = this.getWidth();
            if (width != null) {
                this.footer.setWidth(width);
            }
            this.footer.setRole(PdfName.TFoot);
        }
    }

    private void initializeLargeTable(boolean largeTable) {
        boolean bl = this.isComplete = !largeTable;
        if (largeTable) {
            this.setWidth(UnitValue.createPercentValue(100.0f));
            this.setFixedLayout();
        }
    }

    public static class RowRange {
        int startRow;
        int finishRow;

        public RowRange(int startRow, int finishRow) {
            this.startRow = startRow;
            this.finishRow = finishRow;
        }

        public int getStartRow() {
            return this.startRow;
        }

        public int getFinishRow() {
            return this.finishRow;
        }
    }
}

