/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCS7SignedData;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.signatures.ITSAClient;
import cfca.sadk.com.itextpdf.signatures.PdfSigner;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.seal.base.bean.sign.SignInfoConfig;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.external.AbstractExternalP7Signer;
import cfca.sadk.seal.base.util.Constants;
import cfca.sadk.seal.base.util.ParamsCheckUtil;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Calendar;

public class AsynCFCAAttributeSigner
extends AbstractExternalP7Signer {
    private static Logger businessLog = LoggerFactory.getLogger(AsynCFCAAttributeSigner.class);
    private byte[] p1Sig;
    private boolean isSM2;
    private int estimatedSize;
    private Session session;
    protected Mechanism mechanism;
    protected X509Cert[] signCerts;
    protected X509Cert signCert;
    protected boolean isContainChain;
    private ITSAClient tsaClient;
    private byte[] pkcs7Data;
    private byte[] originHash;

    public AsynCFCAAttributeSigner(SignInfoConfig signatureConfig, byte[] p1Sig) throws SealException {
        this.p1Sig = null;
        this.isSM2 = false;
        this.estimatedSize = 8192;
        this.session = null;
        this.mechanism = null;
        this.signCert = null;
        this.isContainChain = false;
        this.tsaClient = null;
        this.pkcs7Data = null;
        this.originHash = null;
        if (p1Sig == null || p1Sig.length == 0) {
            throw new SealException("AsynCFCASigner externalPKCS1 is null");
        }
        this.mechanism = signatureConfig.getSignAlg();
        if (Mechanisms.isSM2WithSM3((Mechanism)this.mechanism)) {
            throw new SealException("SM2WithSM3 Mechanism is not support!");
        }
        this.signInfoConfig = signatureConfig;
        this.estimatedSize = signatureConfig.getPKCS7SigEstimatedSize();
        this.session = this.getSession(signatureConfig.getSession());
        this.tsaClient = signatureConfig.getTsaClient();
        this.signCerts = signatureConfig.getCerts();
        ParamsCheckUtil.checkCertValidity(this.signCerts[0]);
        this.signCert = signatureConfig.getSignCert();
        this.isContainChain = signatureConfig.isP7ContainChain();
        this.p1Sig = p1Sig;
        this.originHash = signatureConfig.getOriginHash();
    }

    @Override
    public Calendar getSigningTime() {
        return this.signingTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynCFCAAttributeSigner(byte[] p7Sig, Mechanism mechanism) throws SealException {
        block8: {
            this.p1Sig = null;
            this.isSM2 = false;
            this.estimatedSize = 8192;
            this.session = null;
            this.mechanism = null;
            this.signCert = null;
            this.isContainChain = false;
            this.tsaClient = null;
            this.pkcs7Data = null;
            this.originHash = null;
            if (Mechanisms.isSM2WithSM3((Mechanism)mechanism)) {
                throw new SealException("SM2WithSM3 Mechanism is not support!");
            }
            if (p7Sig == null || p7Sig.length == 0) {
                throw new SealException("AsynCFCASigner externalPKCS7 is null");
            }
            boolean isDer = false;
            try {
                if (ASN1Parser.isDERSequence((byte[])p7Sig)) {
                    isDer = true;
                }
            }
            catch (PKIException e) {
                businessLog.error("AsynCFCASigner construct failed", (Throwable)e);
            }
            finally {
                if (isDer) break block8;
                throw new SealException("p7Sig encoding required DERSequence");
            }
        }
        this.pkcs7Data = p7Sig;
        this.mechanism = mechanism;
    }

    @Override
    public byte[] sign(InputStream paramInputStream) throws GeneralSecurityException {
        byte[] signedData = null;
        try {
            DERSet derSet = null;
            X509Cert[] tmpSignCerts = this.signCerts;
            if (this.originHash != null) {
                this.signingTime = this.signInfoConfig.getP7Signer().getSigningTime();
                derSet = this.getAuthenticatedAttributeSet(this.originHash, this.signingTime, null, null, PdfSigner.CryptoStandard.CMS);
            }
            if (this.p1Sig != null) {
                if (!this.isContainChain) {
                    tmpSignCerts = new X509Cert[]{this.signCerts[0]};
                }
                byte[] timeStampPKCS7 = this.getTimeStamp(this.tsaClient, this.SM2RStoASN1(this.p1Sig));
                signedData = this.packagePKCS7(this.session, null, this.p1Sig, this.mechanism, timeStampPKCS7, derSet, tmpSignCerts);
            } else {
                PKCS7SignedData p7SignedData = new PKCS7SignedData(this.session);
                p7SignedData.loadBase64(this.pkcs7Data);
                this.p1Sig = p7SignedData.getSignature();
                byte[] timeStampPKCS7 = this.getTimeStamp(this.tsaClient, this.SM2RStoASN1(this.p1Sig));
                signedData = this.rebuildPKCS7(this.session, this.pkcs7Data, null, this.mechanism, timeStampPKCS7, derSet, null);
            }
            this.estimatedSize = signedData.length;
            return signedData;
        }
        catch (PKIException e) {
            businessLog.error("AsynCFCAAttributeSigner sign failed", (Throwable)e);
            throw new GeneralSecurityException("AsynCFCAAttributeSigner sign failed", e);
        }
    }

    @Override
    public void modifySigningDictionary(PdfDictionary signDic) {
        signDic.put(PdfName.Filter, PdfName.Adobe_PPKLite);
        if (this.isSM2) {
            signDic.put(PdfName.SubFilter, Constants.CFCA_SM2_FILTER);
        } else {
            signDic.put(PdfName.SubFilter, PdfName.Adbe_pkcs7_detached);
        }
    }

    @Override
    public int getEstimatedSize() {
        return this.estimatedSize + 64;
    }

    @Override
    public void setTsaClient(ITSAClient tsaClient) {
        this.tsaClient = tsaClient;
    }

    public byte[] getOriginHash() {
        return this.originHash;
    }

    @Override
    public void setOriginHash(byte[] originHash) {
        this.originHash = originHash;
    }
}

