/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.bean;

import cfca.sadk.algorithm.common.GMObjectIdentifiers;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;

public enum HashAlgorithm {
    SHA256("SHA-256", PKCSObjectIdentifiers.sha256.getId(), 32),
    SM3("SM3", GMObjectIdentifiers.sm3.getId(), 32),
    SHA512("SHA-512", PKCSObjectIdentifiers.sha512.getId(), 64),
    SHA1("SHA-1", PKCSObjectIdentifiers.sha1.getId(), 20),
    MD5TEST("MD5", PKCSObjectIdentifiers.md5.getId(), 16);

    public final String name;
    public final String oid;
    public final int hashLength;

    private HashAlgorithm(String name, String oid, int hashLength) {
        this.name = name;
        this.oid = oid;
        this.hashLength = hashLength;
    }

    public static final HashAlgorithm findHashAlgorithm(String oid) {
        HashAlgorithm[] values = HashAlgorithm.values();
        HashAlgorithm hashAlgorithm = null;
        for (HashAlgorithm value : values) {
            if (!value.oid.equals(oid)) continue;
            hashAlgorithm = value;
            break;
        }
        return hashAlgorithm;
    }

    public String toString() {
        String name = super.toString();
        return name + ": " + this.oid;
    }
}

