/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.tools.subsetter;

import cfca.sadk.com.google.typography.font.sfntly.Font;
import cfca.sadk.com.google.typography.font.sfntly.Tag;
import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.table.truetype.Glyph;
import cfca.sadk.com.google.typography.font.sfntly.table.truetype.GlyphTable;
import cfca.sadk.com.google.typography.font.sfntly.table.truetype.LocaTable;
import cfca.sadk.com.google.typography.font.tools.subsetter.GlyphStripper;
import cfca.sadk.com.google.typography.font.tools.subsetter.Subsetter;
import cfca.sadk.com.google.typography.font.tools.subsetter.TableSubsetterImpl;
import java.io.IOException;
import java.util.List;

public class GlyphTableStripper
extends TableSubsetterImpl {
    public GlyphTableStripper() {
        super(Tag.glyf, Tag.loca);
    }

    @Override
    public boolean subset(Subsetter subsetter, Font font, Font.Builder fontBuilder) throws IOException {
        GlyphTable glyphTable = (GlyphTable)font.getTable(Tag.glyf);
        LocaTable locaTable = (LocaTable)font.getTable(Tag.loca);
        if (glyphTable == null || locaTable == null) {
            throw new RuntimeException("Font to subset is not valid.");
        }
        ReadableFontData originalGlyfData = glyphTable.readFontData();
        GlyphTable.Builder glyphTableBuilder = (GlyphTable.Builder)fontBuilder.newTableBuilder(Tag.glyf);
        LocaTable.Builder locaTableBuilder = (LocaTable.Builder)fontBuilder.newTableBuilder(Tag.loca);
        List<Glyph.Builder<? extends Glyph>> glyphBuilders = glyphTableBuilder.glyphBuilders();
        GlyphStripper glyphStripper = new GlyphStripper(glyphTableBuilder);
        for (int i = 0; i < locaTable.numGlyphs(); ++i) {
            int oldOffset = locaTable.glyphOffset(i);
            int oldLength = locaTable.glyphLength(i);
            Glyph glyph = glyphTable.glyph(oldOffset, oldLength);
            glyphBuilders.add(glyphStripper.stripGlyph(glyph));
        }
        List<Integer> locaList = glyphTableBuilder.generateLocaList();
        locaTableBuilder.setLocaList(locaList);
        return true;
    }
}

