/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.tools.subsetter;

import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.sadk.com.google.typography.font.sfntly.table.core.PostScriptTable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PostScriptTableBuilder {
    private static final int VERSION_2 = 131072;
    private static final int NUM_STANDARD_NAMES = 258;
    private static final int V1_TABLE_SIZE = 32;
    private static final String[] STANDARD_NAMES = new String[]{".notdef", ".null", "nonmarkingreturn", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "summation", "product", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "nonbreakingspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "apple", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idotaccent", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dcroat"};
    private static final Map<String, Integer> INVERTED_STANDARD_NAMES = PostScriptTableBuilder.invertNameMap(STANDARD_NAMES);
    private final WritableFontData v1Data = WritableFontData.createWritableFontData(32);
    private List<String> names;

    private static Map<String, Integer> invertNameMap(String[] names) {
        HashMap<String, Integer> nameMap = new HashMap<String, Integer>();
        for (int i = 0; i < names.length; ++i) {
            nameMap.put(names[i], i);
        }
        return nameMap;
    }

    public void initV1From(PostScriptTable src) {
        src.readFontData().slice(0, 32).copyTo(this.v1Data);
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    public ReadableFontData build() {
        if (this.names == null) {
            return this.v1Data;
        }
        ArrayList<Integer> glyphNameIndices = new ArrayList<Integer>();
        ByteArrayOutputStream nameBos = new ByteArrayOutputStream();
        int nGlyphs = this.names.size();
        int tableIndex = 258;
        for (String name : this.names) {
            int glyphNameIndex;
            if (INVERTED_STANDARD_NAMES.containsKey(name)) {
                glyphNameIndex = INVERTED_STANDARD_NAMES.get(name);
            } else {
                glyphNameIndex = tableIndex++;
                nameBos.write(name.length());
                try {
                    nameBos.write(name.getBytes("ISO-8859-1"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to write post table data", e);
                }
            }
            glyphNameIndices.add(glyphNameIndex);
        }
        byte[] nameBytes = nameBos.toByteArray();
        int newLength = 34 + 2 * nGlyphs + nameBytes.length;
        WritableFontData data = WritableFontData.createWritableFontData(newLength);
        this.v1Data.copyTo(data);
        data.writeFixed(Offset.version.offset, 131072);
        data.writeUShort(Offset.numberOfGlyphs.offset, nGlyphs);
        int index = Offset.glyphNameIndex.offset;
        for (Integer glyphNameIndex : glyphNameIndices) {
            index += data.writeUShort(index, glyphNameIndex);
        }
        if (nameBytes.length > 0) {
            data.writeBytes(index, nameBytes, 0, nameBytes.length);
        }
        return data;
    }

    private static enum Offset {
        version(0),
        italicAngle(4),
        underlinePosition(8),
        underlineThickness(10),
        isFixedPitch(12),
        minMemType42(16),
        maxMemType42(20),
        minMemType1(24),
        maxMemType1(28),
        numberOfGlyphs(32),
        glyphNameIndex(34);

        private final int offset;

        private Offset(int offset) {
            this.offset = offset;
        }
    }
}

