/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.io.source.ByteArrayOutputStream;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfWriter;
import cfca.sadk.com.itextpdf.signatures.SignatureUtil;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.MethodCostTimeUtil;
import cfca.sadk.seal.base.util.ParamsCheckUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class RepairUtil {
    private static Logger businessLog = LoggerFactory.getLogger(RepairUtil.class);

    public static byte[] repairPdf(byte[] pdfData) throws SealException {
        businessLog.info("repairPdf begin...");
        String methodName = MethodCostTimeUtil.recordStartTime("repairPdf");
        PdfDocument pdfDocument = null;
        try {
            if (null == pdfData) {
                throw new SealException("pdfData is null!");
            }
            ByteArrayOutputStream outputPdfData = new ByteArrayOutputStream();
            PdfReader pdfReader = new PdfReader(pdfData);
            PdfWriter pdfWriter = new PdfWriter(outputPdfData);
            pdfDocument = new PdfDocument(pdfReader, pdfWriter);
            ParamsCheckUtil.checkSignature(pdfDocument);
            SignatureUtil signature = new SignatureUtil(pdfDocument);
            List<String> list = signature.getSignatureNames();
            if (null != list && !list.isEmpty()) {
                throw new SealException("pdfDocument is signed,can not restore!");
            }
            pdfDocument.close();
            byte[] byArray = outputPdfData.toByteArray();
            return byArray;
        }
        catch (SealException e) {
            businessLog.error("repairPdf failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("repairPdf failed", (Throwable)e);
            throw new SealException("repairPdf failed", e);
        }
        finally {
            if (null != pdfDocument) {
                pdfDocument.close();
            }
            MethodCostTimeUtil.recordEndTime(methodName);
            businessLog.info("repairPdf end...");
        }
    }

    public static void repairPdf(InputStream inputStream, OutputStream outputStream) throws SealException {
        businessLog.info("repairPdf begin...");
        String methodName = MethodCostTimeUtil.recordStartTime("repairPdf");
        PdfDocument pdfDocument = null;
        try {
            if (null == inputStream) {
                throw new SealException("inputStream is null!");
            }
            if (null == outputStream) {
                throw new SealException("outputStream is null!");
            }
            PdfReader pdfReader = new PdfReader(inputStream);
            PdfWriter pdfWriter = new PdfWriter(outputStream);
            pdfDocument = new PdfDocument(pdfReader, pdfWriter);
            SignatureUtil signature = new SignatureUtil(pdfDocument);
            List<String> list = signature.getSignatureNames();
            if (null != list && !list.isEmpty()) {
                throw new SealException("pdfDocument is signed,can not restore!");
            }
            pdfDocument.close();
        }
        catch (SealException e) {
            businessLog.error("repairPdf failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("repairPdf failed", (Throwable)e);
            throw new SealException("repairPdf failed", e);
        }
        finally {
            if (null != pdfDocument) {
                pdfDocument.close();
            }
            MethodCostTimeUtil.recordEndTime(methodName);
            businessLog.info("repairPdf end...");
        }
    }
}

