/*
 * Decompiled with CFR 0.152.
 */
package io.github.autoffice.luckysheet.mapper;

import io.github.autoffice.luckysheet.mapper.LuckySheetFactory;
import io.github.autoffice.luckysheet.model.image.ImagePosition;
import io.github.autoffice.luckysheet.model.image.ImageType;
import io.github.autoffice.luckysheet.model.image.SheetImage;
import io.github.autoffice.luckysheet.model.sheet.LuckySheet;
import io.github.autoffice.luckysheet.util.ImageUtil;
import io.github.autoffice.luckysheet.util.NumberUtil;
import java.awt.Dimension;
import java.util.List;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.util.ImageUtils;
import org.apache.poi.util.Units;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class ImageMapperToLuckySheet {
    public static void mapToSheet(XSSFSheet sheet, LuckySheet luckySheet) {
        XSSFDrawing drawingPatriarch = sheet.getDrawingPatriarch();
        if (drawingPatriarch == null) {
            return;
        }
        List shapes = drawingPatriarch.getShapes();
        for (XSSFShape shape : shapes) {
            if (!(shape instanceof XSSFPicture)) continue;
            XSSFPicture picture = (XSSFPicture)shape;
            String image = ImageUtil.toLuckySheetImage(picture.getPictureData().getData());
            SheetImage sheetImage = LuckySheetFactory.createImage();
            sheetImage.setSrc(image);
            sheetImage.setFixedPos(false);
            ImagePosition imagePosition = ImageMapperToLuckySheet.createImagePosition(sheet, picture);
            sheetImage.setPosition(imagePosition);
            sheetImage.setOriginWidth(imagePosition.getWidth());
            sheetImage.setOriginHeight(imagePosition.getHeight());
            sheetImage.getCrop().setWidth(imagePosition.getWidth());
            sheetImage.getCrop().setHeight(imagePosition.getHeight());
            sheetImage.getCrop().setOffsetLeft(0);
            sheetImage.getCrop().setOffsetTop(0);
            sheetImage.setType(ImageType.of(picture.getClientAnchor().getAnchorType()));
            luckySheet.getImages().put(ImageUtil.getLuckySheetImageId(), sheetImage);
        }
    }

    private static ImagePosition createImagePosition(XSSFSheet sheet, XSSFPicture picture) {
        Dimension dimensionFromAnchor = ImageUtils.getDimensionFromAnchor((Picture)picture);
        XSSFClientAnchor clientAnchor = picture.getClientAnchor();
        int topPixel = 0;
        for (int i = 0; i < clientAnchor.getRow1(); ++i) {
            XSSFRow row = sheet.getRow(i);
            float rowHeightInPoints = row == null ? sheet.getDefaultRowHeightInPoints() : row.getHeightInPoints();
            topPixel += Units.pointsToPixel((double)rowHeightInPoints);
        }
        topPixel += NumberUtil.emu2Pixel(clientAnchor.getDy1());
        float leftPixel = 0.0f;
        for (int i = 0; i < clientAnchor.getCol1(); ++i) {
            leftPixel += sheet.getColumnWidthInPixels(i);
        }
        ImagePosition imagePosition = new ImagePosition();
        imagePosition.setTop(topPixel);
        imagePosition.setLeft(Math.round(leftPixel += (float)NumberUtil.emu2Pixel(clientAnchor.getDx1())));
        imagePosition.setWidth(NumberUtil.emu2Pixel(dimensionFromAnchor.getWidth()));
        imagePosition.setHeight(NumberUtil.emu2Pixel(dimensionFromAnchor.getHeight()));
        return imagePosition;
    }
}

