/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.hard.signer;

import cfca.sadk.lib.crypto.hard.format.ECCFormatKey;
import cfca.sadk.lib.crypto.hard.format.HashLengths;
import cfca.sadk.lib.crypto.hard.generator.InternalPrivateKey;
import cfca.sadk.lib.crypto.hard.signer.AbsSigner;
import cfca.sadk.lib.crypto.hard.signer.ECCSignature;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.system.logging.LoggerManager;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.ECKey;

public final class ECCSigner
extends AbsSigner {
    private final String signByHashName;

    public ECCSigner(Provider provider, String mType, boolean asn1Format) throws Exception {
        super(provider, mType.toUpperCase().replace("ENCRYPTION", ""), asn1Format);
        this.signByHashName = "NoneWithECDSA";
    }

    PrivateKey formatPrivateKey(PrivateKey privateKey) throws Exception {
        PrivateKey jceKey = null;
        jceKey = privateKey instanceof InternalPrivateKey ? ((InternalPrivateKey)privateKey).getInternalPrivateKey() : ECCFormatKey.convertToProviderECCPrivateKey(this.provider, privateKey);
        return jceKey;
    }

    PublicKey formatPublicKey(PublicKey publicKey) throws Exception {
        return ECCFormatKey.convertToProviderECCPublicKey(this.provider, publicKey);
    }

    byte[] formatInputSignValue(byte[] input) throws Exception {
        return input;
    }

    byte[] formatOutputSignValue(byte[] signDataIn) throws Exception {
        ECCSignature signature;
        byte[] signDataOut = signDataIn;
        if (this.eccByteLength != 0 && signDataIn.length != (signDataOut = (signature = new ECCSignature(signDataIn, this.eccByteLength)).asn1Encoded()).length && LoggerManager.systemLogger.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("formatOutputSignValue: eccByteLength=").append(this.eccByteLength);
            builder.append(",signDataIn=").append(Hex.toHexString(signDataIn));
            builder.append(",signDataOut=").append(Hex.toHexString(signDataOut));
            LoggerManager.systemLogger.info(builder.toString());
        }
        return signDataOut;
    }

    public byte[] signByHash(PrivateKey privateKey, byte[] hashValue) throws Exception {
        HashLengths.checkHashLength(this.mType, hashValue);
        Signature signature = Signature.getInstance(this.signByHashName, this.provider);
        signature.initSign(this.formatPrivateKey(privateKey));
        signature.update(hashValue);
        byte[] signData = signature.sign();
        return this.formatOutputSignValue(signData);
    }

    public boolean verifyByHash(PublicKey publicKey, byte[] hashValue, byte[] signData) throws Exception {
        HashLengths.checkHashLength(this.mType, hashValue);
        Signature signature = Signature.getInstance(this.signByHashName, this.provider);
        signature.initVerify(this.formatPublicKey(publicKey));
        signature.update(hashValue);
        return signature.verify(this.formatInputSignValue(signData));
    }

    public int setEccLength(PrivateKey privateKey) throws Exception {
        int eccLength = 0;
        if (privateKey instanceof InternalPrivateKey) {
            eccLength = ((InternalPrivateKey)privateKey).eccLength();
        } else if (privateKey instanceof ECKey) {
            eccLength = ((ECKey)((Object)privateKey)).getParams().getCurve().getField().getFieldSize();
        }
        return (eccLength + 7) / 8;
    }
}

