/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.asn1;

import cfca.sadk.ofd.base.asn1.TBS_Sign;
import cfca.sadk.ofd.util.SysEnv;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import java.util.Enumeration;

public class SES_Signature
extends ASN1Object
implements PKCSObjectIdentifiers {
    private TBS_Sign toSign;
    private ASN1OctetString cert;
    private ASN1ObjectIdentifier signatureAlgorithm;
    private DERBitString signature;
    private DERBitString timestamp;
    private boolean isGBType = true;

    public static SES_Signature getInstance(Object o) {
        if (o instanceof SES_Signature) {
            return (SES_Signature)((Object)o);
        }
        if (o != null) {
            return new SES_Signature(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public SES_Signature(TBS_Sign toSign, ASN1OctetString cert, ASN1ObjectIdentifier signatureAlgorithm, DERBitString signature) {
        this.toSign = toSign;
        this.signature = signature;
        this.cert = cert;
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public SES_Signature(TBS_Sign toSign, ASN1OctetString cert, ASN1ObjectIdentifier signatureAlgorithm, DERBitString signature, DERBitString timestamp) {
        this.toSign = toSign;
        this.signature = signature;
        this.cert = cert;
        this.signatureAlgorithm = signatureAlgorithm;
        this.timestamp = timestamp;
    }

    public SES_Signature(ASN1Sequence instance) {
        Enumeration e = instance.getObjects();
        this.toSign = TBS_Sign.getInstance(e.nextElement());
        Object signInfo = e.nextElement();
        if (signInfo instanceof ASN1OctetString) {
            this.cert = ASN1OctetString.getInstance(signInfo);
            this.signatureAlgorithm = ASN1ObjectIdentifier.getInstance(e.nextElement());
            this.signature = DERBitString.getInstance(e.nextElement());
            if (e.hasMoreElements()) {
                this.timestamp = DERBitString.getInstance(e.nextElement());
            }
        } else {
            this.signature = DERBitString.getInstance(signInfo);
        }
    }

    public TBS_Sign getToSign() {
        return this.toSign;
    }

    public DERBitString getSignature() {
        return this.signature;
    }

    public ASN1OctetString getCert() {
        if (this.cert != null) {
            return this.cert;
        }
        return this.toSign.getCert();
    }

    public ASN1ObjectIdentifier getSignatureAlgorithm() {
        if (this.signatureAlgorithm != null) {
            return this.signatureAlgorithm;
        }
        return this.toSign.getSignatureAlgorithm();
    }

    public void setCert(ASN1OctetString cert) {
        this.cert = cert;
    }

    public void setSignatureAlgorithm(ASN1ObjectIdentifier signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public void setSignature(DERBitString signature) {
        this.signature = signature;
    }

    public void setToSign(TBS_Sign toSign) {
        this.toSign = toSign;
    }

    public void setTimestamp(DERBitString timestamp) {
        this.timestamp = timestamp;
    }

    public DERBitString getTimestamp() {
        return this.timestamp;
    }

    public boolean isGBType() {
        return this.isGBType;
    }

    public void setGBType(boolean gBType) {
        this.isGBType = gBType;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.toSign);
        if (this.isGBType || SysEnv.isGBType()) {
            if (this.cert != null) {
                v.add((ASN1Encodable)this.cert);
            }
            if (this.signatureAlgorithm != null) {
                v.add((ASN1Encodable)this.signatureAlgorithm);
            }
            v.add((ASN1Encodable)this.signature);
            if (this.timestamp != null) {
                v.add((ASN1Encodable)this.timestamp);
            }
        } else {
            v.add((ASN1Encodable)this.signature);
        }
        return new DERSequence(v);
    }
}

