/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zzAW;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.zzZIQ;
import com.aspose.words.zzZJ4;
import com.aspose.words.zzZJ9;
import com.aspose.words.zzZRS;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzZRS,
Iterable<T> {
    private CompositeNode zzYVV;
    private DocumentBase zz38;
    private boolean zzZpD;
    private int zzYVU;
    private int zzYVT;
    private Node zzYVS;
    private int zzZF;
    private zzZJ4 zzYVR;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, new zzZIQ(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, zzZJ4 matcher, boolean isDeep) {
        if (container == null) {
            throw new IllegalArgumentException("container");
        }
        if (matcher == null) {
            throw new IllegalArgumentException("matcher");
        }
        this.zzYVV = container;
        this.zz38 = container.getDocument();
        this.zzYVR = matcher;
        this.zzZpD = isDeep;
        this.invalidate();
    }

    public Node get(int index) {
        try {
            this.zzZti();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzYVT == index) {
                return this.zzYVS;
            }
            int n = index - this.zzYVT;
            Node node = this.zzR(this.zzYVS, n);
            if (node != null) {
                this.zzYVT = index;
                this.zzYVS = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzZpD) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzYVV.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzZpD) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzYVV.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        return (Node[])zzAW.zzZ(this.zzZtj(), Node.class);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZJ9(this);
    }

    ArrayList zzZtj() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzAW.zzZ(arrayList, node);
        }
        return arrayList;
    }

    private Node zzR(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            Node[] nodeArray = new Node[]{node2};
            this.zzZ(nodeArray, bl);
            node2 = nodeArray[0];
            if (node2 != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node[] curNode) throws Exception {
        return this.zzZ(curNode, true);
    }

    private Node zzZ(Node[] nodeArray, boolean bl) throws Exception {
        Node node;
        do {
            node = nodeArray[0];
            Node node2 = this.zzZpD ? this.zzZ(bl, nodeArray[0]) : (nodeArray[0] = this.zzYVR.zzZsR() ? this.zzX(bl, nodeArray[0]) : this.zzY(bl, nodeArray[0]));
        } while (nodeArray[0] != null && !this.zzYVR.zzZZ(nodeArray[0]));
        return node;
    }

    private Node zzZ(boolean bl, Node node) {
        return bl ? node.nextPreOrder(this.zzYVV) : node.previousPreOrder(this.zzYVV);
    }

    private Node zzY(boolean bl, Node node) {
        if (bl) {
            return node == this.zzYVV ? this.zzYVV.getFirstChild() : node.getNextSibling();
        }
        return node == this.zzYVV ? this.zzYVV.getLastChild() : node.getPreviousSibling();
    }

    private Node zzX(boolean bl, Node node) {
        if (bl) {
            return node == this.zzYVV ? this.zzYVV.zznU() : node.zzZtu();
        }
        return node == this.zzYVV ? this.zzYVV.zznT() : node.zzZtv();
    }

    private void zzZti() {
        if (this.zzYVU != this.zzZth()) {
            this.invalidate();
        }
    }

    private void invalidate() {
        this.zzYVU = this.zzZth();
        this.zzYVT = -1;
        this.zzYVS = this.zzYVV;
        this.zzZF = -1;
    }

    private int zzZth() {
        return this.zz38 != null ? this.zz38.zzZZE() : 0;
    }

    public int getCount() {
        this.zzZti();
        if (this.zzZF == -1) {
            this.zzZF = zzZJ9.zzZ(this);
        }
        return this.zzZF;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzYVV;
    }
}

