/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.api;

import cfca.sadk.org.bouncycastle.crypto.digests.MD5Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA256Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA512Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import cfca.sadk.timestamp.client.bean.HashAlgorithm;
import cfca.sadk.timestamp.client.bean.MessageImprint;
import cfca.sadk.timestamp.exception.TSAErrorCode;
import cfca.sadk.timestamp.exception.TSAException;
import java.io.InputStream;

public enum CreateMessageImprint {
    WITH_SM3_AND(HashAlgorithm.SM3),
    WITH_SHA1_AND(HashAlgorithm.SHA1),
    WITH_SHA256_AND(HashAlgorithm.SHA256),
    WITH_SHA512_AND(HashAlgorithm.SHA512),
    WITH_MD5TEST_AND(HashAlgorithm.MD5TEST);

    private static final int BUFFER_SIZE = 16384;
    private final HashAlgorithm hashAlgorithm;

    private CreateMessageImprint(HashAlgorithm hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public MessageImprint sourceMessage(byte[] sourceMessage) throws TSAException {
        return this.buildMessageImprint(sourceMessage, null);
    }

    public MessageImprint sourceStream(InputStream sourceStream) throws TSAException {
        return this.buildMessageImprint(null, sourceStream);
    }

    public MessageImprint hashedMessage(byte[] hashedMessage) throws TSAException {
        return new MessageImprint(this.hashAlgorithm, hashedMessage);
    }

    private final MessageImprint buildMessageImprint(byte[] sourceMessage, InputStream sourceStream) throws TSAException {
        SM3Digest digest;
        switch (this.hashAlgorithm) {
            case SM3: {
                digest = new SM3Digest();
                break;
            }
            case SHA1: {
                digest = new SHA1Digest();
                break;
            }
            case SHA256: {
                digest = new SHA256Digest();
                break;
            }
            case SHA512: {
                digest = new SHA512Digest();
                break;
            }
            case MD5TEST: {
                digest = new MD5Digest();
                break;
            }
            default: {
                throw new TSAException(TSAErrorCode.timestampClientMessageImprintInvalidHashAlgorithm, "hashAlgorithm invalid: " + (Object)((Object)this.hashAlgorithm));
            }
        }
        if (sourceMessage != null) {
            digest.update(sourceMessage, 0, sourceMessage.length);
        } else if (sourceStream != null) {
            try {
                byte[] buffer = new byte[16384];
                int readLength = 0;
                while ((readLength = sourceStream.read(buffer)) > 0) {
                    digest.update(buffer, 0, readLength);
                }
            }
            catch (Exception e) {
                throw new TSAException(TSAErrorCode.timestampClientMessageImprintBuildFailure, "update failure: " + (Object)((Object)this.hashAlgorithm), (Throwable)e);
            }
        } else {
            throw new TSAException(TSAErrorCode.timestampClientMessageImprintMissingSourceData, "hashAlgorithm invalid: " + (Object)((Object)this.hashAlgorithm));
        }
        byte[] hashedMessage = new byte[digest.getDigestSize()];
        try {
            digest.doFinal(hashedMessage, 0);
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timestampClientMessageImprintBuildFailure, "doFinal failure: " + (Object)((Object)this.hashAlgorithm), (Throwable)e);
        }
        MessageImprint messageImprint = new MessageImprint(this.hashAlgorithm, hashedMessage);
        return messageImprint;
    }
}

