/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.message;

import cfca.sadk.tls.sun.security.ssl.HandshakeOutStream;
import cfca.sadk.tls.sun.security.ssl.message.HandshakeType;
import cfca.sadk.tls.util.Hexifys;
import cfca.sadk.tls.util.Utilities;
import java.io.IOException;
import java.math.BigInteger;
import javax.net.ssl.SSLException;

public abstract class HandshakeMessage
implements HandshakeType {
    static final byte[] MD5_pad1 = HandshakeMessage.genPad(54, 48);
    static final byte[] MD5_pad2 = HandshakeMessage.genPad(92, 48);
    static final byte[] SHA_pad1 = HandshakeMessage.genPad(54, 40);
    static final byte[] SHA_pad2 = HandshakeMessage.genPad(92, 40);

    HandshakeMessage() {
    }

    static byte[] toByteArray(BigInteger bi) {
        byte[] data = bi.toByteArray();
        if (data.length > 1 && data[0] == 0) {
            int n = data.length - 1;
            byte[] newarray = new byte[n];
            System.arraycopy(data, 1, newarray, 0, newarray.length);
            data = newarray;
        }
        return data;
    }

    private static byte[] genPad(int b, int count) {
        byte[] padding = new byte[count];
        Utilities.fill(padding, (byte)b);
        return padding;
    }

    public final void write(HandshakeOutStream out) throws IOException {
        int len = this.messageLength();
        if (len >= 0x1000000) {
            throw new SSLException("Handshake message too big, type = " + this.messageType() + ", len = " + len);
        }
        out.write(this.messageType());
        out.putInt24(len);
        this.send(out);
    }

    public abstract int messageType();

    abstract int messageLength();

    abstract void send(HandshakeOutStream var1) throws IOException;

    final void builderAppend(StringBuilder builder, String prefix, byte[] data) {
        if (builder == null) {
            return;
        }
        builder.append(prefix);
        if (data == null) {
            builder.append("null");
        } else {
            builder.append("0x").append(Hexifys.hexify(data));
        }
        builder.append("\n ");
    }
}

