/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.hard.generator;

import cfca.sadk.extend.session.ECCCurveId;
import java.security.PrivateKey;

public final class InternalPrivateKey
implements PrivateKey {
    private static final long serialVersionUID = -5989155975738140758L;
    private final PrivateKey privateKey;
    private final ECCCurveId curveId;
    private final int keyIndex;

    public InternalPrivateKey(PrivateKey privateKey, ECCCurveId curveId, int keyIndex) {
        this.privateKey = privateKey;
        this.curveId = curveId;
        this.keyIndex = keyIndex;
    }

    public static InternalPrivateKey from(PrivateKey privateKey, ECCCurveId curveId, int keyIndex) {
        InternalPrivateKey internalPrivateKey = null;
        internalPrivateKey = privateKey instanceof InternalPrivateKey ? (InternalPrivateKey)privateKey : new InternalPrivateKey(privateKey, curveId, keyIndex);
        return internalPrivateKey;
    }

    public String getAlgorithm() {
        return this.privateKey.getAlgorithm();
    }

    public String getFormat() {
        return this.privateKey.getFormat();
    }

    public ECCCurveId getCurveId() {
        return this.curveId;
    }

    public int getKeyIndex() {
        return this.keyIndex;
    }

    public int eccLength() {
        return this.curveId == null ? 0 : this.curveId.getCurveBitLength();
    }

    public byte[] getEncoded() {
        return this.privateKey.getEncoded();
    }

    public PrivateKey getInternalPrivateKey() {
        return this.privateKey;
    }
}

