/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.rsa;

import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;

public final class RSAOperation {
    private RSAOperation() {
    }

    public static boolean checkCRTKeyPQ(RSAPrivateCrtKey privateKey) throws Exception {
        boolean passed = false;
        if (privateKey != null) {
            passed = !BigInteger.ZERO.equals(privateKey.getPrimeP()) && !BigInteger.ZERO.equals(privateKey.getPrimeQ());
        }
        return passed;
    }

    public static int dowithPrivateKey(RSAPrivateKey privateKey, byte[] input, byte[] output) throws Exception {
        if (privateKey == null) {
            throw new SecurityException("dowithPrivateKey failure with privateKey is null");
        }
        BigInteger modulus = privateKey.getModulus();
        BigInteger privateExponent = privateKey.getPrivateExponent();
        if (BigInteger.ZERO.equals(modulus) || BigInteger.ZERO.equals(privateExponent)) {
            throw new SecurityException("dowithPrivateKey failure with modulus/exponent is zero");
        }
        int modulusLength = (modulus.bitLength() + 7) / 8;
        if (input == null || input.length != modulusLength) {
            throw new SecurityException("dowithPrivateKey failure with input is null/length!=" + modulusLength);
        }
        if (output == null || output.length != modulusLength) {
            throw new SecurityException("dowithPrivateKey failure with output is null/length!=" + modulusLength);
        }
        BigInteger inputInt = new BigInteger(1, input);
        if (inputInt.compareTo(modulus) != -1) {
            throw new SecurityException("dowithPrivateKey failure with inputInt >= modulus");
        }
        BigInteger outputInt = inputInt.modPow(privateExponent, modulus);
        byte[] outputBytes = outputInt.toByteArray();
        if (outputBytes.length <= output.length) {
            System.arraycopy(outputBytes, 0, output, modulusLength - outputBytes.length, outputBytes.length);
        } else {
            System.arraycopy(outputBytes, outputBytes.length - modulusLength, output, 0, output.length);
        }
        return outputBytes.length;
    }
}

