/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util.p12;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.SecureRandoms;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.sadk.x509.certificate.X509CertGenerator;
import java.math.BigInteger;
import java.security.KeyPair;
import java.util.Date;
import java.util.Random;

class P12FileUtil {
    static volatile Session session = null;

    private P12FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final Session session() throws PKIException {
        if (session != null) return session;
        Class<Session> clazz = Session.class;
        synchronized (Session.class) {
            if (session != null) return session;
            try {
                String deviceName = "JSOFT_LIB";
                JCrypto.getInstance().initialize("JSOFT_LIB", null);
                session = JCrypto.getInstance().openSession("JSOFT_LIB");
            }
            catch (PKIException e) {
                throw new PKIException("Open session failure: " + e.getMessage());
            }
            return session;
        }
    }

    static X509Cert signedMyselfCert(Session session, KeyPair keypair, String keyType) throws Exception {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SignedMyselfCert::>>>>>>Running");
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            buffer.append("\n keyType: ");
            buffer.append(SADKDebugger.dump(keyType));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            String algorithm;
            X509CertGenerator gen = new X509CertGenerator();
            if ("SM2".equals(keyType)) {
                algorithm = "sm3WithSM2Encryption";
            } else if ("RSA".equals(keyType)) {
                algorithm = "sha256WithRSAEncryption";
            } else if ("ECC".equals(keyType)) {
                algorithm = "sha256WithECDSAEncryption";
            } else {
                throw new PKIException("SignedMyselfCert failure: do not support keyType=" + keyType);
            }
            String testDN = String.format("CN=%s P10 AGENT %s,OU=CFCA SADK P10 ,O=CFCA TEST,C=CN", keyType, P12FileUtil.generateRandom());
            gen.setIssuer(testDN);
            gen.setSubject(testDN);
            gen.setSerialNumber(BigInteger.valueOf(0x7B000000 + new Random().nextInt(10000000)));
            gen.setNotAfter(new Date());
            gen.setNotBefore(new Date());
            gen.setPublicKey(keypair.getPublic());
            gen.setSignatureAlg(algorithm);
            byte[] encoding = gen.generateX509Cert(keypair.getPrivate(), session);
            X509Cert x509Cert = new X509Cert(encoding);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("SignedMyselfCert<<<<<<Finished: X509Cert=" + SADKDebugger.dump(x509Cert));
            }
            return x509Cert;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("SignedMyselfCert::<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SignedMyselfCert::<<<<<<Failure", e);
            throw new PKIException("SignedMyselfCert Failure", e);
        }
    }

    static String generateRandom() {
        return Base64.toBase64String(SecureRandoms.getInstance().genBytes(6)).replace("+", "-").replace("/", "_");
    }
}

