/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.data;

import cfca.com.google.typography.font.sfntly.data.ByteArray;
import cfca.com.google.typography.font.sfntly.math.FontMath;
import java.util.ArrayList;
import java.util.List;

final class SegmentedGrowableMemoryByteArray
extends ByteArray<SegmentedGrowableMemoryByteArray> {
    private static final int DEFAULT_BUFFER_LOW_BITS = 8;
    private List<byte[]> buffers = new ArrayList<byte[]>();
    private final int lowBits;

    public SegmentedGrowableMemoryByteArray() {
        this(8);
    }

    public SegmentedGrowableMemoryByteArray(int lowBits) {
        super(0, Integer.MAX_VALUE, true);
        this.lowBits = lowBits;
    }

    @Override
    protected void internalPut(int index, byte b) {
        int bufferIndex = this.bufferIndex(index);
        int bufferOffset = this.bufferOffset(bufferIndex, index);
        byte[] buffer = this.buffer(bufferIndex);
        buffer[bufferOffset] = b;
    }

    @Override
    protected int internalPut(int index, byte[] b, int offset, int length) {
        int copyCount;
        int copyLength;
        for (copyCount = 0; copyCount < length; copyCount += copyLength) {
            int bufferIndex = this.bufferIndex(index);
            int bufferOffset = this.bufferOffset(bufferIndex, index);
            byte[] buffer = this.buffer(bufferIndex);
            copyLength = Math.min(length - copyCount, buffer.length - bufferOffset);
            System.arraycopy(b, offset, buffer, bufferOffset, copyLength);
            index += copyLength;
            offset += copyLength;
        }
        return copyCount;
    }

    @Override
    protected int internalGet(int index) {
        int bufferIndex = this.bufferIndex(index);
        int bufferOffset = this.bufferOffset(bufferIndex, index);
        byte[] buffer = this.buffer(bufferIndex);
        return buffer[bufferOffset];
    }

    @Override
    protected int internalGet(int index, byte[] b, int offset, int length) {
        int copyCount;
        int copyLength;
        for (copyCount = 0; copyCount < length; copyCount += copyLength) {
            int bufferIndex = this.bufferIndex(index);
            int bufferOffset = this.bufferOffset(bufferIndex, index);
            byte[] buffer = this.buffer(bufferIndex);
            copyLength = Math.min(length - copyCount, buffer.length - bufferOffset);
            System.arraycopy(buffer, bufferOffset, b, offset, copyLength);
            index += copyLength;
            offset += copyLength;
        }
        return copyCount;
    }

    @Override
    public void close() {
        this.buffers = null;
    }

    private int bufferOffset(int bufferIndex, int index) {
        return index & ~(1 << Math.max(this.lowBits, bufferIndex + this.lowBits - 1));
    }

    private int bufferIndex(int index) {
        return FontMath.log2(index >> this.lowBits) + 1;
    }

    private byte[] buffer(int index) {
        byte[] b = null;
        if (index >= this.buffers.size()) {
            for (int i = this.buffers.size(); i < index + 1; ++i) {
                int bufferSize = 1 << Math.max(0, i - 1) + this.lowBits;
                b = new byte[bufferSize];
                this.buffers.add(b);
            }
        }
        b = this.buffers.get(index);
        return b;
    }
}

