/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.data;

import cfca.com.google.typography.font.sfntly.data.ByteArray;
import cfca.com.google.typography.font.sfntly.data.GrowableMemoryByteArray;
import cfca.com.google.typography.font.sfntly.data.MemoryByteArray;
import cfca.com.google.typography.font.sfntly.data.ReadableFontData;
import java.io.IOException;
import java.io.InputStream;

public final class WritableFontData
extends ReadableFontData {
    public static final WritableFontData createWritableFontData(int length) {
        ByteArray ba = null;
        if (length > 0) {
            ba = new MemoryByteArray(length);
            ba.setFilledLength(length);
        } else {
            ba = new GrowableMemoryByteArray();
        }
        WritableFontData wfd = new WritableFontData(ba);
        return wfd;
    }

    public static final WritableFontData createWritableFontData(byte[] b) {
        MemoryByteArray ba = new MemoryByteArray(b);
        WritableFontData wfd = new WritableFontData(ba);
        return wfd;
    }

    public static final WritableFontData createWritableFontData(ReadableFontData original) {
        ByteArray ba = null;
        ba = original.array.growable() ? new GrowableMemoryByteArray() : new MemoryByteArray(original.array.length());
        original.array.copyTo(ba);
        WritableFontData wfd = new WritableFontData(ba);
        wfd.setCheckSumRanges(original.checkSumRange());
        return wfd;
    }

    private WritableFontData(ByteArray<? extends ByteArray<?>> array) {
        super(array);
    }

    private WritableFontData(WritableFontData data, int offset) {
        super(data, offset);
    }

    private WritableFontData(WritableFontData data, int offset, int length) {
        super(data, offset, length);
    }

    @Override
    public WritableFontData slice(int offset, int length) {
        if (offset < 0 || length < 0 || offset > Integer.MAX_VALUE - length || offset + length > this.size()) {
            throw new IndexOutOfBoundsException("Attempt to bind data outside of its limits.");
        }
        WritableFontData slice = new WritableFontData(this, offset, length);
        return slice;
    }

    @Override
    public WritableFontData slice(int offset) {
        if (offset < 0 || offset > this.size()) {
            throw new IndexOutOfBoundsException("Attempt to bind data outside of its limits.");
        }
        WritableFontData slice = new WritableFontData(this, offset);
        return slice;
    }

    public int writeByte(int index, byte b) {
        this.array.put(this.boundOffset(index), b);
        return 1;
    }

    public int writeBytes(int index, byte[] b, int offset, int length) {
        return this.array.put(this.boundOffset(index), b, offset, this.boundLength(index, length));
    }

    public int writeBytesPad(int index, byte[] b, int offset, int length, byte pad) {
        int written = this.array.put(this.boundOffset(index), b, offset, this.boundLength(index, Math.min(length, b.length - offset)));
        written += this.writePadding(written + index, length - written, pad);
        return written;
    }

    public int writePadding(int index, int count) {
        return this.writePadding(index, count, (byte)0);
    }

    public int writePadding(int index, int count, byte pad) {
        for (int i = 0; i < count; ++i) {
            this.array.put(index + i, pad);
        }
        return count;
    }

    public int writeBytes(int index, byte[] b) {
        return this.writeBytes(index, b, 0, b.length);
    }

    public int writeChar(int index, byte c) {
        return this.writeByte(index, c);
    }

    public int writeUShort(int index, int us) {
        this.writeByte(index, (byte)(us >> 8 & 0xFF));
        this.writeByte(index + 1, (byte)(us & 0xFF));
        return 2;
    }

    public int writeUShortLE(int index, int us) {
        this.array.put(index, (byte)(us & 0xFF));
        this.array.put(index + 1, (byte)(us >> 8 & 0xFF));
        return 2;
    }

    public int writeShort(int index, int s) {
        return this.writeUShort(index, s);
    }

    public int writeUInt24(int index, int ui) {
        this.writeByte(index, (byte)(ui >> 16 & 0xFF));
        this.writeByte(index + 1, (byte)(ui >> 8 & 0xFF));
        this.writeByte(index + 2, (byte)(ui & 0xFF));
        return 3;
    }

    public int writeULong(int index, long ul) {
        this.writeByte(index, (byte)(ul >> 24 & 0xFFL));
        this.writeByte(index + 1, (byte)(ul >> 16 & 0xFFL));
        this.writeByte(index + 2, (byte)(ul >> 8 & 0xFFL));
        this.writeByte(index + 3, (byte)(ul & 0xFFL));
        return 4;
    }

    public int writeULongLE(int index, long ul) {
        this.array.put(index, (byte)(ul & 0xFFL));
        this.array.put(index + 1, (byte)(ul >> 8 & 0xFFL));
        this.array.put(index + 2, (byte)(ul >> 16 & 0xFFL));
        this.array.put(index + 3, (byte)(ul >> 24 & 0xFFL));
        return 4;
    }

    public int writeLong(int index, long l) {
        return this.writeULong(index, l);
    }

    public int writeFixed(int index, int f) {
        return this.writeLong(index, f);
    }

    public int writeDateTime(int index, long date) {
        this.writeULong(index, date >> 32 & 0xFFFFFFFFFFFFFFFFL);
        this.writeULong(index + 4, date & 0xFFFFFFFFFFFFFFFFL);
        return 8;
    }

    public void copyFrom(InputStream is, int length) throws IOException {
        this.array.copyFrom(is, length);
    }

    public void copyFrom(InputStream is) throws IOException {
        this.array.copyFrom(is);
    }
}

