/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.tools.sfnttool;

import cfca.com.google.typography.font.sfntly.Font;
import cfca.com.google.typography.font.sfntly.Tag;
import cfca.com.google.typography.font.sfntly.table.core.CMap;
import cfca.com.google.typography.font.sfntly.table.core.CMapTable;
import cfca.com.google.typography.font.sfntly.table.truetype.CompositeGlyph;
import cfca.com.google.typography.font.sfntly.table.truetype.Glyph;
import cfca.com.google.typography.font.sfntly.table.truetype.GlyphTable;
import cfca.com.google.typography.font.sfntly.table.truetype.LocaTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GlyphCoverage {
    public static final String SORTEDGLYPHS = "sortedGlyphs";
    public static final String ORIGINGLYPHS = "originGlyphs";

    public static HashMap<String, List<Integer>> getGlyphCoverage(Font font, String string) {
        HashMap<String, List<Integer>> resultMap = new HashMap<String, List<Integer>>();
        ArrayList<Integer> glyphs = new ArrayList<Integer>();
        CMapTable cmapTable = (CMapTable)font.getTable(Tag.cmap);
        if (null == cmapTable) {
            throw new IllegalArgumentException("cmap is null!");
        }
        CMap cmap = GlyphCoverage.getBestCMap(cmapTable);
        HashSet<Integer> coverage = new HashSet<Integer>();
        coverage.add(0);
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            int c = string.charAt(i) & 0xFFFF;
            if (string.codePointAt(i) != string.charAt(i)) {
                c = string.codePointAt(i) & 0xFFFFFFFF;
                ++i;
            }
            int glyphId = cmap.glyphId(c);
            glyphs.add(new Integer(glyphId));
            GlyphCoverage.touchGlyph(font, coverage, glyphId);
        }
        ArrayList sortedCoverage = new ArrayList(coverage);
        Collections.sort(sortedCoverage);
        resultMap.put(SORTEDGLYPHS, sortedCoverage);
        resultMap.put(ORIGINGLYPHS, glyphs);
        return resultMap;
    }

    private static void touchGlyph(Font font, Set<Integer> coverage, int glyphId) {
        if (!coverage.contains(glyphId)) {
            coverage.add(glyphId);
            Glyph glyph = GlyphCoverage.getGlyph(font, glyphId);
            if (glyph != null && glyph.glyphType() == Glyph.GlyphType.Composite) {
                CompositeGlyph composite = (CompositeGlyph)glyph;
                for (int i = 0; i < composite.numGlyphs(); ++i) {
                    GlyphCoverage.touchGlyph(font, coverage, composite.glyphIndex(i));
                }
            }
        }
    }

    private static CMap getBestCMap(CMapTable cmapTable) {
        for (CMap cmap : cmapTable) {
            if (cmap.format() != CMap.CMapFormat.Format12.value()) continue;
            return cmap;
        }
        for (CMap cmap : cmapTable) {
            if (cmap.format() != CMap.CMapFormat.Format4.value()) continue;
            return cmap;
        }
        return null;
    }

    private static Glyph getGlyph(Font font, int glyphId) {
        LocaTable locaTable = (LocaTable)font.getTable(Tag.loca);
        GlyphTable glyfTable = (GlyphTable)font.getTable(Tag.glyf);
        int offset = locaTable.glyphOffset(glyphId);
        int length = locaTable.glyphLength(glyphId);
        return glyfTable.glyph(offset, length);
    }
}

