/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.common;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.ofd.base.common.CrlManager;
import cfca.sadk.ofd.base.exception.SealException;
import cfca.sadk.ofd.util.SysEnv;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.x509.Extension;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.sadk.x509.certificate.X509CertVerifier;
import java.util.Date;

public class CertVerifyUtil {
    private static final Logger logger = LoggerFactory.getLogger(CertVerifyUtil.class);
    public static final String OCA32 = "oca32";

    public static boolean verifyCertSign(X509Cert x509Cert) throws PKIException, SealException {
        if (null == x509Cert) {
            throw new IllegalArgumentException("x509Cert is null!");
        }
        if (!SysEnv.isTrustCertLoaded()) {
            throw new SealException("TrustCerts File is not loaded,invoke SysEnv.loadTrustCerts() first!");
        }
        return X509CertVerifier.validateCertSign((X509Cert)x509Cert);
    }

    public static boolean verifyByCRL(X509Cert userCert, Date signDate) throws SealException {
        if (null == userCert) {
            throw new IllegalArgumentException("userCert is null!");
        }
        long start = System.currentTimeMillis();
        logger.info("verifyByCRL start...");
        boolean isSignAfterRevoke = false;
        try {
            String sn;
            String issuer = CertVerifyUtil.formatIssuerKey(userCert.getIssuer());
            if (issuer.indexOf(OCA32) == -1 && CrlManager.isRevoked(sn = userCert.getSerialNumber().toString(16), signDate)) {
                isSignAfterRevoke = true;
            }
            boolean bl = isSignAfterRevoke;
            return bl;
        }
        catch (Exception e) {
            logger.error("verifyByCRL failed:", (Throwable)e);
            throw new SealException("verifyByCRL failed:", e);
        }
        finally {
            long end = System.currentTimeMillis();
            logger.info("verifyByCRL end...cost=" + (end - start) + " ms");
        }
    }

    public static boolean verifyByCRL(X509Cert userCert) throws SealException {
        return CertVerifyUtil.verifyByCRL(userCert, new Date());
    }

    public static boolean[] getCertKeyUsage(X509Cert userCert) throws Exception {
        boolean[] keyUsage;
        byte[] extData = userCert.getExtensionByteData(Extension.keyUsage);
        if (extData != null) {
            DERBitString bits = DERBitString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])extData));
            int length = (extData = bits.getBytes()).length * 8 - bits.getPadBits();
            keyUsage = new boolean[length < 9 ? 9 : length];
            for (int i = 0; i != length; ++i) {
                keyUsage[i] = (extData[i / 8] & 128 >>> i % 8) != 0;
            }
        } else {
            keyUsage = null;
        }
        return keyUsage;
    }

    public static boolean verifyKeyUsageForDS(X509Cert userCert) throws Exception {
        boolean isForDS = false;
        boolean[] keyUsage = CertVerifyUtil.getCertKeyUsage(userCert);
        if (keyUsage[0]) {
            isForDS = true;
        }
        return isForDS;
    }

    public static String formatIssuerKey(String issuer) {
        return CertVerifyUtil.formatSubject(issuer).replaceAll(" ", "_").toLowerCase();
    }

    public static String formatSubject(String dn) {
        dn = CertVerifyUtil.clearSpace(dn, ",");
        dn = CertVerifyUtil.clearSpace(dn, "=");
        return dn;
    }

    public static String clearSpace(String target, String operator) {
        String[] items = target.split(operator);
        StringBuffer result = new StringBuffer();
        for (String item : items) {
            result.append(operator + item.trim());
        }
        return result.toString().substring(1);
    }
}

