/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.common;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import com.sun.imageio.plugins.png.PNGMetadata;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DpiUtils {
    private static final Logger log = LoggerFactory.getLogger(DpiUtils.class);
    private static final double INCH_2_CM = 2.54;
    private static final String PNG = "png";
    private static final String NODEFORMAT = "javax_imageio_1.0";
    private static final String DIMENSION = "Dimension";
    private static final String HORIZONTAL_PIXEL_SIZE = "HorizontalPixelSize";
    private static final String VERTICAL_PIXEL_SIZE = "VerticalPixelSize";
    private static final String ATTRNAME = "value";

    public static double[] getPngDpi(byte[] imageData) throws IOException {
        double[] dpis = new double[2];
        ImageReader imageReader = ImageIO.getImageReadersByFormatName(PNG).next();
        imageReader.setInput(ImageIO.createImageInputStream(new ByteArrayInputStream(imageData)), true);
        IIOMetadata metadata = imageReader.getImageMetadata(0);
        PNGMetadata pngmeta = (PNGMetadata)metadata;
        Node imageNode = pngmeta.getAsTree(NODEFORMAT);
        NodeList childNodes = imageNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!node.getNodeName().equals(DIMENSION)) continue;
            NodeList list = node.getChildNodes();
            for (int j = 0; j < list.getLength(); ++j) {
                Node xx;
                if (list.item(j).getNodeName().equals(HORIZONTAL_PIXEL_SIZE)) {
                    xx = list.item(j).getAttributes().getNamedItem(ATTRNAME);
                    dpis[0] = Math.round(25.4 / Double.valueOf(xx.getNodeValue()));
                    continue;
                }
                if (!list.item(j).getNodeName().equals(VERTICAL_PIXEL_SIZE)) continue;
                xx = list.item(j).getAttributes().getNamedItem(ATTRNAME);
                dpis[1] = Math.round(25.4 / Double.valueOf(xx.getNodeValue()));
            }
        }
        return dpis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] process(BufferedImage image, int dpi) throws MalformedURLException, IOException {
        ByteArrayOutputStream output = null;
        byte[] result = null;
        Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName(PNG);
        while (iw.hasNext()) {
            ImageWriter writer = iw.next();
            ImageWriteParam writeParam = writer.getDefaultWriteParam();
            ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
            IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
            if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
            output = new ByteArrayOutputStream();
            ImageOutputStream stream = null;
            try {
                DpiUtils.setDPI(metadata, dpi);
                stream = ImageIO.createImageOutputStream(output);
                writer.setOutput(stream);
                writer.write(metadata, new IIOImage(image, null, metadata), writeParam);
                result = output.toByteArray();
            }
            finally {
                try {
                    if (null != stream) {
                        stream.close();
                        stream = null;
                    }
                }
                catch (IOException e) {
                    log.error("[[DpiUtils.process]] IOException", (Throwable)e);
                    throw e;
                }
            }
            if (null == result) continue;
            break;
        }
        return result;
    }

    private static void setDPI(IIOMetadata metadata, int dpi) throws IIOInvalidTreeException {
        double dotsPerMilli = 1.0 * (double)dpi / 10.0 / 2.54;
        IIOMetadataNode horiz = new IIOMetadataNode(HORIZONTAL_PIXEL_SIZE);
        horiz.setAttribute(ATTRNAME, Double.toString(dotsPerMilli));
        IIOMetadataNode vert = new IIOMetadataNode(VERTICAL_PIXEL_SIZE);
        vert.setAttribute(ATTRNAME, Double.toString(dotsPerMilli));
        IIOMetadataNode dim = new IIOMetadataNode(DIMENSION);
        dim.appendChild(horiz);
        dim.appendChild(vert);
        IIOMetadataNode root = new IIOMetadataNode(NODEFORMAT);
        root.appendChild(dim);
        metadata.mergeTree(NODEFORMAT, root);
    }
}

