/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.ofd.base.bean.appearance.GraphicAppearance;
import cfca.sadk.ofd.base.bean.appearance.TextAppearance;
import cfca.sadk.ofd.base.common.ParamCheckUtil;
import cfca.sadk.ofd.base.common.ZipUtil;
import cfca.sadk.ofd.base.config.VersionInfo;
import cfca.sadk.ofd.base.exception.SealException;
import cfca.sadk.ofd.base.ofd.OFDConstants;
import cfca.sadk.ofd.base.ofd.Rectangle;
import cfca.sadk.ofd.base.seal.SealXMLUtil;
import cfca.sadk.ofd.base.seal.TemplateXMLUtil;
import cfca.sadk.ofd.util.ContentUtil;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.dom4j.Element;

public class WatermarkUtil {
    private static Logger businessLog = LoggerFactory.getLogger(WatermarkUtil.class);

    public static void addImageWatermark(InputStream inputStream, OutputStream outputStream, byte[] imageData, PageRangeOption pageRangeOption, WatermarkOption waterMarkOption) throws SealException {
        long start = System.currentTimeMillis();
        businessLog.info("addImageWatermark start...");
        if (null == inputStream) {
            throw new IllegalArgumentException("inputStream is null!");
        }
        if (null == imageData) {
            throw new IllegalArgumentException("imageData is null!");
        }
        try {
            float upwardY;
            float downwardY;
            GraphicAppearance appearance;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)output);
            byte[] ofdDatas = output.toByteArray();
            Map<String, byte[]> filesMap = ZipUtil.uncompress(new ByteArrayInputStream(ofdDatas));
            int pages = SealXMLUtil.getTotalPages(filesMap);
            float absoluteX = waterMarkOption.getAbsoluteX();
            float absoluteY = waterMarkOption.getAbsoluteY();
            float fitWidth = waterMarkOption.getFitWidth();
            float fitHeight = waterMarkOption.getFitHeight();
            double rotationDegree = waterMarkOption.getRotationDegree();
            int alpha = waterMarkOption.getAlpha();
            float apartX = waterMarkOption.getApartX();
            float apartY = waterMarkOption.getApartY();
            boolean ifBeddingX = false;
            boolean ifBeddingY = false;
            if ((double)Math.abs(1.0f + apartX) > 1.0E-4) {
                ifBeddingX = true;
            }
            if ((double)Math.abs(1.0f + apartY) > 1.0E-4) {
                ifBeddingY = true;
            }
            int fromPage = pageRangeOption.getFromPage();
            int toPage = pageRangeOption.getToPage();
            if (toPage == -1) {
                toPage = pages;
            }
            ParamCheckUtil.checkPageNum(fromPage, pages);
            ParamCheckUtil.checkPageNum(toPage, pages);
            int step = 1;
            int i = fromPage;
            String baseDir = SealXMLUtil.getBaseDir(filesMap);
            Element root = SealXMLUtil.getDocument(filesMap, baseDir);
            ArrayList<GraphicAppearance> appearanceList = new ArrayList<GraphicAppearance>();
            Rectangle pageSize = SealXMLUtil.getPageSize(filesMap, i, baseDir);
            float pageWidth = pageSize.getWidth();
            float pageHeight = pageSize.getHeight();
            if (ifBeddingX) {
                float leftwardX = absoluteX;
                while (true) {
                    float f;
                    leftwardX = leftwardX - fitWidth - apartX;
                    if (!(f >= 0.0f)) break;
                    GraphicAppearance appearance2 = new GraphicAppearance(i, new Rectangle(leftwardX, absoluteY, fitWidth, fitHeight), alpha, rotationDegree);
                    appearanceList.add(appearance2);
                }
                float rightwardX = absoluteX;
                while (true) {
                    float f;
                    rightwardX = rightwardX + apartX + fitWidth;
                    if (!(f < pageWidth)) break;
                    appearance = new GraphicAppearance(i, new Rectangle(rightwardX, absoluteY, fitWidth, fitHeight), alpha, rotationDegree);
                    appearanceList.add(appearance);
                }
            }
            if (ifBeddingY) {
                downwardY = absoluteY;
                while (true) {
                    float f;
                    downwardY = downwardY - apartY - fitHeight;
                    if (!(f >= 0.0f)) break;
                    GraphicAppearance appearance3 = new GraphicAppearance(i, new Rectangle(absoluteX, downwardY, fitWidth, fitHeight), alpha, rotationDegree);
                    appearanceList.add(appearance3);
                }
                upwardY = absoluteY;
                while (true) {
                    float f;
                    upwardY = upwardY + apartY + fitHeight;
                    if (!(f < pageHeight)) break;
                    appearance = new GraphicAppearance(i, new Rectangle(absoluteX, upwardY, fitWidth, fitHeight), alpha, rotationDegree);
                    appearanceList.add(appearance);
                }
            }
            if (ifBeddingX && ifBeddingY) {
                downwardY = absoluteY;
                block10: while (true) {
                    float f;
                    downwardY = downwardY - apartY - fitHeight;
                    if (!(f >= 0.0f)) break;
                    float leftwardX = absoluteX;
                    while (true) {
                        float f2;
                        leftwardX = leftwardX - fitWidth - apartX;
                        if (!(f2 >= 0.0f)) break;
                        GraphicAppearance appearance4 = new GraphicAppearance(i, new Rectangle(leftwardX, downwardY, fitWidth, fitHeight), alpha, rotationDegree);
                        appearanceList.add(appearance4);
                    }
                    float rightwardX = absoluteX;
                    while (true) {
                        float f3;
                        rightwardX = rightwardX + apartX + fitWidth;
                        if (!(f3 < pageWidth)) continue block10;
                        GraphicAppearance appearance5 = new GraphicAppearance(i, new Rectangle(rightwardX, downwardY, fitWidth, fitHeight), alpha, rotationDegree);
                        appearanceList.add(appearance5);
                    }
                    break;
                }
                upwardY = absoluteY;
                block13: while (true) {
                    float f;
                    upwardY = upwardY + apartY + fitHeight;
                    if (!(f < pageHeight)) break;
                    float leftwardX = absoluteX;
                    while (true) {
                        float f4;
                        leftwardX = leftwardX - apartX - fitWidth;
                        if (!(f4 >= 0.0f)) break;
                        GraphicAppearance appearance6 = new GraphicAppearance(i, new Rectangle(leftwardX, upwardY, fitWidth, fitHeight), alpha, rotationDegree);
                        appearanceList.add(appearance6);
                    }
                    float rightwardX = absoluteX;
                    while (true) {
                        float f5;
                        rightwardX = rightwardX + apartX + fitWidth;
                        if (!(f5 < pageWidth)) continue block13;
                        GraphicAppearance appearance7 = new GraphicAppearance(i, new Rectangle(rightwardX, upwardY, fitWidth, fitHeight), alpha, rotationDegree);
                        appearanceList.add(appearance7);
                    }
                    break;
                }
            }
            GraphicAppearance appearance8 = new GraphicAppearance(i, new Rectangle(absoluteX, absoluteY, fitWidth, fitHeight), alpha, rotationDegree);
            appearanceList.add(appearance8);
            BigInteger tmplID = SealXMLUtil.getMaxDataId(root, baseDir).add(OFDConstants.wartermarkInterval);
            String baseLoc = null;
            String templatePath = TemplateXMLUtil.addTmpltoDoc(filesMap, baseDir, tmplID, baseLoc);
            BigInteger newMaxID = tmplID.add(OFDConstants.interval);
            TemplateXMLUtil.generateTemplate(filesMap, newMaxID, templatePath);
            for (int j = fromPage; j <= toPage; j += step) {
                TemplateXMLUtil.addTmpltoPage(filesMap, baseDir, tmplID, j);
            }
            byte[] result = ContentUtil.addImageToOFD(filesMap, imageData, appearanceList, templatePath);
            SealXMLUtil.updateMaxDataId(root, baseDir, newMaxID);
            IOUtils.writeChunked((byte[])result, (OutputStream)outputStream);
        }
        catch (SealException e) {
            businessLog.error("addImageWatermark failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("addImageWatermark failed", (Throwable)e);
            throw new SealException("addImageWatermark failed", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
            long end = System.currentTimeMillis();
            businessLog.info("addImageWatermark end...cost= " + (end - start) + " ms");
        }
    }

    public static void addTextWatermark(InputStream inputStream, OutputStream outputStream, PageRangeOption pageRangeOption, WatermarkOption waterMarkOption) throws SealException {
        long start = System.currentTimeMillis();
        businessLog.info("addTextWatermark start...");
        if (null == inputStream) {
            throw new IllegalArgumentException("inputStream is null!");
        }
        try {
            float upwardY;
            float downwardY;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)output);
            byte[] ofdDatas = output.toByteArray();
            Map<String, byte[]> filesMap = ZipUtil.uncompress(new ByteArrayInputStream(ofdDatas));
            int pages = SealXMLUtil.getTotalPages(filesMap);
            float absoluteX = waterMarkOption.getAbsoluteX();
            float absoluteY = waterMarkOption.getAbsoluteY();
            float fitWidth = waterMarkOption.getFitWidth();
            float fitHeight = waterMarkOption.getFitHeight();
            double rotationDegree = waterMarkOption.getRotationDegree();
            int alpha = waterMarkOption.getAlpha();
            float apartX = waterMarkOption.getApartX();
            float apartY = waterMarkOption.getApartY();
            String text = waterMarkOption.getText();
            Color fontColor = waterMarkOption.getFontColor();
            String fontName = waterMarkOption.getFontName();
            float fontSize = waterMarkOption.getFontSize();
            boolean ifBeddingX = false;
            boolean ifBeddingY = false;
            if ((double)Math.abs(1.0f + apartX) > 1.0E-4) {
                ifBeddingX = true;
            }
            if ((double)Math.abs(1.0f + apartY) > 1.0E-4) {
                ifBeddingY = true;
            }
            int fromPage = pageRangeOption.getFromPage();
            int toPage = pageRangeOption.getToPage();
            if (pages < toPage || toPage < 0) {
                toPage = pages;
            }
            if (fromPage < 1) {
                fromPage = 1;
            }
            int step = 1;
            String baseDir = SealXMLUtil.getBaseDir(filesMap);
            Element root = SealXMLUtil.getDocument(filesMap, baseDir);
            ArrayList<TextAppearance> appearanceList = new ArrayList<TextAppearance>();
            TextAppearance appearance = new TextAppearance(0, new Rectangle(0.0f, absoluteY, fitWidth, fitHeight), alpha, rotationDegree);
            appearance.setContent(text);
            appearance.setFontName(fontName);
            appearance.setFontSize(fontSize);
            appearance.setFontColor(fontColor);
            appearance.setAlpha(alpha);
            Rectangle pageSize = SealXMLUtil.getPageSize(filesMap, fromPage, baseDir);
            float pageWidth = pageSize.getWidth();
            float pageHeight = pageSize.getHeight();
            appearance.setPageNum(fromPage);
            if (ifBeddingX) {
                float leftwardX = absoluteX;
                while (true) {
                    float f;
                    leftwardX = leftwardX - fitWidth - apartX;
                    if (!(f >= 0.0f)) break;
                    appearance.setBoundary(new Rectangle(leftwardX, absoluteY, fitWidth, fitHeight));
                    appearanceList.add((TextAppearance)appearance.clone());
                }
                float rightwardX = absoluteX;
                while (true) {
                    float f;
                    rightwardX = rightwardX + apartX + fitWidth;
                    if (!(f < pageWidth)) break;
                    appearance.setBoundary(new Rectangle(rightwardX, absoluteY, fitWidth, fitHeight));
                    appearanceList.add((TextAppearance)appearance.clone());
                }
            }
            if (ifBeddingY) {
                downwardY = absoluteY;
                while (true) {
                    float f;
                    downwardY = downwardY - apartY - fitHeight;
                    if (!(f >= 0.0f)) break;
                    appearance.setBoundary(new Rectangle(absoluteX, downwardY, fitWidth, fitHeight));
                    appearanceList.add((TextAppearance)appearance.clone());
                }
                upwardY = absoluteY;
                while (true) {
                    float f;
                    upwardY = upwardY + apartY + fitHeight;
                    if (!(f < pageHeight)) break;
                    appearance.setBoundary(new Rectangle(absoluteX, upwardY, fitWidth, fitHeight));
                    appearanceList.add((TextAppearance)appearance.clone());
                }
            }
            if (ifBeddingX && ifBeddingY) {
                downwardY = absoluteY;
                block10: while (true) {
                    float f;
                    downwardY = downwardY - apartY - fitHeight;
                    if (!(f >= 0.0f)) break;
                    float leftwardX = absoluteX;
                    while (true) {
                        float f2;
                        leftwardX = leftwardX - fitWidth - apartX;
                        if (!(f2 >= 0.0f)) break;
                        appearance.setBoundary(new Rectangle(leftwardX, downwardY, fitWidth, fitHeight));
                        appearanceList.add((TextAppearance)appearance.clone());
                    }
                    float rightwardX = absoluteX;
                    while (true) {
                        float f3;
                        rightwardX = rightwardX + apartX + fitWidth;
                        if (!(f3 < pageWidth)) continue block10;
                        appearance.setBoundary(new Rectangle(rightwardX, downwardY, fitWidth, fitHeight));
                        appearanceList.add((TextAppearance)appearance.clone());
                    }
                    break;
                }
                upwardY = absoluteY;
                block13: while (true) {
                    float f;
                    upwardY = upwardY + apartY + fitHeight;
                    if (!(f < pageHeight)) break;
                    float leftwardX = absoluteX;
                    while (true) {
                        float f4;
                        leftwardX = leftwardX - apartX - fitWidth;
                        if (!(f4 >= 0.0f)) break;
                        appearance.setBoundary(new Rectangle(leftwardX, upwardY, fitWidth, fitHeight));
                        appearanceList.add((TextAppearance)appearance.clone());
                    }
                    float rightwardX = absoluteX;
                    while (true) {
                        float f5;
                        rightwardX = rightwardX + apartX + fitWidth;
                        if (!(f5 < pageWidth)) continue block13;
                        appearance.setBoundary(new Rectangle(rightwardX, upwardY, fitWidth, fitHeight));
                        appearanceList.add((TextAppearance)appearance.clone());
                    }
                    break;
                }
            }
            appearance.setBoundary(new Rectangle(absoluteX, absoluteY, fitWidth, fitHeight));
            appearanceList.add((TextAppearance)appearance.clone());
            BigInteger tmplID = SealXMLUtil.getMaxDataId(root, baseDir).add(OFDConstants.wartermarkInterval);
            String baseLoc = null;
            String templatePath = TemplateXMLUtil.addTmpltoDoc(filesMap, baseDir, tmplID, baseLoc);
            BigInteger newMaxID = tmplID.add(OFDConstants.interval);
            TemplateXMLUtil.generateTemplate(filesMap, newMaxID, templatePath);
            for (int i = fromPage; i <= toPage; i += step) {
                TemplateXMLUtil.addTmpltoPage(filesMap, baseDir, tmplID, i);
            }
            byte[] result = ContentUtil.addTextToOFD(filesMap, appearanceList, true, templatePath);
            SealXMLUtil.updateMaxDataId(root, baseDir, newMaxID);
            IOUtils.writeChunked((byte[])result, (OutputStream)outputStream);
        }
        catch (SealException e) {
            businessLog.error("addTextWatermark failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("addTextWatermark failed", (Throwable)e);
            throw new SealException("addTextWatermark failed", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
            long end = System.currentTimeMillis();
            businessLog.info("addTextWatermark end...cost= " + (end - start) + " ms");
        }
    }

    static {
        VersionInfo.environments();
    }

    public static class RotationOption {
        public static final double DEGREES_0 = 0.0;
        public static final double DEGREES_30 = 0.5235987755982988;
        public static final double DEGREES_45 = 0.7853981633974483;
        public static final double DEGREES_60 = 1.0471975511965976;
    }

    public static class PageRangeOption {
        private int fromPage;
        private int toPage;
        private int subPageRangeOption;

        private PageRangeOption(int fromPage, int toPage, int subPageRangeOption) {
            this.fromPage = fromPage;
            this.toPage = toPage;
            if (this.fromPage > this.toPage && this.toPage != -1) {
                throw new IllegalArgumentException("fromPage = " + fromPage + " larger than toPage: " + toPage);
            }
            this.subPageRangeOption = subPageRangeOption;
        }

        public static PageRangeOption build(int fromPage, int toPage, int subPageRangeOption) {
            return new PageRangeOption(fromPage, toPage, subPageRangeOption);
        }

        public int getFromPage() {
            return this.fromPage;
        }

        public int getToPage() {
            return this.toPage;
        }

        public int getSubPageRangeOption() {
            return this.subPageRangeOption;
        }

        public static interface SubPageRangeOption {
            public static final int ALL = 0;
            public static final int ODD = 1;
            public static final int EVEN = 2;
        }
    }

    public static class WatermarkOption {
        private boolean ifUnderContent;
        private double rotationDegree;
        private int alpha;
        private float absoluteX;
        private float absoluteY;
        private float fitWidth;
        private float fitHeight;
        private Color fontColor;
        private String fontName;
        private float fontSize;
        private String text;
        private float apartX;
        private float apartY;
        private float offsetX;
        private float ofsetY;
        private boolean isUpperLeftCoordinate = false;

        public WatermarkOption(float absoluteX, float absoluteY, float apartX, float apartY, double rotationDegree, int alpha, float fitWidth, float fitHeight) {
            this.absoluteX = absoluteX;
            this.absoluteY = absoluteY;
            this.apartX = apartX;
            this.apartY = apartY;
            this.rotationDegree = rotationDegree;
            this.alpha = alpha;
            this.fitWidth = fitWidth;
            this.fitHeight = fitHeight;
            this.checkApartParams();
            this.checkParams();
            this.checkRotationOption(this.rotationDegree);
        }

        public WatermarkOption(float absoluteX, float absoluteY, float apartX, float apartY, double rotationDegree, int alpha, String fontName, String text, float fontSize, Color fontColor) {
            this.absoluteX = absoluteX;
            this.absoluteY = absoluteY;
            this.apartX = apartX;
            this.apartY = apartY;
            this.checkApartParams();
            this.rotationDegree = rotationDegree;
            this.checkRotationOption(this.rotationDegree);
            this.alpha = alpha;
            this.fontName = fontName;
            this.fontSize = fontSize;
            this.fontColor = fontColor;
            this.text = text;
        }

        public void checkParams() {
            if (this.fitWidth <= 0.0f) {
                throw new IllegalArgumentException("fitWidth must larger than zero.");
            }
            if (this.fitHeight <= 0.0f) {
                throw new IllegalArgumentException("fitHeight must larger than zero.");
            }
        }

        public void checkApartParams() {
            if (this.apartX <= 0.0f) {
                throw new IllegalArgumentException("apartX must larger than zero.");
            }
            if (this.apartY <= 0.0f) {
                throw new IllegalArgumentException("apartY must larger than zero.");
            }
        }

        public void checkRotationOption(double rotation) {
            double absRotation = Math.abs(rotation);
            if (0.0 != absRotation && 0.5235987755982988 != absRotation && 0.7853981633974483 != absRotation && 1.0471975511965976 != absRotation) {
                throw new IllegalArgumentException("rotation must use option of RotationOption's definition,negative is allowed.");
            }
        }

        public static WatermarkOption buildImageOption(float absoluteX, float absoluteY, float rotationDegree, int alpha, float fitWidth, float fitHeight) {
            return new WatermarkOption(absoluteX, absoluteY, -1.0f, -1.0f, rotationDegree, alpha, fitWidth, fitHeight);
        }

        public boolean ifUnderContent() {
            return this.ifUnderContent;
        }

        public double getRotationDegree() {
            return this.rotationDegree;
        }

        public int getAlpha() {
            return this.alpha;
        }

        public float getAbsoluteX() {
            return this.absoluteX;
        }

        public float getAbsoluteY() {
            return this.absoluteY;
        }

        public float getFitWidth() {
            return this.fitWidth;
        }

        public float getFitHeight() {
            return this.fitHeight;
        }

        public float getApartX() {
            return this.apartX;
        }

        public float getApartY() {
            return this.apartY;
        }

        public float getOffsetX() {
            return this.offsetX;
        }

        public void setOffsetX(float offsetX) {
            this.offsetX = offsetX;
        }

        public float getOfsetY() {
            return this.ofsetY;
        }

        public void setOfsetY(float ofsetY) {
            this.ofsetY = ofsetY;
        }

        public boolean isUpperLeftCoordinate() {
            return this.isUpperLeftCoordinate;
        }

        public void setUpperLeftCoordinate(boolean isUpperLeftCoordinate) {
            this.isUpperLeftCoordinate = isUpperLeftCoordinate;
        }

        public Color getFontColor() {
            return this.fontColor;
        }

        public void setFontColor(Color fontColor) {
            this.fontColor = fontColor;
        }

        public String getFontName() {
            return this.fontName;
        }

        public void setFontName(String fontName) {
            this.fontName = fontName;
        }

        public float getFontSize() {
            return this.fontSize;
        }

        public void setFontSize(float fontSize) {
            this.fontSize = fontSize;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }
}

