/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.hard.generator;

import cfca.sadk.algorithm.common.GenKeyAttribute;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.extend.session.ECCCurveId;
import cfca.sadk.lib.crypto.hard.generator.ECCGenerator;
import cfca.sadk.lib.crypto.hard.generator.RSAGenerator;
import cfca.sadk.lib.crypto.hard.generator.SM2Generator;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;

public abstract class AbsGenerator {
    final Provider provider;
    final String mType;
    final ECCCurveId curveId;

    protected AbsGenerator(Provider provider, String mType, ECCCurveId curveId) throws Exception {
        this.provider = provider;
        this.mType = mType;
        this.curveId = curveId;
    }

    public final KeyPair generateKeyPair(Mechanism mechanism, int keyLength) throws Exception {
        boolean isExportable = this.isExportable(mechanism);
        return isExportable ? this.generateKeyPairExternal(mechanism, keyLength) : this.generateKeyPairInternal(mechanism, keyLength);
    }

    private final KeyPair generateKeyPairInternal(Mechanism mechanism, int keyLength) throws Exception {
        if (mechanism == null) {
            throw new IllegalArgumentException("mechanism==null");
        }
        Object param = mechanism.getParam();
        if (param == null) {
            throw new IllegalArgumentException("mechanism#param==null");
        }
        if (param instanceof GenKeyAttribute) {
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("GenerateKeyPair ::::::" + mechanism);
            }
            GenKeyAttribute attr = (GenKeyAttribute)param;
            int bitLength = this.bitLength(attr.keyNum, attr.keyUsage);
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(this.mType, this.provider);
            keyPairGen.initialize(bitLength);
            KeyPair keypair = this.checkKeyPairInternal(keyPairGen.generateKeyPair(), attr.keyNum);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("GenerateKeyPair <<<<<<Finished: decryptData=" + SADKDebugger.dump(keypair));
            }
            return keypair;
        }
        throw new IllegalArgumentException("mechanism#param not GenKeyAttribute");
    }

    public KeyPair generateKeyPairExternal(Mechanism mechanism, int keyLength) throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(this.mType, this.provider);
        keyPairGen.initialize(keyLength);
        KeyPair keypair = this.formatKeyPairExternal(keyPairGen.generateKeyPair());
        return keypair;
    }

    private int bitLength(int keyNum, int keyUsage) {
        int kLength = keyNum << 16;
        if (1 == keyUsage) {
            kLength |= Integer.MIN_VALUE;
        }
        int bitLength = kLength;
        return bitLength;
    }

    private boolean isExportable(Mechanism mechanism) throws Exception {
        if (mechanism == null) {
            throw new IllegalArgumentException("mechanism==null");
        }
        boolean isExport = true;
        Object object = mechanism.getParam();
        if (object != null) {
            GenKeyAttribute attr = (GenKeyAttribute)object;
            isExport = attr.isExport;
        }
        return isExport;
    }

    abstract KeyPair checkKeyPairInternal(KeyPair var1, int var2) throws Exception;

    abstract KeyPair formatKeyPairExternal(KeyPair var1) throws Exception;

    public static AbsGenerator createGenerator(Provider provider, Mechanism mechanism) throws Exception {
        if (mechanism == null) {
            throw new IllegalArgumentException("mechanism==null");
        }
        String mType = mechanism.getMechanismType();
        if (mType == null) {
            throw new IllegalArgumentException("mType==null");
        }
        mType = mType.toUpperCase();
        AbsGenerator generator = null;
        if (mType.contains("SM2")) {
            generator = new SM2Generator(provider, mType, null);
        } else if (mType.contains("RSA")) {
            generator = new RSAGenerator(provider, mType, null);
        } else if (mType.contains("EC")) {
            String curveName = mechanism.getCurveName();
            ECCCurveId curveId = curveName == null ? ECCCurveId.NIST_P256 : ECCCurveId.findECCCurveId(curveName);
            generator = new ECCGenerator(provider, mType, curveId);
        } else {
            throw new IllegalArgumentException("do not support mType==" + mType);
        }
        return generator;
    }
}

