/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.paperless.base.exception.CodeException;
import cfca.paperless.base.util.StringUtil;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import java.security.PrivateKey;

public class SignatureUtil {
    private static String deviceId;

    public static void initCryptoEnv(String deviceId, String hardJCEName) throws CodeException {
        SignatureUtil.deviceId = deviceId;
        try {
            JCrypto.getInstance().initialize("JSOFT_LIB", null);
            if (StringUtil.isNotEmpty(deviceId) && !"JSOFT_LIB".equals(deviceId)) {
                JCrypto.getInstance().initialize(deviceId, (Object)hardJCEName);
            }
        }
        catch (Exception e) {
            throw new CodeException("600628", "\u7b7e\u540d\u4fe1\u606f\u5f02\u5e38\uff0c" + e.getMessage(), (Throwable)e);
        }
    }

    public static String makeP7DetachSignature(byte[] hashData, PrivateKey privateKey, X509Cert x509Cert, String singAlg, String deviceId) throws CodeException {
        try {
            Session session = JCrypto.getInstance().openSession(deviceId);
            Signature signature = new Signature();
            byte[] p7DetachBase64 = signature.p7SignByHash(singAlg, hashData, privateKey, x509Cert, session);
            return new String(p7DetachBase64, "UTF-8");
        }
        catch (Exception e) {
            throw new CodeException("600628", "\u7b7e\u540d\u4fe1\u606f\u5f02\u5e38\uff0c" + e.getMessage(), (Throwable)e);
        }
    }

    public static void verifyP7DetachSignature(byte[] sourceData, byte[] signData, String deviceId) throws CodeException {
        boolean result = false;
        try {
            Signature signature = new Signature();
            Session session = JCrypto.getInstance().openSession(deviceId);
            result = signature.p7VerifyMessageDetach(sourceData, signData, session);
        }
        catch (PKIException e) {
            throw new CodeException("600628", "\u7b7e\u540d\u4fe1\u606f\u5f02\u5e38\uff0c" + e.getMessage(), (Throwable)e);
        }
        if (!result) {
            throw new CodeException("600628", "\u7b7e\u540d\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public static void checkCertMatchKey(PrivateKey privateKey, X509Cert x509Cert, String device, String signAlg) throws CodeException {
        boolean verifySign = false;
        Signature signature = new Signature();
        try {
            byte[] testData = "CFCA".getBytes("UTF-8");
            Session session = JCrypto.getInstance().openSession(device);
            byte[] sign = signature.p1SignMessage(signAlg, testData, privateKey, session);
            verifySign = signature.p1VerifyMessage(signAlg, testData, sign, x509Cert.getPublicKey(), session);
        }
        catch (Exception e) {
            throw new CodeException("600628", "\u8bc1\u4e66\u4fe1\u606f\u5f02\u5e38\uff0c" + e.getMessage());
        }
        if (!verifySign) {
            throw new CodeException("600628", "\u8bc1\u4e66\u6821\u9a8c\u5f02\u5e38");
        }
    }
}

