/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.RandomCookie;
import cfca.sadk.tls.util.Hexifys;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;

public final class SessionId {
    private final byte[] sessionId;

    SessionId(boolean isRejoinable, SecureRandom generator) {
        this.sessionId = isRejoinable ? new RandomCookie((Random)generator).random : new byte[0];
    }

    public SessionId(byte[] sessionId) {
        this.sessionId = sessionId;
    }

    public SessionId(HandshakeInStream in) throws IOException {
        this.sessionId = in.getBytes8();
    }

    public int length() {
        return this.sessionId.length;
    }

    public byte[] getId() {
        return (byte[])this.sessionId.clone();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("0x");
        builder.append(Hexifys.hexify(this.sessionId));
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.sessionId);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionId other = (SessionId)obj;
        return Arrays.equals(this.sessionId, other.sessionId);
    }
}

