/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.paperless.base.util.ByteConvertUtil;
import cfca.paperless.base.util.FastBase64;
import cfca.paperless.base.util.HttpClientUtil;
import cfca.paperless.base.util.PaperlessHttpClientConnectionOperator;
import cfca.paperless.base.util.SSLContextUtil;
import cfca.paperless.base.util.SignatureUtil;
import cfca.paperless.base.util.StringUtil;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.HashUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpClientConnectionOperator;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpsClientUtil {
    private String keystorePath;
    private String keystorePassword;
    private int connectTimeout = 30000;
    private int readTimeout = 30000;
    private PrivateKey privateKey;
    private X509Cert x509Cert;
    private CloseableHttpClient closeableHttpClient;

    public void initSSLContext(String keystorePath, String keystorePassword, String truststorePath, String truststorePassword, int connectTimeout, int readTimeout) throws Exception {
        this.keystorePath = keystorePath;
        this.keystorePassword = keystorePassword;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.initHttpSSLContext(keystorePath, keystorePassword, truststorePath, truststorePassword);
        this.initPrivateKeyAndCert(keystorePath, keystorePassword);
    }

    private void initHttpSSLContext(String keystorePath, String keystorePassword, String truststorePath, String truststorePassword) throws Exception {
        String keyStoreType = keystorePath.toLowerCase().endsWith(".jks") ? "JKS" : "PKCS12";
        String trustKeyStoreType = "JKS";
        SSLContext sslContext = SSLContextUtil.createSSLContext("SSL", keystorePath, keystorePassword, keyStoreType, truststorePath, truststorePassword, trustKeyStoreType);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext)).build();
        this.closeableHttpClient = HttpClients.custom().setConnectionManager(HttpsClientUtil.createHttpClientConnectionManager((Registry<ConnectionSocketFactory>)socketFactoryRegistry)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPrivateKeyAndCert(String keystorePath, String keystorePassword) throws Exception {
        InputStream keyStoreInputStream = null;
        try {
            String ksTypeName = this.keystorePath.toLowerCase().endsWith(".jks") ? "JKS" : "PKCS12";
            KeyStore keyStore = KeyStore.getInstance(ksTypeName);
            keyStoreInputStream = new FileInputStream(keystorePath);
            keyStore.load(keyStoreInputStream, keystorePassword.toCharArray());
            String aliase = "";
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements() && !keyStore.isKeyEntry(aliase = aliases.nextElement())) {
            }
            this.privateKey = KeyUtil.getPrivateKeyFromJKS((String)this.keystorePath, (String)this.keystorePassword, (String)aliase);
            this.x509Cert = CertUtil.getCertFromJKS((String)this.keystorePath, (String)this.keystorePassword, (String)aliase);
        }
        finally {
            if (keyStoreInputStream != null) {
                try {
                    keyStoreInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String doPost(String url, String parameterStr) throws Exception {
        return this.doPost(url, parameterStr, this.connectTimeout, this.readTimeout);
    }

    public String doPost(String url, String parameterStr, int connectTimeout, int readTimeout) throws Exception {
        String signData = this.createSignString(parameterStr);
        parameterStr = parameterStr + signData;
        String contentLength = String.valueOf(parameterStr.getBytes("UTF-8").length);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Length", contentLength);
        headers.put("Accept", "text/xml,text/javascript,text/html");
        headers.put("User-Agent", "stargate");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("Connection", "Close");
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new StringEntity(parameterStr));
        byte[] result = HttpClientUtil.sendAndGetResponse(this.closeableHttpClient, (HttpRequestBase)httpPost, headers, null, connectTimeout, readTimeout);
        this.verifySignResult(result);
        return new String(result, "UTF-8");
    }

    public String createSignString(String parameterData) throws Exception {
        if (this.privateKey == null || parameterData == null) {
            return "";
        }
        byte[] sourceData = parameterData.getBytes("UTF-8");
        if (StringUtil.isEmpty(parameterData)) {
            sourceData = ("t=" + System.currentTimeMillis()).getBytes("UTF-8");
        }
        byte[] hash = HashUtil.RSAHashMessageByBC((byte[])sourceData, (Mechanism)new Mechanism("SHA-256"), (boolean)false);
        String hashStr = new String(Hex.encode((byte[])hash), "UTF-8");
        String result = "&hash=" + hashStr;
        String clientSignData = SignatureUtil.makeP7DetachSignature(hash, this.privateKey, this.x509Cert, "sha256WithRSAEncryption", "JSOFT_LIB");
        result = result + "&clientSignData=" + clientSignData;
        return result;
    }

    public byte[] verifySignResult(byte[] result) throws Exception {
        byte[] signDataLenData = new byte[4];
        System.arraycopy(result, 0, signDataLenData, 0, 4);
        int signDataLen = ByteConvertUtil.byteArray2int(signDataLenData);
        if (signDataLen <= 0 || signDataLen > result.length - 4) {
            throw new Exception("\u7b7e\u540d\u503c\u957f\u5ea6\u4e0d\u5bf9");
        }
        byte[] signData = new byte[signDataLen];
        System.arraycopy(result, 4, signData, 0, signDataLen);
        try {
            FastBase64.decode(signData);
        }
        catch (Exception e) {
            throw new Exception("\u7b7e\u540d\u7f16\u7801\u9519\u8bef");
        }
        int sourceDataLen = result.length - 4 - signDataLen;
        byte[] sourceData = new byte[sourceDataLen];
        System.arraycopy(result, 4 + signDataLen, sourceData, 0, sourceDataLen);
        SignatureUtil.verifyP7DetachSignature(sourceData, signData, "JSOFT_LIB");
        return sourceData;
    }

    private static HttpClientConnectionManager createHttpClientConnectionManager(Registry<ConnectionSocketFactory> socketFactoryRegistry) {
        PaperlessHttpClientConnectionOperator connectionOperator = new PaperlessHttpClientConnectionOperator((Lookup<ConnectionSocketFactory>)socketFactoryRegistry, null, null);
        return new PoolingHttpClientConnectionManager((HttpClientConnectionOperator)connectionOperator, null, -1L, TimeUnit.MILLISECONDS);
    }
}

