/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.message;

import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.HandshakeOutStream;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.message.HandshakeMessage;
import cfca.sadk.tls.sun.security.ssl.sec.HandshakeHash;
import cfca.sadk.tls.sun.security.ssl.sec.JSSEJCE;
import cfca.sadk.tls.sun.security.ssl.sec.SM2Signature;
import cfca.sadk.tls.sun.security.ssl.sec.SignatureAndHashAlgorithm;
import cfca.sadk.tls.util.Hexifys;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.util.List;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;

public final class CertificateVerify
extends HandshakeMessage {
    private byte[] signatureBytes;
    private ProtocolVersion protocolVersion;
    private SignatureAndHashAlgorithm signatureAlgorithm;
    private HandshakeHash handshakeHash;
    private Signature signature = null;

    public CertificateVerify(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, PrivateKey signingKey, SecretKey masterKey, SignatureAndHashAlgorithm signatureAlgorithm, SecureRandom random) throws GeneralSecurityException {
        this.protocolVersion = protocolVersion;
        this.signatureAlgorithm = signatureAlgorithm;
        this.handshakeHash = handshakeHash;
        this.signature = this.signatureFrom(protocolVersion, handshakeHash, signingKey);
        this.signature.initSign(signingKey, random);
        this.signatureUpdate(protocolVersion, handshakeHash, masterKey);
        this.signatureBytes = this.signature.sign();
    }

    public CertificateVerify(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, HandshakeInStream in, List<SignatureAndHashAlgorithm> signatureAlgorithmItems) throws IOException {
        this.protocolVersion = protocolVersion;
        this.handshakeHash = handshakeHash;
        if (this.protocolVersion.isStandardTLS12()) {
            int hashAlg = in.getInt8();
            int signAlg = in.getInt8();
            this.signatureAlgorithm = SignatureAndHashAlgorithm.valueOf(hashAlg, signAlg, 0);
            if (this.signatureAlgorithm == null) {
                throw new SSLHandshakeException("Illegal CertificateVerify message");
            }
            String hashAlgName = SignatureAndHashAlgorithm.getHashAlgorithmName(this.signatureAlgorithm);
            if (hashAlgName == null || hashAlgName.length() == 0) {
                throw new SSLHandshakeException("No supported hash algorithm");
            }
            if (!signatureAlgorithmItems.contains(this.signatureAlgorithm)) {
                throw new SSLHandshakeException("Unsupported SignatureAndHashAlgorithm in ServerKeyExchange message");
            }
        }
        this.signatureBytes = in.getBytes16();
    }

    public boolean verify(PublicKey publicKey, SecretKey masterKey) throws GeneralSecurityException {
        this.signature = this.signatureFrom(this.protocolVersion, this.handshakeHash, publicKey);
        this.signature.initVerify(publicKey);
        this.signatureUpdate(this.protocolVersion, this.handshakeHash, masterKey);
        return this.signature.verify(this.signatureBytes);
    }

    private final Signature signatureFrom(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, Key key) throws GeneralSecurityException {
        String algorithm = key.getAlgorithm().toUpperCase();
        Signature signature = null;
        if (protocolVersion.isStandardTLS12()) {
            signature = JSSEJCE.getSignature(this.signatureAlgorithm.getAlgorithmName());
        } else if ("SM2".equals(algorithm)) {
            signature = SM2Signature.newSignature();
        } else if ("RSA".equals(algorithm)) {
            signature = JSSEJCE.getSignature("NONEwithRSA");
        } else if ("EC".equals(algorithm)) {
            signature = JSSEJCE.getSignature("NONEwithECDSA");
        } else {
            throw new SignatureException("Unrecognized algorithm: " + algorithm);
        }
        return signature;
    }

    final void signatureUpdate(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, SecretKey masterKey) throws GeneralSecurityException {
        if (protocolVersion.isChinaTLS11()) {
            byte[] hash = handshakeHash.getFinishedHash();
            if (Debugger.handshaker.isDebugEnabled()) {
                Debugger.handshaker.debug("handshakeHash: 0x{}", (Object)Hexifys.hexify(hash));
            }
            this.signature.update(hash);
            return;
        }
        throw new GeneralSecurityException("Only SMTLS 1.1 supported");
    }

    @Override
    public final int messageType() {
        return 15;
    }

    @Override
    final int messageLength() {
        int length = 2;
        if (this.protocolVersion.isStandardTLS12()) {
            length += SignatureAndHashAlgorithm.sizeInRecord();
        }
        return length + this.signatureBytes.length;
    }

    @Override
    final void send(HandshakeOutStream out) throws IOException {
        if (this.protocolVersion.isStandardTLS12()) {
            out.putInt8(this.signatureAlgorithm.getHashValue());
            out.putInt8(this.signatureAlgorithm.getSignatureValue());
        }
        out.putBytes16(this.signatureBytes);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('\n');
        builder.append("*** CertificateVerify");
        if (this.protocolVersion.isStandardTLS12()) {
            builder.append("Signature Algorithm ");
            if (this.signatureAlgorithm != null) {
                builder.append(this.signatureAlgorithm.getAlgorithmName());
            }
        }
        builder.append("\n***");
        return builder.toString();
    }
}

