/*
 * Decompiled with CFR 0.152.
 */
package cfca.integration.uarc.graphics;

import cfca.integration.uarc.fn.CoordTransformer;
import cfca.integration.uarc.fn.EllipseFunction;
import cfca.integration.uarc.graphics.UArcEllipse;
import cfca.integration.uarc.graphics.UArcRectangle;
import cfca.integration.uarc.graphics.UArcShape;
import cfca.integration.uarc.graphics.UArcTriangle;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import sun.font.FontDesignMetrics;

public class UArcText
extends UArcShape {
    private Logger logger = LoggerFactory.getLogger(UArcText.class);
    private UArcEllipse uae;
    private String[] textArray;
    private boolean rounding;
    private double slide;
    private double startAngle;
    private double arcAngle;
    private int n;
    private boolean horizontal;
    private double theta;
    private float alpha;
    private Color color;
    private Font font;
    private int gap;
    private int tray;
    private UArcTriangle uat;
    private boolean center;
    private int leftgap;
    private UArcRectangle uar;
    private FontDesignMetrics fm;

    public UArcText(UArcEllipse uae, String[] textArray, boolean rounding, double slide, double startAngle, double arcAngle, boolean horizontal, double theta, float alpha, Color color, Font font, int gap) {
        this.tray = 2;
        this.uae = uae;
        this.textArray = textArray;
        this.rounding = rounding;
        this.slide = slide;
        this.startAngle = startAngle;
        this.arcAngle = arcAngle;
        this.n = textArray.length;
        this.horizontal = horizontal;
        this.theta = theta;
        this.alpha = alpha;
        this.color = color;
        this.font = font;
        this.gap = gap;
        this.fm = FontDesignMetrics.getMetrics(font);
    }

    public UArcText(UArcTriangle uat, String[] textArray, boolean center, double slide, double theta, float alpha, Color color, Font font, int gap, int leftgap) {
        this.tray = 0;
        this.uat = uat;
        this.textArray = textArray;
        this.center = center;
        this.slide = slide;
        this.theta = theta;
        this.alpha = alpha;
        this.color = color;
        this.font = font;
        this.gap = gap;
        this.leftgap = leftgap;
        this.fm = FontDesignMetrics.getMetrics(font);
    }

    public UArcText(UArcRectangle uar, String[] textArray, boolean center, double slide, double theta, float alpha, Color color, Font font, int gap, int leftgap) {
        this.tray = 1;
        this.uar = uar;
        this.textArray = textArray;
        this.center = center;
        this.slide = slide;
        this.theta = theta;
        this.alpha = alpha;
        this.color = color;
        this.font = font;
        this.gap = gap;
        this.leftgap = leftgap;
        this.fm = FontDesignMetrics.getMetrics(font);
    }

    public void draw() {
        boolean charWidth = false;
        boolean totalCharWidth = false;
        if (2 == this.tray) {
            EllipseFunction.UArcPoints uaps;
            int x = this.uae.getX();
            int y = this.uae.getY();
            int a = this.uae.getWidth() / 2;
            int b = this.uae.getHeight() / 2;
            if (Double.isNaN(this.slide)) {
                int nhalf;
                int fontSize = this.font.getSize();
                uaps = new EllipseFunction.UArcPoints(this.n);
                if (this.n % 2 == 0) {
                    nhalf = this.n / 2;
                    int leftpx = -(this.gap + fontSize) / 2 - (nhalf - 1) * (this.gap + fontSize);
                    for (int i = 0; i < nhalf; ++i) {
                        EllipseFunction.UArcPoint arcPoint = new EllipseFunction.UArcPoint();
                        arcPoint.x0 = leftpx;
                        arcPoint.y0 = 0.0;
                        arcPoint.normal0 = 1.5707963267948966;
                        uaps.add(arcPoint);
                        leftpx += this.gap + fontSize;
                    }
                    int rightpx = (this.gap + fontSize) / 2;
                    for (int i = 0; i < nhalf; ++i) {
                        EllipseFunction.UArcPoint arcPoint = new EllipseFunction.UArcPoint();
                        arcPoint.x0 = rightpx;
                        arcPoint.y0 = 0.0;
                        arcPoint.normal0 = 1.5707963267948966;
                        uaps.add(arcPoint);
                        rightpx += this.gap + fontSize;
                    }
                } else {
                    EllipseFunction.UArcPoint arcPoint;
                    nhalf = this.n / 2;
                    int leftpx = -(this.gap + fontSize) - (nhalf - 1) * (this.gap + fontSize);
                    for (int i = 0; i < nhalf; ++i) {
                        arcPoint = new EllipseFunction.UArcPoint();
                        arcPoint.x0 = leftpx;
                        arcPoint.y0 = 0.0;
                        arcPoint.normal0 = 1.5707963267948966;
                        uaps.add(arcPoint);
                        leftpx += this.gap + fontSize;
                    }
                    arcPoint = new EllipseFunction.UArcPoint();
                    arcPoint.x0 = 0.0;
                    arcPoint.y0 = 0.0;
                    arcPoint.normal0 = 1.5707963267948966;
                    uaps.add(arcPoint);
                    int rightpx = this.gap + fontSize;
                    for (int i = 0; i < nhalf; ++i) {
                        arcPoint = new EllipseFunction.UArcPoint();
                        arcPoint.x0 = rightpx;
                        arcPoint.y0 = 0.0;
                        arcPoint.normal0 = 1.5707963267948966;
                        uaps.add(arcPoint);
                        rightpx += this.gap + fontSize;
                    }
                }
            } else {
                EllipseFunction ellipseFn = new EllipseFunction(a, b);
                double arcLength = ellipseFn.getArcLength(this.startAngle, this.arcAngle);
                double[] angles = ellipseFn.getAngles(arcLength, this.startAngle, this.arcAngle, this.n);
                uaps = ellipseFn.getCenterPoints(angles, this.slide, this.rounding);
            }
            int[][] arrPts = uaps.toArrayXY();
            double[] arrNorm = uaps.toArrayNormal();
            this.drawOnEllipse(arrPts, arrNorm, this.horizontal, this.theta, x, y, a, b, this.alpha);
        } else if (0 == this.tray) {
            EllipseFunction.UArcPoint p0 = this.uat.getP0();
            EllipseFunction.UArcPoint p1 = this.uat.getP1();
            EllipseFunction.UArcPoint p2 = this.uat.getP2();
            int fontsize = this.font.getSize();
            int len = this.textArray.length;
            EllipseFunction.UArcPoints uaps = new EllipseFunction.UArcPoints(len);
            if (Math.abs(p0.y0 - p1.y0) >= 1.0E-6) {
                throw new RuntimeException("p0.y0 must be equal to p1.y0!");
            }
            double tmpslide = -this.slide;
            if (this.center) {
                int p5x = (int)((p0.x0 + p1.x0) / 2.0);
                int p5y = (int)((p0.y0 + p1.y0) / 2.0);
                double dp2p5 = Math.sqrt(Math.pow(p2.x0 - (double)p5x, 2.0) + Math.pow(p2.y0 - (double)p5y, 2.0));
                double k = tmpslide / (dp2p5 - tmpslide);
                int p6x = (int)(((double)p5x + k * p2.x0) / (1.0 + k));
                int p6y = (int)(((double)p5y + k * p2.y0) / (1.0 + k));
                if (len % 2 == 0) {
                    EllipseFunction.UArcPoint uap;
                    int len0;
                    int i;
                    for (i = len0 = len / 2; i > 0; --i) {
                        uap = new EllipseFunction.UArcPoint();
                        uap.x0 = p6x - fontsize - this.gap / 2 - (fontsize + this.gap) * (i - 1);
                        uap.y0 = p6y;
                        uaps.add(uap);
                    }
                    len0 = len / 2;
                    for (i = 0; i < len0; ++i) {
                        uap = new EllipseFunction.UArcPoint();
                        uap.x0 = p6x + this.gap / 2 + (fontsize + this.gap) * i;
                        uap.y0 = p6y;
                        uaps.add(uap);
                    }
                } else {
                    EllipseFunction.UArcPoint uap;
                    int len0;
                    int i;
                    for (i = len0 = len / 2; i > 0; --i) {
                        uap = new EllipseFunction.UArcPoint();
                        uap.x0 = p6x - fontsize / 2 - (fontsize + this.gap) * i;
                        uap.y0 = p6y;
                        uaps.add(uap);
                    }
                    uap = new EllipseFunction.UArcPoint();
                    uap.x0 = p6x - fontsize / 2;
                    uap.y0 = p6y;
                    uaps.add(uap);
                    len0 = len / 2;
                    for (i = 0; i < len0; ++i) {
                        uap = new EllipseFunction.UArcPoint();
                        uap.x0 = p6x + fontsize / 2 + (fontsize + this.gap) * i;
                        uap.y0 = p6y;
                        uaps.add(uap);
                    }
                }
            } else {
                double dp0p2 = Math.sqrt(Math.pow(p0.x0 - p2.x0, 2.0) + Math.pow(p0.y0 - p2.y0, 2.0));
                double k = tmpslide / (dp0p2 - tmpslide);
                int p3x = (int)((p0.x0 + k * p2.x0) / (1.0 + k));
                int p3y = (int)((p0.y0 + k * p2.y0) / (1.0 + k));
                int p4x = p3x + this.leftgap;
                int p4y = p3y;
                for (int i = 0; i < len; ++i) {
                    EllipseFunction.UArcPoint uap = new EllipseFunction.UArcPoint();
                    uap.x0 = p4x + i * (this.gap + fontsize);
                    uap.y0 = p4y;
                    uaps.add(uap);
                }
            }
            int[][] arrPts = uaps.toArrayXY();
            this.drawOnPolygon(arrPts, fontsize);
        } else if (1 == this.tray) {
            double tmpslide = -this.slide;
            int x = this.uar.getX();
            int y = this.uar.getY();
            int width = this.uar.getWidth();
            int fontsize = this.font.getSize();
            int len = this.textArray.length;
            EllipseFunction.UArcPoints uaps = new EllipseFunction.UArcPoints(len);
            if (this.center) {
                int p0x = x + width / 2;
                int p0y = (int)((double)y + tmpslide);
                if (len % 2 == 0) {
                    EllipseFunction.UArcPoint uap;
                    int len0;
                    int i;
                    for (i = len0 = len / 2; i > 0; --i) {
                        uap = new EllipseFunction.UArcPoint();
                        uap.x0 = p0x - fontsize - this.gap / 2 - (fontsize + this.gap) * (i - 1);
                        uap.y0 = p0y;
                        uaps.add(uap);
                    }
                    len0 = len / 2;
                    for (i = 0; i < len0; ++i) {
                        uap = new EllipseFunction.UArcPoint();
                        uap.x0 = p0x + this.gap / 2 + (fontsize + this.gap) * i;
                        uap.y0 = p0y;
                        uaps.add(uap);
                    }
                } else {
                    EllipseFunction.UArcPoint uap;
                    int len0;
                    int i;
                    for (i = len0 = len / 2; i > 0; --i) {
                        uap = new EllipseFunction.UArcPoint();
                        uap.x0 = p0x - fontsize - this.gap - fontsize / 2 - (fontsize + this.gap) * (i - 1);
                        uap.y0 = p0y;
                        uaps.add(uap);
                    }
                    uap = new EllipseFunction.UArcPoint();
                    uap.x0 = p0x - fontsize / 2;
                    uap.y0 = p0y;
                    uaps.add(uap);
                    len0 = len / 2;
                    for (i = 0; i < len0; ++i) {
                        uap = new EllipseFunction.UArcPoint();
                        uap.x0 = p0x + fontsize / 2 + this.gap + (fontsize + this.gap) * i;
                        uap.y0 = p0y;
                        uaps.add(uap);
                    }
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    EllipseFunction.UArcPoint uap = new EllipseFunction.UArcPoint();
                    uap.x0 = x + this.leftgap + (fontsize + this.gap) * i;
                    uap.y0 = (double)y + tmpslide;
                    uaps.add(uap);
                }
            }
            int[][] arrPts = uaps.toArrayXY();
            this.drawOnPolygon(arrPts, fontsize);
        }
    }

    private void drawOnPolygon(int[][] arrPts, int fontsize) {
        int n = arrPts[0].length;
        Font oldFont = this.g2d.getFont();
        this.g2d.setFont(this.font);
        Color oldColor = (Color)this.g2d.getPaint();
        this.g2d.setPaint(this.color);
        this.g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
        for (int i = 0; i < n; ++i) {
            int rx = arrPts[0][i] + fontsize / 2;
            int ry = arrPts[1][i] - fontsize / 2;
            this.g2d.rotate(-this.theta, rx, ry);
            int x2 = arrPts[0][i];
            char tmpChar = this.textArray[i].charAt(0);
            boolean isChinese = false;
            if (tmpChar >= '\u4e00' && tmpChar <= '\u9fa5') {
                isChinese = true;
            }
            if (!isChinese) {
                int fontSize = this.font.getSize();
                x2 += fontSize / 4;
            }
            this.g2d.drawString(this.textArray[i], x2, arrPts[1][i]);
            this.g2d.rotate(this.theta, rx, ry);
        }
        this.g2d.setFont(oldFont);
        this.g2d.setPaint(oldColor);
        this.g2d.setComposite(AlphaComposite.getInstance(3));
    }

    private void drawOnEllipse(int[][] arrPts, double[] arrNorm, boolean horizontal, double theta, int x, int y, int a, int b, float alpha) {
        int n = arrPts[0].length;
        CoordTransformer ctf = new CoordTransformer(-a - x, b + y, 0.0);
        int[][] newArrPts = ctf.translateFromLogicalToDevice(arrPts);
        Font oldFont = this.g2d.getFont();
        this.g2d.setFont(this.font);
        Color oldColor = (Color)this.g2d.getPaint();
        this.g2d.setPaint(this.color);
        this.g2d.setComposite(AlphaComposite.getInstance(3, alpha));
        for (int i = 0; i < n; ++i) {
            String tmpString = this.textArray[i];
            char tmpChar = tmpString.charAt(0);
            boolean isChinese = false;
            if (tmpChar >= '\u4e00' && tmpChar <= '\u9fa5') {
                isChinese = true;
            }
            int x0 = arrPts[0][i];
            int y0 = arrPts[1][i];
            int x1 = newArrPts[0][i];
            int y1 = newArrPts[1][i];
            double normal = arrNorm[i];
            int fontSize = this.font.getSize();
            int x2 = x1 - fontSize / 2;
            int y2 = y1 + fontSize / 2;
            if (!isChinese) {
                x2 += fontSize / 4;
            }
            if (horizontal) {
                normal = 0.0;
            } else if (this.rounding) {
                if (x0 == 0 && y0 > 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 == 0 && y0 < 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 < 0 && y0 == 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 > 0 && y0 == 0) {
                    normal += 4.71238898038469;
                } else if (x0 > 0 && y0 > 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 < 0 && y0 > 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 < 0 && y0 < 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 > 0 && y0 < 0) {
                    normal -= 1.5707963267948966;
                }
            } else {
                normal -= 1.5707963267948966;
                if (x0 == 0 && y0 > 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 == 0 && y0 < 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 < 0 && y0 == 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 > 0 && y0 == 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 > 0 && y0 > 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 < 0 && y0 > 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 < 0 && y0 < 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 > 0 && y0 < 0) {
                    normal -= 1.5707963267948966;
                }
            }
            this.g2d.rotate(-(normal += theta), x1, y1);
            this.g2d.drawString(tmpString, x2, y2);
            this.g2d.rotate(normal, x1, y1);
        }
        this.g2d.setFont(oldFont);
        this.g2d.setPaint(oldColor);
        this.g2d.setComposite(AlphaComposite.getInstance(3));
    }
}

