/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.io.image;

import cfca.sadk.com.itextpdf.io.IOException;
import cfca.sadk.com.itextpdf.io.font.PdfEncodings;
import cfca.sadk.com.itextpdf.io.image.GifImageData;
import cfca.sadk.com.itextpdf.io.image.ImageType;
import cfca.sadk.com.itextpdf.io.image.RawImageData;
import cfca.sadk.com.itextpdf.io.image.RawImageHelper;
import cfca.sadk.com.itextpdf.io.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;

public final class GifImageHelper {
    static final int MAX_STACK_SIZE = 4096;

    public static void processImage(GifImageData image) {
        GifImageHelper.processImage(image, -1);
    }

    public static void processImage(GifImageData image, int lastFrameNumber) {
        GifParameters gif = new GifParameters(image);
        try {
            if (image.getData() == null) {
                image.loadData();
            }
            ByteArrayInputStream gifStream = new ByteArrayInputStream(image.getData());
            GifImageHelper.process(gifStream, gif, lastFrameNumber);
        }
        catch (java.io.IOException e) {
            throw new IOException("GIF image exception.", e);
        }
    }

    private static void process(InputStream stream, GifParameters gif, int lastFrameNumber) throws java.io.IOException {
        gif.input = stream;
        GifImageHelper.readHeader(gif);
        GifImageHelper.readContents(gif, lastFrameNumber);
        if (gif.currentFrame <= lastFrameNumber) {
            throw new IOException("Cannot find {0} frame.").setMessageParams(lastFrameNumber);
        }
    }

    private static void readHeader(GifParameters gif) throws java.io.IOException {
        StringBuilder id = new StringBuilder("");
        for (int i = 0; i < 6; ++i) {
            id.append((char)gif.input.read());
        }
        if (!id.toString().startsWith("GIF8")) {
            throw new IOException("GIF signature not found.");
        }
        GifImageHelper.readLSD(gif);
        if (gif.gctFlag) {
            gif.m_global_table = GifImageHelper.readColorTable(gif.m_gbpc, gif);
        }
    }

    private static void readLSD(GifParameters gif) throws java.io.IOException {
        gif.image.setLogicalWidth(GifImageHelper.readShort(gif));
        gif.image.setLogicalHeight(GifImageHelper.readShort(gif));
        int packed = gif.input.read();
        gif.gctFlag = (packed & 0x80) != 0;
        gif.m_gbpc = (packed & 7) + 1;
        gif.bgIndex = gif.input.read();
        gif.pixelAspect = gif.input.read();
    }

    private static int readShort(GifParameters gif) throws java.io.IOException {
        return gif.input.read() | gif.input.read() << 8;
    }

    private static int readBlock(GifParameters gif) throws java.io.IOException {
        gif.blockSize = gif.input.read();
        if (gif.blockSize <= 0) {
            gif.blockSize = 0;
            return 0;
        }
        gif.blockSize = gif.input.read(gif.block, 0, gif.blockSize);
        return gif.blockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readColorTable(int bpc, GifParameters gif) throws java.io.IOException {
        int ncolors = 1 << bpc;
        int nbytes = 3 * ncolors;
        bpc = GifImageHelper.newBpc(bpc);
        byte[] table = new byte[(1 << bpc) * 3];
        try {
            StreamUtil.readFully(gif.input, table, 0, nbytes);
        }
        finally {
            gif.input.close();
        }
        return table;
    }

    private static int newBpc(int bpc) {
        switch (bpc) {
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                return 4;
            }
            default: {
                return 8;
            }
        }
        return bpc;
    }

    private static void readContents(GifParameters gif, int lastFrameNumber) throws java.io.IOException {
        boolean done = false;
        gif.currentFrame = 0;
        block8: while (!done) {
            int code = gif.input.read();
            switch (code) {
                case 44: {
                    GifImageHelper.readFrame(gif);
                    if (gif.currentFrame == lastFrameNumber) {
                        done = true;
                    }
                    ++gif.currentFrame;
                    continue block8;
                }
                case 33: {
                    code = gif.input.read();
                    switch (code) {
                        case 249: {
                            GifImageHelper.readGraphicControlExt(gif);
                            continue block8;
                        }
                        case 255: {
                            GifImageHelper.readBlock(gif);
                            GifImageHelper.skip(gif);
                            continue block8;
                        }
                    }
                    GifImageHelper.skip(gif);
                    continue block8;
                }
            }
            done = true;
        }
    }

    private static void readFrame(GifParameters gif) throws java.io.IOException {
        boolean skipZero;
        gif.ix = GifImageHelper.readShort(gif);
        gif.iy = GifImageHelper.readShort(gif);
        gif.iw = GifImageHelper.readShort(gif);
        gif.ih = GifImageHelper.readShort(gif);
        int packed = gif.input.read();
        gif.lctFlag = (packed & 0x80) != 0;
        gif.interlace = (packed & 0x40) != 0;
        gif.lctSize = 2 << (packed & 7);
        gif.m_bpc = GifImageHelper.newBpc(gif.m_gbpc);
        if (gif.lctFlag) {
            gif.m_curr_table = GifImageHelper.readColorTable((packed & 7) + 1, gif);
            gif.m_bpc = GifImageHelper.newBpc((packed & 7) + 1);
        } else {
            gif.m_curr_table = gif.m_global_table;
        }
        if (gif.transparency && gif.transIndex >= gif.m_curr_table.length / 3) {
            gif.transparency = false;
        }
        if (gif.transparency && gif.m_bpc == 1) {
            byte[] tp = new byte[12];
            System.arraycopy(gif.m_curr_table, 0, tp, 0, 6);
            gif.m_curr_table = tp;
            gif.m_bpc = 2;
        }
        if (!(skipZero = GifImageHelper.decodeImageData(gif))) {
            GifImageHelper.skip(gif);
        }
        try {
            Object[] colorspace = new Object[4];
            colorspace[0] = "/Indexed";
            colorspace[1] = "/DeviceRGB";
            int len = gif.m_curr_table.length;
            colorspace[2] = len / 3 - 1;
            colorspace[3] = PdfEncodings.convertToString(gif.m_curr_table, null);
            HashMap<String, Object> ad = new HashMap<String, Object>();
            ad.put("ColorSpace", colorspace);
            RawImageData img = new RawImageData(gif.m_out, ImageType.NONE);
            RawImageHelper.updateRawImageParameters(img, gif.iw, gif.ih, 1, gif.m_bpc, gif.m_out);
            RawImageHelper.updateImageAttributes(img, ad);
            gif.image.addFrame(img);
            if (gif.transparency) {
                img.setTransparency(new int[]{gif.transIndex, gif.transIndex});
            }
        }
        catch (Exception e) {
            throw new IOException("GIF image exception.", e);
        }
    }

    private static boolean decodeImageData(GifParameters gif) throws java.io.IOException {
        int code;
        int NullCode = -1;
        int npix = gif.iw * gif.ih;
        boolean skipZero = false;
        if (gif.prefix == null) {
            gif.prefix = new short[4096];
        }
        if (gif.suffix == null) {
            gif.suffix = new byte[4096];
        }
        if (gif.pixelStack == null) {
            gif.pixelStack = new byte[4097];
        }
        gif.m_line_stride = (gif.iw * gif.m_bpc + 7) / 8;
        gif.m_out = new byte[gif.m_line_stride * gif.ih];
        int pass = 1;
        int inc = gif.interlace ? 8 : 1;
        int line = 0;
        int xpos = 0;
        int data_size = gif.input.read();
        int clear = 1 << data_size;
        int end_of_information = clear + 1;
        int available = clear + 2;
        int old_code = NullCode;
        int code_size = data_size + 1;
        int code_mask = (1 << code_size) - 1;
        for (code = 0; code < clear; ++code) {
            gif.prefix[code] = 0;
            gif.suffix[code] = (byte)code;
        }
        int bi = 0;
        int top = 0;
        int first = 0;
        int count = 0;
        int bits = 0;
        int datum = 0;
        int i = 0;
        while (i < npix) {
            if (top == 0) {
                if (bits < code_size) {
                    if (count == 0) {
                        count = GifImageHelper.readBlock(gif);
                        if (count <= 0) {
                            skipZero = true;
                            break;
                        }
                        bi = 0;
                    }
                    datum += (gif.block[bi] & 0xFF) << bits;
                    bits += 8;
                    ++bi;
                    --count;
                    continue;
                }
                code = datum & code_mask;
                datum >>= code_size;
                bits -= code_size;
                if (code > available || code == end_of_information) break;
                if (code == clear) {
                    code_size = data_size + 1;
                    code_mask = (1 << code_size) - 1;
                    available = clear + 2;
                    old_code = NullCode;
                    continue;
                }
                if (old_code == NullCode) {
                    gif.pixelStack[top++] = gif.suffix[code];
                    old_code = code;
                    first = code;
                    continue;
                }
                int in_code = code;
                if (code == available) {
                    gif.pixelStack[top++] = (byte)first;
                    code = old_code;
                }
                while (code > clear) {
                    gif.pixelStack[top++] = gif.suffix[code];
                    code = gif.prefix[code];
                }
                first = gif.suffix[code] & 0xFF;
                if (available >= 4096) break;
                gif.pixelStack[top++] = (byte)first;
                gif.prefix[available] = (short)old_code;
                gif.suffix[available] = (byte)first;
                if ((++available & code_mask) == 0 && available < 4096) {
                    ++code_size;
                    code_mask += available;
                }
                old_code = in_code;
            }
            ++i;
            GifImageHelper.setPixel(xpos, line, gif.pixelStack[--top], gif);
            if (++xpos < gif.iw) continue;
            xpos = 0;
            if ((line += inc) < gif.ih) continue;
            if (gif.interlace) {
                do {
                    switch (++pass) {
                        case 2: {
                            line = 4;
                            break;
                        }
                        case 3: {
                            line = 2;
                            inc = 4;
                            break;
                        }
                        case 4: {
                            line = 1;
                            inc = 2;
                            break;
                        }
                        default: {
                            line = gif.ih - 1;
                            inc = 0;
                        }
                    }
                } while (line >= gif.ih);
                continue;
            }
            line = gif.ih - 1;
            inc = 0;
        }
        return skipZero;
    }

    private static void setPixel(int x, int y, int v, GifParameters gif) {
        if (gif.m_bpc == 8) {
            int pos = x + gif.iw * y;
            gif.m_out[pos] = (byte)v;
        } else {
            int pos = gif.m_line_stride * y + x / (8 / gif.m_bpc);
            int vout = v << 8 - gif.m_bpc * (x % (8 / gif.m_bpc)) - gif.m_bpc;
            int n = pos;
            gif.m_out[n] = (byte)(gif.m_out[n] | (byte)vout);
        }
    }

    private static void readGraphicControlExt(GifParameters gif) throws java.io.IOException {
        gif.input.read();
        int packed = gif.input.read();
        gif.dispose = (packed & 0x1C) >> 2;
        if (gif.dispose == 0) {
            gif.dispose = 1;
        }
        gif.transparency = (packed & 1) != 0;
        gif.delay = GifImageHelper.readShort(gif) * 10;
        gif.transIndex = gif.input.read();
        gif.input.read();
    }

    private static void skip(GifParameters gif) throws java.io.IOException {
        do {
            GifImageHelper.readBlock(gif);
        } while (gif.blockSize > 0);
    }

    private static class GifParameters {
        InputStream input;
        boolean gctFlag;
        int bgIndex;
        int bgColor;
        int pixelAspect;
        boolean lctFlag;
        boolean interlace;
        int lctSize;
        int ix;
        int iy;
        int iw;
        int ih;
        byte[] block = new byte[256];
        int blockSize = 0;
        int dispose = 0;
        boolean transparency = false;
        int delay = 0;
        int transIndex;
        short[] prefix;
        byte[] suffix;
        byte[] pixelStack;
        byte[] pixels;
        byte[] m_out;
        int m_bpc;
        int m_gbpc;
        byte[] m_global_table;
        byte[] m_local_table;
        byte[] m_curr_table;
        int m_line_stride;
        byte[] fromData;
        URL fromUrl;
        int currentFrame;
        GifImageData image;

        public GifParameters(GifImageData image) {
            this.image = image;
        }
    }
}

