/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener;

import cfca.sadk.com.itextpdf.kernel.geom.LineSegment;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.LocationTextExtractionStrategy;
import cfca.sadk.seal.base.util.PDFUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CharacterRenderInfo
extends LocationTextExtractionStrategy.TextChunk {
    private Rectangle boundingBox;

    static StringConversionInfo mapString(List<CharacterRenderInfo> cris) {
        HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
        StringBuilder sb = new StringBuilder();
        LocationTextExtractionStrategy.TextChunk lastChunk = null;
        for (int i = 0; i < cris.size(); ++i) {
            CharacterRenderInfo chunk = cris.get(i);
            if (lastChunk == null) {
                indexMap.put(sb.length(), i);
                sb.append(chunk.getText());
            } else if (chunk.sameLine(lastChunk)) {
                if (!(!chunk.getLocation().isAtWordBoundary(lastChunk.getLocation()) || chunk.getText().startsWith(" ") || chunk.getText().endsWith(" ") || "\u25a1".equals(chunk.getText()) || PDFUtil.isInteger(chunk.getText()))) {
                    sb.append(' ');
                }
                indexMap.put(sb.length(), i);
                sb.append(chunk.getText());
            } else {
                indexMap.put(sb.length(), i);
                sb.append(chunk.getText());
            }
            lastChunk = chunk;
        }
        StringConversionInfo ret = new StringConversionInfo();
        ret.indexMap = indexMap;
        ret.text = sb.toString();
        return ret;
    }

    public CharacterRenderInfo(TextRenderInfo tri) {
        super(tri == null ? "" : tri.getText(), tri == null ? null : CharacterRenderInfo.getLocation(tri));
        if (tri == null) {
            throw new IllegalArgumentException("TextRenderInfo argument is not nullable.");
        }
        if (tri.getText().length() != 1) {
            throw new IllegalArgumentException("CharacterRenderInfo objects represent a single character. They should not be made from TextRenderInfo objects containing more than a single character of text.");
        }
        float x0 = tri.getDescentLine().getStartPoint().get(0);
        float y0 = tri.getDescentLine().getStartPoint().get(1);
        float h = tri.getAscentLine().getStartPoint().get(1) - tri.getDescentLine().getStartPoint().get(1);
        float w = Math.abs(tri.getBaseline().getStartPoint().get(0) - tri.getBaseline().getEndPoint().get(0));
        this.boundingBox = new Rectangle(x0, y0, w, h);
    }

    public Rectangle getBoundingBox() {
        return this.boundingBox;
    }

    private static LocationTextExtractionStrategy.ITextChunkLocation getLocation(TextRenderInfo tri) {
        LineSegment baseline = tri.getBaseline();
        return new LocationTextExtractionStrategy.TextChunkLocationDefaultImp(baseline.getStartPoint(), baseline.getEndPoint(), tri.getSingleSpaceWidth());
    }

    static class StringConversionInfo {
        Map<Integer, Integer> indexMap;
        String text;

        StringConversionInfo() {
        }
    }
}

