/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.svg.renderers.impl;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.CanvasGraphicsState;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import cfca.sadk.com.itextpdf.layout.Canvas;
import cfca.sadk.com.itextpdf.layout.property.TextAlignment;
import cfca.sadk.com.itextpdf.layout.property.VerticalAlignment;
import cfca.sadk.com.itextpdf.styledxmlparser.css.util.CssUtils;
import cfca.sadk.com.itextpdf.svg.renderers.ISvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.SvgDrawContext;
import cfca.sadk.com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.impl.ISvgTextNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.impl.SvgNodeUtil;
import cfca.sadk.com.itextpdf.svg.utils.SvgTextUtil;

public class TextLeafSvgNodeRenderer
extends AbstractSvgNodeRenderer
implements ISvgTextNodeRenderer {
    private static Logger businessLog = LoggerFactory.getLogger(TextLeafSvgNodeRenderer.class);
    private static final double TIMES = 1.3333;
    private static final String BASIC_STRING = "\u4e2d\u6587Aabgi-";

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        TextLeafSvgNodeRenderer copy = new TextLeafSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }

    @Override
    public float getTextContentLength(float parentFontSize, PdfFont font) {
        float contentLength = 0.0f;
        if (font != null && this.attributesAndStyles != null && this.attributesAndStyles.containsKey("text_content")) {
            float fontSize = SvgTextUtil.resolveFontSize(this, parentFontSize);
            String content = (String)this.attributesAndStyles.get("text_content");
            contentLength = font.getWidth(content, fontSize);
        }
        return contentLength;
    }

    @Override
    public float[] getRelativeTranslation() {
        return new float[]{0.0f, 0.0f};
    }

    @Override
    public boolean containsRelativeMove() {
        return false;
    }

    @Override
    public boolean containsAbsolutePositionChange() {
        return false;
    }

    @Override
    public float[][] getAbsolutePositionChanges() {
        float[] part = new float[]{0.0f};
        return new float[][]{part, part};
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null && this.attributesAndStyles.containsKey("text_content")) {
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            businessLog.info("attributesAndStyles=" + this.attributesAndStyles);
            currentCanvas.concatMatrix(this.calculateTransformation(context));
            String text = (String)this.attributesAndStyles.get("text_content");
            String x = (String)this.attributesAndStyles.get("x");
            x = x == null ? this.getParent().getAttribute("x") : x;
            String y = (String)this.attributesAndStyles.get("y");
            y = y == null ? this.getParent().getAttribute("y") : y;
            float[] startPoint = SvgNodeUtil.getStartPoint(this);
            x = String.valueOf(Float.parseFloat(this.getNumFromStr(x, "x")) - startPoint[0]);
            y = String.valueOf(Float.parseFloat(this.getNumFromStr(y, "y")) - startPoint[1]);
            Rectangle viewPort = context.getCurrentViewPort();
            float height = viewPort.getHeight();
            String opacity = (String)this.attributesAndStyles.get("opacity");
            String fontWeightStr = (String)this.attributesAndStyles.get("font-weight");
            String fontSizeStr = this.getParent().getAttribute("font-size");
            float parentFontSize = CssUtils.parseAbsoluteFontSize(fontSizeStr);
            float fontSize = SvgTextUtil.resolveFontSize(this, parentFontSize);
            PdfFont font = this.resolveFont(context, text);
            String letterSpacingStr = (String)this.attributesAndStyles.get("letter-spacing");
            letterSpacingStr = letterSpacingStr == null ? this.getParent().getAttribute("letter-spacing") : letterSpacingStr;
            float letterSpacing = 0.0f;
            if (null != letterSpacingStr) {
                letterSpacing = CssUtils.parseAbsoluteLength(letterSpacingStr);
                currentCanvas.setCharacterSpacing(letterSpacing);
            }
            businessLog.info("TextLeafSvgNode text=" + text + ",fontSize=" + fontSize + ",letterSpacing=" + letterSpacing);
            currentCanvas.setFontAndSize(font, fontSize);
            float _x = CssUtils.parseAbsoluteLength(this.getNumFromStr(x, "x"));
            float _y = CssUtils.parseAbsoluteLength(this.getNumFromStr(y, "y"));
            PdfDocument pdfDoc = currentCanvas.getDocument();
            PdfExtGState opacityGraphicsState = new PdfExtGState();
            Float strokeOpacity = Float.valueOf(opacity);
            opacityGraphicsState.setStrokeOpacity(strokeOpacity.floatValue() * strokeOpacity.floatValue());
            currentCanvas.setExtGState(opacityGraphicsState);
            Canvas cc = new Canvas(currentCanvas, pdfDoc, new Rectangle((float)text.length() * fontSize, fontSize));
            cc.setFont(font);
            cc.setFontSize(fontSize);
            cc.setCharacterSpacing(letterSpacing);
            currentCanvas.saveState();
            float descent = font.getFontProgram().getFontMetrics().getLineGap() != 0 ? (float)((double)font.getDescent(BASIC_STRING, fontSize) * 1.3333) : (float)((double)((float)font.getFontProgram().getFontMetrics().getTypoDescender() * fontSize / 1000.0f) * 1.3333);
            boolean isBold = false;
            boolean isItalic = false;
            if ("bold".equals(fontWeightStr)) {
                isBold = true;
            } else if ("italic".equals(fontWeightStr)) {
                isItalic = true;
            } else if ("bolditalic".equals(fontWeightStr)) {
                isBold = true;
                isItalic = true;
            }
            CanvasGraphicsState gs = currentCanvas.getGraphicsState();
            Color strokeColor = gs.getFillColor();
            cc.setStrokeColor(strokeColor);
            currentCanvas.stroke().restoreState();
            cc.showTextAligned(text, _x, height - _y + descent, TextAlignment.LEFT, VerticalAlignment.BOTTOM, 0.0f, isBold, isItalic);
            cc.close();
        }
    }

    @Override
    protected boolean canElementFill() {
        return false;
    }
}

