/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.httpframework.http;

import cfca.paperless.httpframework.http.HttpHeaders;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequest {
    static final int DEFAULT_MAX_REQ_HEADERS = 256;
    static final int BUFFER_LENGTH = 8196;
    static final int MAX_URL_LENGTH = 0x500A00;
    private static final Logger logger = LoggerFactory.getLogger(HttpRequest.class);
    public InputStream inStream;
    public OutputStream outStream;
    byte[] headerBuffer = new byte[8196];
    int position;
    int lastValid;
    StringBuilder lineBuffer;
    private HttpHeaders httpHeaders;
    private String method;
    private String url;
    private String protocol;
    private boolean urlParamFlag = false;
    private boolean parsedBodyFlag = false;

    public HttpRequest(InputStream rawInStream) throws IOException {
        this.inStream = rawInStream;
        this.readFirstLine();
        this.headers();
    }

    public void readFirstLine() throws IOException {
        int start = 0;
        byte chr = 0;
        do {
            if (this.position < this.lastValid) continue;
            this.fill();
        } while ((chr = this.headerBuffer[this.position++]) == 13 || chr == 10);
        --this.position;
        start = this.position;
        boolean space = false;
        while (!space) {
            if (this.position >= this.lastValid) {
                this.fill();
            }
            if (this.headerBuffer[this.position] == 32 || this.headerBuffer[this.position] == 9) {
                space = true;
                this.method = new String(this.headerBuffer, start, this.position - start, "UTF-8");
            }
            ++this.position;
        }
        while (space) {
            if (this.position >= this.lastValid) {
                this.fill();
            }
            if (this.headerBuffer[this.position] == 32 || this.headerBuffer[this.position] == 9) {
                ++this.position;
                continue;
            }
            space = false;
        }
        start = this.position;
        int end = 0;
        int questionPos = -1;
        boolean eol = false;
        while (!space) {
            if (this.position >= this.lastValid) {
                this.fill();
            }
            if (this.headerBuffer[this.position] == 32 || this.headerBuffer[this.position] == 9) {
                space = true;
                end = this.position;
            } else if (this.headerBuffer[this.position] == 13 || this.headerBuffer[this.position] == 10) {
                eol = true;
                space = true;
                end = this.position;
            } else if (this.headerBuffer[this.position] == 63 && questionPos == -1) {
                questionPos = this.position;
                this.urlParamFlag = true;
            }
            ++this.position;
        }
        this.url = new String(this.headerBuffer, start, end - start, "UTF-8");
        while (space) {
            if (this.position >= this.lastValid) {
                this.fill();
            }
            if (this.headerBuffer[this.position] == 32 || this.headerBuffer[this.position] == 9) {
                ++this.position;
                continue;
            }
            space = false;
        }
        start = this.position;
        end = 0;
        while (!eol) {
            if (this.position >= this.lastValid) {
                this.fill();
            }
            if (this.headerBuffer[this.position] == 13) {
                end = this.position;
            } else if (this.headerBuffer[this.position] == 10) {
                if (end == 0) {
                    end = this.position;
                }
                eol = true;
            }
            ++this.position;
        }
        this.protocol = end - start > 0 ? new String(this.headerBuffer, start, end - start, "UTF-8") : "";
    }

    public void fill() throws IOException {
        if (this.lastValid == this.headerBuffer.length) {
            throw new IllegalArgumentException("request head too large");
        }
        int nRead = this.inStream.read(this.headerBuffer, this.position, this.headerBuffer.length - this.lastValid);
        if (nRead > 0) {
            this.lastValid = this.position + nRead;
        }
        if (nRead <= 0) {
            throw new EOFException("Unexpected EOF read on socket");
        }
    }

    public HttpHeaders headers() throws IOException {
        if (null != this.httpHeaders) {
            return this.httpHeaders;
        }
        this.httpHeaders = new HttpHeaders();
        while (this.parseHeader()) {
        }
        return this.httpHeaders;
    }

    private boolean parseHeader() throws IOException {
        String key = null;
        String value = null;
        byte chr = 0;
        while (true) {
            if (this.position >= this.lastValid) {
                this.fill();
            }
            if ((chr = this.headerBuffer[this.position]) != 13) {
                if (chr != 10) break;
                ++this.position;
                return false;
            }
            ++this.position;
        }
        int start = this.position;
        boolean colon = false;
        while (!colon) {
            if (this.position >= this.lastValid) {
                this.fill();
            }
            if (this.headerBuffer[this.position] == 58) {
                colon = true;
                key = new String(this.headerBuffer, start, this.position - start, "UTF-8");
            }
            if ((chr = this.headerBuffer[this.position]) >= 65 && chr <= 90) {
                this.headerBuffer[this.position] = (byte)(chr - -32);
            }
            ++this.position;
        }
        start = this.position;
        int realPos = this.position;
        boolean eol = false;
        boolean validLine = true;
        while (validLine) {
            boolean space = true;
            while (space) {
                if (this.position >= this.lastValid) {
                    this.fill();
                }
                if (this.headerBuffer[this.position] == 32 || this.headerBuffer[this.position] == 9) {
                    ++this.position;
                    continue;
                }
                space = false;
            }
            int lastSignificantChar = realPos;
            while (!eol) {
                if (this.position >= this.lastValid) {
                    this.fill();
                }
                if (this.headerBuffer[this.position] != 13) {
                    if (this.headerBuffer[this.position] == 10) {
                        eol = true;
                    } else if (this.headerBuffer[this.position] == 32) {
                        this.headerBuffer[realPos] = this.headerBuffer[this.position];
                        ++realPos;
                    } else {
                        this.headerBuffer[realPos] = this.headerBuffer[this.position];
                        lastSignificantChar = ++realPos;
                    }
                }
                ++this.position;
            }
            realPos = lastSignificantChar;
            if (this.position >= this.lastValid) {
                this.fill();
            }
            if ((chr = this.headerBuffer[this.position]) != 32 && chr != 9) {
                validLine = false;
                continue;
            }
            eol = false;
            this.headerBuffer[realPos] = chr;
            ++realPos;
        }
        value = new String(this.headerBuffer, start, realPos - start, "UTF-8");
        if (null != key && !"".equals(key)) {
            this.headers().add(key, value);
        }
        return true;
    }

    public byte[] body() throws IOException {
        if (this.httpHeaders == null) {
            this.headers();
        }
        if (this.parsedBodyFlag) {
            throw new IOException("http request body has been read!");
        }
        byte[] bodyBuffer = null;
        String contentLength = this.httpHeaders.getFirst("content-length");
        if (null != contentLength) {
            int contentBufferLength = Integer.parseInt(contentLength);
            logger.debug("content-length:" + contentLength);
            bodyBuffer = new byte[contentBufferLength];
            int validLength = this.lastValid - this.position;
            System.arraycopy(this.headerBuffer, this.position, bodyBuffer, 0, validLength);
            int lengthToRead = contentBufferLength - (this.lastValid - this.position);
            if (lengthToRead > 0) {
                this.readStream(this.inStream, bodyBuffer, validLength, lengthToRead, contentBufferLength);
            }
        }
        this.parsedBodyFlag = true;
        return bodyBuffer;
    }

    private void readStream(InputStream inputStream, byte[] byteBuffer, int start, int byteLength, int contentLength) throws IOException {
        block4: {
            if (null == inputStream) {
                logger.error("Input Stream is null");
                throw new IOException("Input Stream is null");
            }
            if (byteLength <= 0) {
                logger.error("http request read stream error, bytelength: " + byteLength);
            }
            int ret = -1;
            int leftDataLength = byteLength;
            do {
                ret = inputStream.read(byteBuffer, start, leftDataLength);
                logger.debug("ret=" + ret);
                if (-1 == ret || 0 == ret) {
                    logger.error("read inputStream in httpRequest error, invalid ret value, ret: {}", (Object)ret);
                    throw new IOException("read inputStream in httpRequest error, invalid ret value");
                }
                leftDataLength -= ret;
                if ((start += ret) == contentLength) break block4;
            } while (start <= contentLength);
            logger.error("read socket inputStream error, pos > Content-Length, pos: {}, Content-Length: {}", (Object)start, (Object)byteLength);
        }
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public boolean getUrlParamFlag() {
        return this.urlParamFlag;
    }

    public void setUrlParamFlag(boolean urlParamFlag) {
        this.urlParamFlag = urlParamFlag;
    }
}

