/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.tax;

import cfca.sadk.ofd.base.bean.annot.Annot;
import cfca.sadk.ofd.base.bean.annot.Appearance;
import cfca.sadk.ofd.base.bean.annot.PageAnnot;
import cfca.sadk.ofd.base.bean.annotations.Annotations;
import cfca.sadk.ofd.base.bean.annotations.Page;
import cfca.sadk.ofd.base.common.DateFormatUtil;
import cfca.sadk.ofd.base.common.JaxbUtil;
import cfca.sadk.ofd.base.config.SignAppearance;
import cfca.sadk.ofd.base.ofd.OFDConstants;
import cfca.sadk.ofd.base.seal.SealXMLUtil;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.dom4j.Element;

public class TaxUtil {
    public static void addVerifyArea(Map<String, byte[]> filesMap, Element root, String baseDir, SignAppearance appearance, Date signDate) throws Exception {
        if (appearance.getPageNo() > 0) {
            Annotations annots = new Annotations();
            Page page = new Page();
            Map<String, String> pagesMap = SealXMLUtil.getPageRefIds(filesMap, baseDir);
            String pageRefID = pagesMap.get("Pages/Page_" + (appearance.getPageNo() - 1) + "/Content.xml");
            if (pageRefID != null) {
                page.setPageID(new BigInteger(pageRefID));
                page.setFileLoc("/" + baseDir + "Annots" + "/" + "Page_" + (appearance.getPageNo() - 1) + "/" + "Annotation.xml");
                annots.getPage().add(page);
                ByteArrayOutputStream annotsStream = new ByteArrayOutputStream();
                JaxbUtil.toXML(annots, annotsStream);
                byte[] signDatas = annotsStream.toByteArray();
                filesMap.put(baseDir + "Annots" + "/" + "Annotations.xml", signDatas);
                PageAnnot pageAnnot = new PageAnnot();
                Annot annot = new Annot();
                annot.setCreator(appearance.getCompanyName());
                annot.setType("Stamp");
                annot.setSubtype("SignatureInFile");
                annot.setName(UUID.randomUUID().toString());
                annot.setID(SealXMLUtil.getMaxDataId(root, baseDir).add(OFDConstants.annotsInterval));
                DateFormatUtil formatUtil = new DateFormatUtil();
                String modifyTime = formatUtil.getModifyString(signDate);
                annot.setLastModDate(modifyTime);
                Appearance appea = new Appearance();
                appea.setBoundary("4.500 104.000 115.000 20.000");
                annot.setAppearance(appea);
                pageAnnot.setAnnot(annot);
                ByteArrayOutputStream annotsStream1 = new ByteArrayOutputStream();
                JaxbUtil.toXML(pageAnnot, annotsStream1);
                filesMap.put(baseDir + "Annots" + "/" + "Page_" + (appearance.getPageNo() - 1) + "/" + "Annotation.xml", annotsStream1.toByteArray());
                SealXMLUtil.addAnnotsInDocument(filesMap, baseDir);
            }
        }
    }
}

