/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.ecc;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.ECCCurveId;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardKey;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECKey;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;

public final class ECCCardCurveHelper {
    private ECCCardCurveHelper() {
    }

    static int bitLength(ECDomainParameters ecParams) {
        if (ecParams == null) {
            throw new IllegalArgumentException("bitLength build: domain-params is null");
        }
        if (ecParams.getCurve() == null) {
            throw new IllegalArgumentException("bitLength build: domain-params#N is null");
        }
        return ecParams.getCurve().getFieldSize();
    }

    static int bitLength(ECParameterSpec ecParamSpec) {
        if (ecParamSpec == null) {
            throw new IllegalArgumentException("bitLength build: ECParameterSpec is null");
        }
        if (ecParamSpec.getCurve() == null) {
            throw new IllegalArgumentException("bitLength build: ECParameterSpec#N is null");
        }
        return ecParamSpec.getCurve().getFieldSize();
    }

    static ECParameterSpec buildECParameterSpec(int curveId) throws CryptoException {
        ECCCurveId curve = ECCCurveId.findECCCurveId(curveId);
        return curve == null ? null : curve.getCurveParams();
    }

    static ECParameterSpec buildECParameterSpec(ECPublicKeyParameters ecPubKeyParams) {
        if (ecPubKeyParams == null) {
            throw new IllegalArgumentException("buildECParameterSpec build: ecPubKeyParams is null");
        }
        return ECCCardCurveHelper.buildECParameterSpec(ecPubKeyParams.getParameters());
    }

    static ECParameterSpec buildECParameterSpec(ECPrivateKeyParameters ecPriKeyParams) {
        if (ecPriKeyParams == null) {
            throw new IllegalArgumentException("buildECParameterSpec build: ecPriKeyParams is null");
        }
        return ECCCardCurveHelper.buildECParameterSpec(ecPriKeyParams.getParameters());
    }

    static ECParameterSpec buildECParameterSpec(ECDomainParameters ecParams) {
        if (ecParams == null) {
            throw new IllegalArgumentException("buildECParameterSpec build: domain-params is null");
        }
        return new ECParameterSpec(ecParams.getCurve(), ecParams.getG(), ecParams.getN(), ecParams.getH(), ecParams.getSeed());
    }

    static ECDomainParameters buildECDomainParameters(ECParameterSpec ecParamSpec) {
        if (ecParamSpec == null) {
            throw new IllegalArgumentException("buildECDomainParameters build: ecParamSpec is null");
        }
        return new ECDomainParameters(ecParamSpec.getCurve(), ecParamSpec.getG(), ecParamSpec.getN(), ecParamSpec.getH(), ecParamSpec.getSeed());
    }

    static int getCurveId(ECKey cardKey) throws CryptoException {
        if (cardKey == null) {
            throw new CryptoException("parameter cardKey is null");
        }
        int curveId = 0;
        if (cardKey instanceof ECCCardKey) {
            ECCCurveId curve = ((ECCCardKey)((Object)cardKey)).getCurveId();
            if (curve != null) {
                curveId = curve.getCurveId();
            }
        } else {
            curveId = ECCCardCurveHelper.getCurveId(cardKey.getParameters());
        }
        return curveId;
    }

    static int getCurveId(String curveOid) throws CryptoException {
        ECCCurveId curveId = ECCCurveId.findECCCurveId(curveOid);
        if (curveId == null) {
            throw new CryptoException("do not support curveOid: " + curveOid);
        }
        return curveId.getCurveId();
    }

    static int getCurveId(ECParameterSpec ecParamSpec) throws CryptoException {
        ECCCurveId curve;
        int curveId = 0;
        if (ecParamSpec != null && (curve = ECCCurveId.findECCCurveId(ecParamSpec)) != null) {
            curveId = curve.getCurveId();
        }
        return curveId;
    }
}

