/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client;

import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.cmp.PKIFreeText;
import cfca.sadk.org.bouncycastle.asn1.cms.Attribute;
import cfca.sadk.org.bouncycastle.asn1.cms.AttributeTable;
import cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.Time;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.tsp.TimeStampResp;
import cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import cfca.sadk.org.bouncycastle.cms.CMSException;
import cfca.sadk.org.bouncycastle.cms.CMSSignedData;
import cfca.sadk.org.bouncycastle.cms.SignerId;
import cfca.sadk.org.bouncycastle.cms.SignerInformationVerifier;
import cfca.sadk.org.bouncycastle.tsp.TSPException;
import cfca.sadk.org.bouncycastle.tsp.TSPValidationException;
import cfca.sadk.org.bouncycastle.tsp.TimeStampToken;
import cfca.sadk.org.bouncycastle.tsp.TimeStampTokenInfo;
import cfca.sadk.org.bouncycastle.util.Selector;
import cfca.sadk.org.bouncycastle.util.Store;
import cfca.sadk.timestamp.client.BusinessTrustCerts;
import cfca.sadk.timestamp.client.TSACertHolder;
import cfca.sadk.timestamp.client.TSASignerInformationVerifier;
import cfca.sadk.timestamp.client.api.Timestamp;
import cfca.sadk.timestamp.client.bean.HashAlgorithm;
import cfca.sadk.timestamp.client.bean.MessageImprint;
import cfca.sadk.timestamp.client.bean.PKIFailureInfo;
import cfca.sadk.timestamp.client.bean.PKIStatus;
import cfca.sadk.timestamp.client.bean.PKIStatusInfo;
import cfca.sadk.timestamp.client.bean.TSTAccuracy;
import cfca.sadk.timestamp.client.bean.TSTInfo;
import cfca.sadk.timestamp.client.env.DefaultSessionLib;
import cfca.sadk.timestamp.client.logging.TscLogging;
import cfca.sadk.timestamp.client.utils.TscStrings;
import cfca.sadk.timestamp.exception.TSAErrorCode;
import cfca.sadk.timestamp.exception.TSAException;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.http.util.Args;

final class TSASignedData {
    final TSACertHolder holder;
    final TimeStampToken timeStampToken;
    final Timestamp timestamp;
    final boolean requiredCertOptional;
    final X509Cert signCert;

    public TSASignedData(byte[] timestampRequestBytes, byte[] timestampResponseBytes, boolean requiredCertOptional, X509Cert signCert) throws TSAException {
        String[] values;
        TimeStampToken timeStampToken;
        TimeStampResp timestampResp;
        if (timestampResponseBytes == null) {
            throw new TSAException(TSAErrorCode.timestampTSASignedDataInvalid, "timestamp timestampResponseBytes is null");
        }
        this.requiredCertOptional = requiredCertOptional;
        this.signCert = signCert;
        try {
            timestampResp = TimeStampResp.getInstance((Object)timestampResponseBytes);
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timestampTSASignedDataInvalid, "timestamp TSASignedData decode failure", (Throwable)e);
        }
        if (timestampResp == null) {
            if (TscLogging.ERROR_LOGGER.isErrorEnabled()) {
                TscLogging.ERROR_LOGGER.error("decoded return timestampResp = null, timestampRequestBytes={}", (Object)TscStrings.toHexString(timestampRequestBytes));
            }
            throw new TSAException(TSAErrorCode.timestampTSASignedDataInvalid, "timestamp timestampResponseBytes invalid");
        }
        cfca.sadk.org.bouncycastle.asn1.cmp.PKIStatusInfo statusInfo = timestampResp.getStatus();
        if (statusInfo == null) {
            throw new TSAException(TSAErrorCode.timestampTSASignedDataMissingStatusInfo, "required statusInfo");
        }
        ContentInfo tokenContentInfo = timestampResp.getTimeStampToken();
        boolean hasTokenContentInfo = tokenContentInfo != null;
        PKIStatusInfo pkiStatusInfo = this.buildStatusInfoFrom(statusInfo, hasTokenContentInfo);
        if (pkiStatusInfo.getStatus() == PKIStatus.granted || pkiStatusInfo.getStatus() == PKIStatus.grantedWithMods) {
            CMSSignedData signedData;
            if (!hasTokenContentInfo) {
                throw new TSAException(TSAErrorCode.timestampTSASignedDataMissingTimeStampToken, "timeStampToken MUST be present");
            }
            try {
                signedData = new CMSSignedData(tokenContentInfo);
            }
            catch (CMSException e) {
                throw new TSAException(TSAErrorCode.timestampTSASignedDataInvalidContentInfo, "invalid tokenContentInfo", (Throwable)e);
            }
            try {
                timeStampToken = new TimeStampToken(signedData);
            }
            catch (TSPValidationException e) {
                throw new TSAException(TSAErrorCode.timeStampTokenValidationFailure, e.getMessage(), (Throwable)e);
            }
            catch (TSPException e) {
                throw new TSAException(TSAErrorCode.timeStampTokenFailureWithTSAException, e.getMessage(), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new TSAException(TSAErrorCode.timeStampTokenFailureWithIllegalArgumentException, e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new TSAException(TSAErrorCode.timeStampTokenFailureWithIOException, e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw new TSAException(TSAErrorCode.timeStampTokenFailureWithException, e.getMessage(), (Throwable)e);
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append((Object)pkiStatusInfo.getStatus());
        builder.append(": ");
        if (pkiStatusInfo.getFreeText() != null && (values = pkiStatusInfo.getFreeText().getFreeTexts()) != null && values.length != 0) {
            for (String value : values) {
                builder.append(" ");
                builder.append(value);
            }
        }
        builder.append(" #failure: ");
        int fail = pkiStatusInfo.getFailInfo();
        PKIFailureInfo failure = PKIFailureInfo.find(fail);
        if (failure == null) {
            builder.append("0x" + Integer.toHexString(fail));
        } else {
            builder.append((Object)failure);
        }
        throw new TSAException(TSAErrorCode.timestampClientResponseFailure, builder.toString());
        TSTInfo tstInfo = this.buildTSTInfoFrom(timeStampToken);
        TSACertHolder holder = this.fetchSignedCertFrom(timeStampToken, requiredCertOptional);
        Date signedTime = this.buildSignedTimeFrom(timeStampToken);
        MessageImprint messageImprint = tstInfo.getMessageImprint();
        X509Cert cert = holder == null ? null : holder.getX509Cert();
        this.timestamp = new Timestamp(pkiStatusInfo, tstInfo, signedTime, cert, messageImprint, timestampRequestBytes, timestampResponseBytes);
        this.timeStampToken = timeStampToken;
        this.holder = holder;
    }

    private final PKIStatusInfo buildStatusInfoFrom(cfca.sadk.org.bouncycastle.asn1.cmp.PKIStatusInfo statusInfo, boolean hasTimeStampToken) throws TSAException {
        int failCode;
        String[] freeText;
        Args.notNull((Object)statusInfo, (String)"statusInfo");
        if (statusInfo.getStatus() == null) {
            throw new TSAException(TSAErrorCode.timestampTSASignedDataMissingStatusCode, "required statusCode");
        }
        PKIStatus status = PKIStatus.find(statusInfo.getStatus().intValue());
        if (status == null) {
            throw new TSAException(TSAErrorCode.timestampTSASignedDataUnknownStatusCode, "invalid statusCode=" + statusInfo.getStatus());
        }
        switch (status) {
            case granted: {
                break;
            }
            case grantedWithMods: {
                break;
            }
            case rejection: {
                break;
            }
            case waiting: {
                break;
            }
            case revocationWarning: {
                break;
            }
            case revocationNotification: {
                break;
            }
            default: {
                throw new TSAException(TSAErrorCode.timestampTSASignedDataUnknownStatusCode, "invalid statusCode=" + statusInfo.getStatus());
            }
        }
        if (status == PKIStatus.granted || status == PKIStatus.grantedWithMods) {
            if (!hasTimeStampToken) {
                throw new TSAException(TSAErrorCode.timestampTSASignedDataMissingTimeStampToken, "timeStampToken MUST be present");
            }
            freeText = null;
            failCode = 0;
        } else {
            if (hasTimeStampToken) {
                throw new TSAException(TSAErrorCode.timestampTSASignedDataContainTimeStampToken, "timeStampToken MUST NOT be present");
            }
            DERBitString failInfo = statusInfo.getFailInfo();
            if (failInfo == null) {
                throw new TSAException(TSAErrorCode.timestampTSASignedDataMissingFailInfo, "requred failInfo");
            }
            byte[] failBytes = failInfo.getBytes();
            if (this.isFailInfoValid(failBytes)) {
                String failText = failBytes == null || failBytes.length == 0 ? "" : "0x" + TscStrings.toHexString(failBytes);
                throw new TSAException(TSAErrorCode.timestampTSASignedDataInvalidFailInfo, "invalid failInfo=0x" + failText);
            }
            int failure = failInfo.intValue();
            PKIFailureInfo failureInfo = PKIFailureInfo.find(failure);
            if (failureInfo == null) {
                StringBuilder builder = new StringBuilder();
                builder.append("failure=0x" + Integer.toHexString(failure));
                builder.append(",data=0x" + TscStrings.toHexString(failBytes));
                String failText = builder.toString();
                throw new TSAException(TSAErrorCode.timestampTSASignedDataInvalidFailInfo, "These are the only values of PKIFailureInfo that SHALL be supported, " + failText);
            }
            try {
                PKIFreeText statusText = statusInfo.getStatusString();
                if (statusText != null) {
                    freeText = new String[statusText.size()];
                    for (int i = 0; i < freeText.length; ++i) {
                        freeText[i] = statusText.getStringAt(i).getString();
                    }
                } else {
                    freeText = null;
                }
            }
            catch (Exception e) {
                throw new TSAException(TSAErrorCode.timestampTSASignedDataPKIFreeTextFailure, "PKIFreeText fetch failure", (Throwable)e);
            }
            failCode = failureInfo.value;
        }
        return new PKIStatusInfo(status.no, freeText, failCode);
    }

    private boolean isFailInfoValid(byte[] failBytes) {
        return failBytes == null || failBytes.length == 0 || failBytes.length > 4;
    }

    private final TSTInfo buildTSTInfoFrom(TimeStampToken timeStampToken) throws TSAException {
        int version;
        String tsaName;
        BigInteger serialNumber;
        String policyId;
        BigInteger nonce;
        byte[] extensions;
        TSTAccuracy accuracy;
        Args.notNull((Object)timeStampToken, (String)"timeStampToken");
        TimeStampTokenInfo tokenInfo = timeStampToken.getTimeStampInfo();
        if (tokenInfo.getMessageImprintAlgOID() == null) {
            throw new TSAException(TSAErrorCode.timeStampTokenInfoMissingHashAlgorithm, "required hashAlgorithmOID");
        }
        HashAlgorithm hashAlgorithm = HashAlgorithm.findHashAlgorithm(tokenInfo.getMessageImprintAlgOID().getId());
        if (hashAlgorithm == null) {
            throw new TSAException(TSAErrorCode.timeStampTokenInfoInvalidHashAlgorithm, tokenInfo.getMessageImprintAlgOID().getId());
        }
        if (tokenInfo.getMessageImprintDigest() == null) {
            throw new TSAException(TSAErrorCode.timeStampTokenInfoMissingHashedMessage, "required hashedMessage");
        }
        if (tokenInfo.getMessageImprintDigest().length != hashAlgorithm.hashLength) {
            throw new TSAException(TSAErrorCode.timeStampTokenInfoInvalidHashedMessage, "required hashedMessage length=" + hashAlgorithm.hashLength);
        }
        MessageImprint messageImprint = new MessageImprint(hashAlgorithm, tokenInfo.getMessageImprintDigest());
        if (tokenInfo.getAccuracy() == null) {
            accuracy = null;
        } else {
            try {
                ASN1Integer asn1Seconds = tokenInfo.getAccuracy().getSeconds();
                ASN1Integer asn1Milliseconds = tokenInfo.getAccuracy().getMillis();
                ASN1Integer asn1Microseconds = tokenInfo.getAccuracy().getMicros();
                int seconds = asn1Seconds == null ? 0 : asn1Seconds.getValue().intValue();
                int milliseconds = asn1Milliseconds == null ? 0 : asn1Milliseconds.getValue().intValue();
                int microseconds = asn1Microseconds == null ? 0 : asn1Microseconds.getValue().intValue();
                accuracy = new TSTAccuracy(seconds, milliseconds, microseconds);
            }
            catch (Exception e) {
                throw new TSAException(TSAErrorCode.timeStampTokenInfoAccuracyFetchFailure, "accuracy fetch failure", (Throwable)e);
            }
        }
        try {
            extensions = tokenInfo.toASN1Structure().getExtensions() == null ? null : tokenInfo.toASN1Structure().getExtensions().getEncoded();
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timeStampTokenInfoExtensionsFetchFailure, "extensions fetch failure", (Throwable)e);
        }
        Date genTime = tokenInfo.getGenTime();
        try {
            nonce = tokenInfo.getNonce() == null ? null : tokenInfo.getNonce();
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timeStampTokenInfoNonceFetchFailure, "nonce fetch failure", (Throwable)e);
        }
        boolean ordering = tokenInfo.isOrdered();
        try {
            policyId = tokenInfo.getPolicy() == null ? null : tokenInfo.getPolicy().getId();
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timeStampTokenInfoPolicyFetchFailure, "policy fetch failure", (Throwable)e);
        }
        try {
            serialNumber = tokenInfo.getSerialNumber();
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timeStampTokenInfoPolicyFetchFailure, "serialNumber fetch failure", (Throwable)e);
        }
        try {
            tsaName = tokenInfo.getTsa() == null ? null : tokenInfo.getTsa().toString();
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timeStampTokenInfoTsaNameFetchFailure, "tsaName fetch failure", (Throwable)e);
        }
        try {
            version = tokenInfo.toASN1Structure().getVersion().getValue().intValue();
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timeStampTokenInfoVersionFetchFailure, "version fetch failure", (Throwable)e);
        }
        TSTInfo tstInfo = new TSTInfo(version, policyId, messageImprint, serialNumber, genTime, accuracy, ordering, nonce, tsaName, extensions);
        return tstInfo;
    }

    private final TSACertHolder fetchSignedCertFrom(TimeStampToken timeStampToken, boolean requiredCertOptional) throws TSAException {
        Collection collection;
        Args.notNull((Object)timeStampToken, (String)"timeStampToken");
        try {
            SignerId selector = timeStampToken.getSID();
            Store store = timeStampToken.getCertificates();
            collection = store.getMatches((Selector)selector);
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timeStampTokenSignedCertFetchFailure, "signedCert fetch failure: " + e.getMessage(), (Throwable)e);
        }
        if (collection.size() > 1) {
            throw new TSAException(TSAErrorCode.timeStampTokenSignedCertMoreThanOne, "signedCert more than one");
        }
        Iterator iterator = collection.iterator();
        TSACertHolder cert = null;
        while (iterator.hasNext()) {
            try {
                cert = TSACertHolder.from((X509CertificateHolder)iterator.next());
            }
            catch (Exception e) {
                throw new TSAException(TSAErrorCode.timeStampTokenSignedCertFetchFailure, "signedCert fetch failure: " + e.getMessage(), (Throwable)e);
            }
        }
        if (requiredCertOptional && cert == null && this.holder == null) {
            throw new TSAException(TSAErrorCode.timeStampTokenSignedCertMissing, "signedCert missing");
        }
        if (cert == null && this.holder != null) {
            cert = this.holder;
        }
        return cert;
    }

    final X509Cert buildSignedCertFrom(X509CertificateHolder holder) throws TSAException {
        X509Cert signedCert;
        byte[] certBytes;
        if (holder == null) {
            throw new TSAException(TSAErrorCode.timeStampTokenSignedCertMissing, "signedCert missing");
        }
        try {
            certBytes = holder.getEncoded();
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timeStampTokenSignedCertFetchCertBytesFailure, "signedCert fetch certBytes: " + e.getMessage(), (Throwable)e);
        }
        try {
            signedCert = new X509Cert(certBytes);
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timeStampTokenSignedCertConvertToX509CertFailure, "signedCert convert to X509Cert failure: " + e.getMessage(), (Throwable)e);
        }
        return signedCert;
    }

    private final Date buildSignedTimeFrom(TimeStampToken timeStampToken) throws TSAException {
        Args.notNull((Object)timeStampToken, (String)"timeStampToken");
        AttributeTable signedAttributes = timeStampToken.getSignedAttributes();
        if (signedAttributes == null) {
            throw new TSAException(TSAErrorCode.timeStampTokenSignedTimeMissing, "required signedAttributes");
        }
        Attribute signedTimeAttribute = signedAttributes.get(PKCSObjectIdentifiers.pkcs_9_at_signingTime);
        if (signedTimeAttribute == null) {
            throw new TSAException(TSAErrorCode.timeStampTokenSignedTimeMissing, "required signing-time attribute value");
        }
        ASN1Set attrValues = signedTimeAttribute.getAttrValues();
        if (attrValues == null) {
            throw new TSAException(TSAErrorCode.timeStampTokenSignedTimeMissing, "required vaild signing-time attribute value");
        }
        if (attrValues.size() != 1) {
            throw new TSAException(TSAErrorCode.timeStampTokenSignedTimeRequiredSingle, "required vaild signing-time attribute value");
        }
        Date signedTime = null;
        try {
            ASN1Encodable validSigningTime = attrValues.getObjectAt(0);
            signedTime = Time.getInstance((Object)validSigningTime).getDate();
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timeStampTokenSignedTimeInvalidStructure, "signing-time attribute value not a valid 'Time' structure");
        }
        return signedTime;
    }

    final boolean verifySignedData(BusinessTrustCerts trustCerts) throws TSAException {
        return this.verifySignedData(trustCerts, DefaultSessionLib.SESSION);
    }

    final boolean verifySignedData(BusinessTrustCerts trustCerts, Session session) throws TSAException {
        boolean verifiedResult = false;
        TSACertHolder signHolder = null;
        if (this.holder != null || this.signCert != null) {
            try {
                signHolder = this.requiredCertOptional ? TSACertHolder.from(this.holder) : (this.signCert != null ? TSACertHolder.from(this.signCert) : TSACertHolder.from(this.holder));
                SignerInformationVerifier sigVerifier = TSASignerInformationVerifier.buildSignerInformationVerifier(signHolder, session);
                this.timeStampToken.validate(sigVerifier);
                verifiedResult = true;
            }
            catch (TSPValidationException e) {
                throw new TSAException(TSAErrorCode.timeStampTokenSignedDataInvalidSignature, "invalid signature@TSPValidationException: " + e.getMessage(), (Throwable)e);
            }
            catch (TSPException e) {
                throw new TSAException(TSAErrorCode.timeStampTokenSignedDataInvalidSignature, "invalid signature@TSPException: " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw new TSAException(TSAErrorCode.timeStampTokenSignedDataInvalidSignature, "invalid signature@Exception: " + e.getMessage(), (Throwable)e);
            }
        }
        if (verifiedResult && trustCerts != null && signHolder != null) {
            X509Cert signerCert = signHolder.getX509Cert();
            if (!trustCerts.verifyCertSignature(signerCert)) {
                throw new TSAException(TSAErrorCode.timeStampTokenSignedCertInvalidSignature, "invalid signature: ");
            }
            if (!trustCerts.verifyCertValidate(signerCert, true)) {
                throw new TSAException(TSAErrorCode.timeStampTokenSignedCertInvalidValidate, "invalid signature: ");
            }
            if (trustCerts.isRevoke(signerCert)) {
                throw new TSAException(TSAErrorCode.timeStampTokenSignedCertIsRevoked, "invalid signature: ");
            }
        }
        return verifiedResult;
    }

    final byte[] getSourceData() throws TSAException {
        byte[] sourceData = null;
        if (this.timeStampToken != null && this.timeStampToken.getTimeStampInfo() != null) {
            try {
                sourceData = this.timeStampToken.getTimeStampInfo().getEncoded();
            }
            catch (IOException e) {
                throw new TSAException(TSAErrorCode.timeStampTokenSourceDataFetchFailure, e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw new TSAException(TSAErrorCode.timeStampTokenSourceDataFetchFailure, e.getMessage(), (Throwable)e);
            }
        }
        return sourceData;
    }

    final X509Cert getSignedCert() {
        X509Cert signedCert = null;
        if (this.timestamp != null && this.timestamp.getTimestampCert() != null) {
            signedCert = this.timestamp.getTimestampCert();
        }
        return signedCert;
    }

    final MessageImprint getMessageImprint() {
        MessageImprint messageImprint = null;
        if (this.timestamp != null) {
            messageImprint = this.timestamp.getMessageImprint();
        }
        return messageImprint;
    }

    final BigInteger getNonce() {
        BigInteger nonce = null;
        if (this.timestamp != null && this.timestamp.getTstInfo() != null) {
            nonce = this.timestamp.getTstInfo().getNonce();
        }
        return nonce;
    }

    final String getPolicyID() {
        String policyId = null;
        if (this.timestamp != null && this.timestamp.getTstInfo() != null) {
            policyId = this.timestamp.getTstInfo().getPolicyId();
        }
        return policyId;
    }

    final Date getGenTime() {
        Date genTime = null;
        if (this.timeStampToken != null && this.timeStampToken.getTimeStampInfo() != null) {
            genTime = this.timeStampToken.getTimeStampInfo().getGenTime();
        }
        return genTime;
    }

    final Timestamp getTimeStamp() {
        return this.timestamp;
    }
}

