/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.validator;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.tls.java.security.CFCAAlgorithmConstraints;
import cfca.sadk.tls.sun.security.provider.certpath.CFCAAlgorithmChecker;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.sec.JSSEJCE;
import cfca.sadk.tls.sun.security.validator.TLSValidator;
import cfca.sadk.tls.sun.security.validator.TLSValidatorException;
import cfca.sadk.tls.sun.security.validator.TLSValidatorVariant;
import cfca.sadk.tls.sun.security.validator.TrustAnchorHelper;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.action.GetBooleanAction;

public final class TLSPKIXValidator
extends TLSValidator {
    private static final Logger logger = LoggerFactory.getLogger(TLSPKIXValidator.class);
    private static final boolean checkTLSRevocation = AccessController.doPrivileged(new GetBooleanAction("com.sun.net.ssl.checkRevocation"));
    private final Set<X509Certificate> trustedCerts;
    private final PKIXBuilderParameters parameterTemplate;
    private int certPathLength = -1;
    private PluginValidator plugin;

    TLSPKIXValidator(TLSValidatorVariant variant, Collection<X509Certificate> trustedCerts) {
        super(variant);
        this.trustedCerts = this.buildTrustedCerts(trustedCerts);
        this.parameterTemplate = this.buildBuilderParameters(trustedCerts);
        this.setDefaultParameters(variant);
        this.plugin = this.initialValidator();
    }

    TLSPKIXValidator(TLSValidatorVariant variant, PKIXBuilderParameters params) {
        super(variant);
        this.trustedCerts = this.buildTrustedCerts(params);
        this.parameterTemplate = params;
        this.plugin = this.initialValidator();
    }

    private final PluginValidator initialValidator() {
        PluginValidator plugin = new PluginValidator();
        plugin.trustedSubjects = this.buildTrustedSubjects(this.trustedCerts);
        plugin.factory = this.buildCertificateFactory();
        return plugin;
    }

    @Override
    public final Collection<X509Certificate> getTrustedCertificates() {
        return this.trustedCerts;
    }

    public final int getCertPathLength() {
        return this.certPathLength;
    }

    private final void setDefaultParameters(TLSValidatorVariant variant) {
        if (variant == TLSValidatorVariant.TLS_SERVER || variant == TLSValidatorVariant.TLS_CLIENT) {
            this.parameterTemplate.setRevocationEnabled(checkTLSRevocation);
        } else {
            this.parameterTemplate.setRevocationEnabled(false);
        }
    }

    public final PKIXBuilderParameters getParameters() {
        return this.parameterTemplate;
    }

    @Override
    X509Certificate[] engineValidate(X509Certificate[] chain, Collection<X509Certificate> otherCerts, CFCAAlgorithmConstraints constraints, Object parameter) throws CertificateException {
        X509Certificate[] trustedCerts;
        if (logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("engineValidate<<<<<<Running");
            buffer.append("\n cert: ");
            buffer.append(Debugger.dump(chain));
            logger.info(buffer.toString());
        }
        if (chain == null || chain.length == 0) {
            throw new CertificateException("null or zero-length certificate chain");
        }
        if (this.parameterTemplate == null) {
            throw new CertificateException("null builder parameters");
        }
        if (this.plugin == null || this.plugin.trustedSubjects == null || this.plugin.factory == null) {
            throw new CertificateException("plugin is null or the param of plugin missing");
        }
        PKIXBuilderParameters pkixParameters = (PKIXBuilderParameters)this.parameterTemplate.clone();
        if (constraints != null) {
            pkixParameters.addCertPathChecker(new CFCAAlgorithmChecker(constraints));
        }
        if ((trustedCerts = this.checkOrder(chain, otherCerts, pkixParameters)) != null) {
            return trustedCerts;
        }
        X509Certificate last = chain[chain.length - 1];
        X500Principal issuer = last.getIssuerX500Principal();
        if (this.plugin.trustedSubjects.containsKey(issuer)) {
            return this.doValidate(chain, pkixParameters, this.plugin.factory);
        }
        return this.doBuild(chain, otherCerts, pkixParameters);
    }

    private X509Certificate[] checkOrder(X509Certificate[] chain, Collection<X509Certificate> otherCerts, PKIXBuilderParameters pkixParameters) throws CertificateException {
        X500Principal prevIssuer = null;
        X509Certificate cert = null;
        X500Principal dn = null;
        for (int i = 0; i < chain.length; ++i) {
            cert = chain[i];
            if (cert == null) continue;
            dn = cert.getSubjectX500Principal();
            if (i != 0 && !dn.equals(prevIssuer)) {
                return this.doBuild(chain, otherCerts, pkixParameters);
            }
            if (this.trustedCerts.contains(cert) || this.plugin.trustedSubjects.containsKey(dn) && this.plugin.trustedSubjects.get(dn).contains(cert.getPublicKey())) {
                if (i == 0) {
                    return new X509Certificate[]{chain[0]};
                }
                X509Certificate[] newChain = new X509Certificate[i];
                System.arraycopy(chain, 0, newChain, 0, i);
                return this.doValidate(newChain, pkixParameters, this.plugin.factory);
            }
            prevIssuer = cert.getIssuerX500Principal();
        }
        return null;
    }

    private final Set<X509Certificate> buildTrustedCerts(Collection<X509Certificate> paramTrustedCerts) {
        HashSet<X509Certificate> localTrustedCerts = null;
        localTrustedCerts = paramTrustedCerts == null ? Collections.emptySet() : (paramTrustedCerts instanceof Set ? (HashSet<X509Certificate>)paramTrustedCerts : new HashSet<X509Certificate>(paramTrustedCerts));
        return localTrustedCerts;
    }

    private final Set<X509Certificate> buildTrustedCerts(PKIXBuilderParameters params) {
        Set<X509Certificate> localTrustedCerts = null;
        if (params == null) {
            localTrustedCerts = Collections.emptySet();
        } else {
            localTrustedCerts = new HashSet();
            for (TrustAnchor anchor : params.getTrustAnchors()) {
                X509Certificate cert;
                if (anchor == null || (cert = anchor.getTrustedCert()) == null) continue;
                localTrustedCerts.add(cert);
            }
        }
        return localTrustedCerts;
    }

    private final PKIXBuilderParameters buildBuilderParameters(Collection<X509Certificate> trustedCerts) {
        Set<TrustAnchor> localTrustedAnchors = null;
        if (trustedCerts == null) {
            localTrustedAnchors = Collections.emptySet();
        } else {
            localTrustedAnchors = new HashSet();
            for (X509Certificate cert : trustedCerts) {
                if (cert == null) continue;
                localTrustedAnchors.add(new TrustAnchor(cert, null));
            }
        }
        PKIXBuilderParameters parameters = null;
        try {
            parameters = new PKIXBuilderParameters(localTrustedAnchors, null);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("Unexpected error: " + e.toString(), e);
        }
        return parameters;
    }

    private final CertificateFactory buildCertificateFactory() {
        try {
            return JSSEJCE.getCertificateFactory("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Internal error", e);
        }
    }

    private final Map<X500Principal, List<PublicKey>> buildTrustedSubjects(Collection<X509Certificate> trustedCerts) {
        Map<X500Principal, List<PublicKey>> returnTrustedSubjects = null;
        if (trustedCerts == null) {
            returnTrustedSubjects = Collections.emptyMap();
        } else {
            returnTrustedSubjects = new HashMap();
            List<Object> keys = null;
            X500Principal dn = null;
            for (X509Certificate cert : trustedCerts) {
                if (cert == null) continue;
                dn = cert.getSubjectX500Principal();
                if (returnTrustedSubjects.containsKey(dn)) {
                    keys = returnTrustedSubjects.get(dn);
                } else {
                    keys = new ArrayList();
                    returnTrustedSubjects.put(dn, keys);
                }
                keys.add(cert.getPublicKey());
            }
        }
        return returnTrustedSubjects;
    }

    private final X509Certificate[] doValidate(X509Certificate[] chain, PKIXBuilderParameters params, CertificateFactory factory) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new TLSValidatorException("PKIX path building failed: null or zero-length certificate chain");
        }
        if (factory == null) {
            throw new TLSValidatorException("PKIX path building failed: null certificate factory");
        }
        try {
            params.setDate(new Date());
            CertPath path = factory.generateCertPath(Arrays.asList(chain));
            this.certPathLength = chain.length;
            List<? extends Certificate> certs = path.getCertificates();
            TrustAnchor trustAnchors = TrustAnchorHelper.findTrustAnchor((X509Certificate)certs.get(certs.size() - 1), params.getTrustAnchors());
            return TrustAnchorHelper.toArray(path, trustAnchors);
        }
        catch (Exception e) {
            throw new TLSValidatorException("PKIX path validation failed: " + e.toString(), e);
        }
    }

    private final X509Certificate[] doBuild(X509Certificate[] chain, Collection<X509Certificate> otherCerts, PKIXBuilderParameters params) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new TLSValidatorException("PKIX path building failed: null or zero-length certificate chain");
        }
        try {
            params.setDate(new Date());
            X509CertSelector selector = new X509CertSelector();
            selector.setCertificate(chain[0]);
            params.setTargetCertConstraints(selector);
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            certs.addAll(Arrays.asList(chain));
            if (otherCerts != null) {
                certs.addAll(otherCerts);
            }
            CertStore store = JSSEJCE.getCertStore("Collection", new CollectionCertStoreParameters(certs));
            params.addCertStore(store);
            X509Certificate peerCert = (X509Certificate)certs.toArray()[0];
            TrustAnchor trustAnchors = TrustAnchorHelper.findTrustAnchor(peerCert, params.getTrustAnchors());
            if (trustAnchors == null) {
                throw new TLSValidatorException("findTrustAnchor failed: TrustAnchor is null! IssuerDN= " + peerCert.getIssuerDN());
            }
            return TrustAnchorHelper.toArray(chain, trustAnchors);
        }
        catch (Exception e) {
            throw new TLSValidatorException("PKIX path building failed: " + e.toString(), e);
        }
    }

    static final class PluginValidator {
        Map<X500Principal, List<PublicKey>> trustedSubjects;
        CertificateFactory factory;

        PluginValidator() {
        }
    }
}

