/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.message;

import cfca.sadk.tls.sun.security.ssl.CipherSuiteList;
import cfca.sadk.tls.sun.security.ssl.CompressionMethods;
import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.HandshakeOutStream;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.RandomCookie;
import cfca.sadk.tls.sun.security.ssl.SessionId;
import cfca.sadk.tls.sun.security.ssl.extension.HelloExtension;
import cfca.sadk.tls.sun.security.ssl.extension.HelloExtensions;
import cfca.sadk.tls.sun.security.ssl.message.HandshakeMessage;
import java.io.IOException;
import java.util.Random;

public final class ClientHello
extends HandshakeMessage {
    private final ProtocolVersion clientVersion;
    private final RandomCookie clientRandom;
    private final SessionId sessionId;
    private final CipherSuiteList cipherSuites;
    private final CompressionMethods compressionMethods;
    public HelloExtensions extensions = new HelloExtensions();

    public ClientHello(ProtocolVersion clientVersion, Random random, SessionId sessionId, CipherSuiteList cipherSuites) {
        this.clientVersion = clientVersion;
        this.clientRandom = new RandomCookie(random);
        this.sessionId = sessionId;
        this.cipherSuites = cipherSuites;
        this.compressionMethods = CompressionMethods.NULL_COMPRESSION;
    }

    public ClientHello(HandshakeInStream in, int messageLength) throws IOException {
        this.clientVersion = ProtocolVersion.decodedFrom(in);
        this.clientRandom = new RandomCookie(in);
        this.sessionId = new SessionId(in);
        this.cipherSuites = new CipherSuiteList(in);
        this.compressionMethods = new CompressionMethods(in);
        if (this.messageLength() != messageLength) {
            this.extensions = new HelloExtensions();
            this.extensions.decodedFrom(in);
        }
    }

    public final ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    public final RandomCookie getClientRandom() {
        return this.clientRandom;
    }

    public final SessionId getSessionId() {
        return this.sessionId;
    }

    public final CipherSuiteList getCipherSuites() {
        return this.cipherSuites;
    }

    public final void addExtension(HelloExtension extension) {
        this.extensions.add(extension);
    }

    @Override
    public final int messageType() {
        return 1;
    }

    @Override
    final int messageLength() {
        return 38 + this.sessionId.length() + this.cipherSuites.size() * 2 + this.compressionMethods.value.length + this.extensions.length();
    }

    @Override
    final void send(HandshakeOutStream out) throws IOException {
        out.putOpaque(this.clientVersion);
        out.putOpaque(this.clientRandom);
        out.putOpaque(this.sessionId);
        out.putOpaque(this.cipherSuites);
        out.putOpaque(this.compressionMethods);
        out.putOpaque(this.extensions);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('\n');
        builder.append("*** ClientHello, ");
        builder.append(this.clientVersion);
        builder.append("\nRandomCookie:  ");
        builder.append(this.clientRandom);
        builder.append("\nSession ID:  ");
        builder.append(this.sessionId);
        builder.append("\nCipher Suites: ");
        builder.append(this.cipherSuites);
        builder.append("\nCompression Methods: ");
        builder.append(this.compressionMethods);
        builder.append(this.extensions);
        builder.append("\n***");
        return builder.toString();
    }
}

