/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.testutils;

import cfca.com.itextpdf.text.log.Logger;
import cfca.com.itextpdf.text.log.LoggerFactory;
import java.io.File;
import javax.management.OperationsException;

public abstract class ITextTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ITextTest.class.getName());

    public void runTest() throws Exception {
        LOGGER.info("Starting test.");
        String outPdf = this.getOutPdf();
        if (outPdf == null || outPdf.length() == 0) {
            throw new OperationsException("outPdf cannot be empty!");
        }
        this.makePdf(outPdf);
        this.assertPdf(outPdf);
        this.comparePdf(outPdf, this.getCmpPdf());
        LOGGER.info("Test complete.");
    }

    protected abstract void makePdf(String var1) throws Exception;

    protected abstract String getOutPdf();

    protected void assertPdf(String outPdf) throws Exception {
    }

    protected void comparePdf(String outPdf, String cmpPdf) throws Exception {
    }

    protected String getCmpPdf() {
        return "";
    }

    protected void deleteDirectory(File path) {
        if (path == null) {
            return;
        }
        if (path.exists()) {
            for (File f : path.listFiles()) {
                if (f.isDirectory()) {
                    this.deleteDirectory(f);
                    f.delete();
                    continue;
                }
                f.delete();
            }
            path.delete();
        }
    }

    protected void deleteFiles(File path) {
        if (path != null && path.exists()) {
            for (File f : path.listFiles()) {
                f.delete();
            }
        }
    }
}

