/*
 * Decompiled with CFR 0.152.
 */
package io.github.autoffice.luckysheet.util;

import io.github.autoffice.luckysheet.model.image.SheetImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImageUtil.class);

    public static String toLuckySheetImage(byte[] data) {
        byte[] png = ImageUtil.toPng(data);
        if (png == null) {
            return null;
        }
        String base64 = Base64.getEncoder().encodeToString(data);
        return "data:image/png;base64," + base64;
    }

    private static byte[] toPng(byte[] data) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
        try {
            BufferedImage image = ImageIO.read(byteArrayInputStream);
            if (image == null) {
                throw new IOException("\u56fe\u7247\u89e3\u6790\u4e3anull");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "PNG", byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            log.error("\u56fe\u7247\u8f6cpng\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static byte[] getImageData(SheetImage image) {
        if (ImageUtil.isBase64Imgae(image)) {
            String[] split = image.getSrc().split(",");
            return Base64.getDecoder().decode(split[1]);
        }
        return null;
    }

    private static boolean isBase64Imgae(SheetImage image) {
        return StringUtils.contains((CharSequence)image.getSrc(), (CharSequence)"base64,");
    }

    public static String getLuckySheetImageId() {
        String time = String.valueOf(System.currentTimeMillis());
        String random = RandomStringUtils.randomAlphabetic((int)4);
        String substring = time.substring(time.length() - 8);
        return "img_" + substring + random + "_" + time;
    }

    @Generated
    private ImageUtil() {
    }
}

