/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.io.source.ByteArrayOutputStream;
import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.geom.AffineTransform;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;

public class PDFRatationUtil {
    private static Logger businessLog = LoggerFactory.getLogger(PDFRatationUtil.class);

    public static byte[] textArrayRotation(PdfCanvas canvas, String text, PdfFont font, float fontSize, float rotation, float mx, float my, float scx, float scy) throws Exception {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            float angle = (float)((double)(rotation / 180.0f) * Math.PI);
            canvas.saveState();
            canvas.beginText();
            if (angle != 0.0f) {
                canvas.concatMatrix(AffineTransform.getTranslateInstance((double)mx, (double)my));
                canvas.concatMatrix(AffineTransform.getRotateInstance((double)angle));
            } else {
                canvas.moveText((double)mx, (double)my);
            }
            canvas.setFontAndSize(font, fontSize).showText(text);
            if (angle != 0.0f) {
                canvas.concatMatrix(AffineTransform.getRotateInstance((double)(-angle)));
            }
            canvas.endText();
            canvas.restoreState();
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            businessLog.error("textArrayRotation failed", (Throwable)e);
            throw e;
        }
        finally {
            byteStream.close();
            byteStream = null;
        }
    }
}

