/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ImageUtil {
    public static boolean isPng(InputStream is) {
        try {
            byte[] pngData = new byte[4];
            is.read(pngData);
            if (pngData[1] == 80 && pngData[2] == 78 && pngData[3] == 71) {
                return true;
            }
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isPng(byte[] pngData) {
        return pngData[1] == 80 && pngData[2] == 78 && pngData[3] == 71;
    }

    public static void converterImage(File imgFile, String format, File formatFile) throws IOException {
        BufferedImage bIMG = ImageIO.read(imgFile);
        ImageIO.write((RenderedImage)bIMG, format, formatFile);
    }

    public static void createSealImage(String drawStr, int width, int height, Integer fontHeight, String sealImagePath) throws IOException {
        if (fontHeight == null) {
            fontHeight = 10;
        }
        BufferedImage buffImg = new BufferedImage(width, height, 1);
        Graphics2D gd = buffImg.createGraphics();
        buffImg = gd.getDeviceConfiguration().createCompatibleImage(width, height, 3);
        gd = buffImg.createGraphics();
        FontRenderContext context = gd.getFontRenderContext();
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, fontHeight);
        Rectangle2D bounds = font.getStringBounds(drawStr, context);
        double y = ((double)height - bounds.getHeight()) / 2.0;
        double ascent = -bounds.getY();
        double baseY = y + ascent;
        gd.setFont(font);
        gd.setColor(Color.RED);
        gd.drawRect(0, 0, width - 1, height - 1);
        gd.drawString(drawStr, width / 2 - fontHeight * drawStr.length() / 2, (int)baseY);
        ImageIO.write((RenderedImage)buffImg, "png", new File(sealImagePath));
    }

    public static byte[] transferAlpha(Image image) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIcon imageIcon = new ImageIcon(image);
        BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 6);
        Graphics2D g2D = (Graphics2D)bufferedImage.getGraphics();
        g2D.drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
        int alpha = 0;
        for (int j1 = bufferedImage.getMinY(); j1 < bufferedImage.getHeight(); ++j1) {
            for (int j2 = bufferedImage.getMinX(); j2 < bufferedImage.getWidth(); ++j2) {
                int rgb = bufferedImage.getRGB(j2, j1);
                int R = (rgb & 0xFF0000) >> 16;
                int G = (rgb & 0xFF00) >> 8;
                int B = rgb & 0xFF;
                if (255 - R < 30 && 255 - G < 30 && 255 - B < 30) {
                    rgb = alpha + 1 << 24 | rgb & 0xFFFFFF;
                }
                bufferedImage.setRGB(j2, j1, rgb);
            }
        }
        g2D.drawImage((Image)bufferedImage, 0, 0, imageIcon.getImageObserver());
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] transferAlpha(byte[] imageByte) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIcon imageIcon = new ImageIcon(imageByte);
        BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 6);
        Graphics2D g2D = (Graphics2D)bufferedImage.getGraphics();
        g2D.drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
        int alpha = 0;
        for (int j1 = bufferedImage.getMinY(); j1 < bufferedImage.getHeight(); ++j1) {
            for (int j2 = bufferedImage.getMinX(); j2 < bufferedImage.getWidth(); ++j2) {
                int rgb = bufferedImage.getRGB(j2, j1);
                int R = (rgb & 0xFF0000) >> 16;
                int G = (rgb & 0xFF00) >> 8;
                int B = rgb & 0xFF;
                if (255 - R < 30 && 255 - G < 30 && 255 - B < 30) {
                    rgb = alpha + 1 << 24 | rgb & 0xFFFFFF;
                }
                bufferedImage.setRGB(j2, j1, rgb);
            }
        }
        g2D.drawImage((Image)bufferedImage, 0, 0, imageIcon.getImageObserver());
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] resizeImage(byte[] imageByte, int width, int height) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(imageByte);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedImage srcImg = ImageIO.read(bais);
        BufferedImage buffImg = null;
        buffImg = new BufferedImage(width, height, 6);
        buffImg.getGraphics().drawImage(srcImg.getScaledInstance(width, height, 4), 0, 0, null);
        ImageIO.write((RenderedImage)buffImg, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] resizeImageOptimized(byte[] imageByte, int width, int height) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(imageByte);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedImage bufferedImage = ImageIO.read(bais);
        int w = bufferedImage.getWidth();
        int h = bufferedImage.getHeight();
        double scaleW = (double)width / (double)w;
        double scaleH = (double)height / (double)h;
        if (scaleW > scaleH) {
            height = (int)((double)h * scaleW);
        } else {
            width = (int)((double)w * scaleH);
        }
        BufferedImage buffImg = null;
        buffImg = new BufferedImage(width, height, 6);
        buffImg.getGraphics().drawImage(bufferedImage.getScaledInstance(width, height, 4), 0, 0, null);
        ImageIO.write((RenderedImage)buffImg, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

