/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.paperless.base.BaseConstants;
import java.util.Locale;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

public class MessageSourceUtil {
    private static ReloadableResourceBundleMessageSource messageSource;

    public static void init(String[] baseNames, int cacheSeconds) {
        messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasenames(baseNames);
        messageSource.setDefaultEncoding("UTF-8");
        messageSource.setUseCodeAsDefaultMessage(true);
        messageSource.setFallbackToSystemLocale(false);
        messageSource.setCacheSeconds(cacheSeconds);
    }

    public static String getMessage(String code) {
        try {
            return messageSource.getMessage(code, null, BaseConstants.DEFAULT_LOCALE);
        }
        catch (Exception ignore) {
            return code;
        }
    }

    public static String getMessage(String code, Object[] args) {
        try {
            return messageSource.getMessage(code, args, BaseConstants.DEFAULT_LOCALE);
        }
        catch (Exception ignore) {
            return code;
        }
    }

    public static String getMessage(String code, Locale locale) {
        try {
            return messageSource.getMessage(code, null, locale);
        }
        catch (Exception ignore) {
            return code;
        }
    }

    public static String getMessage(String code, Object[] args, Locale locale) {
        try {
            return messageSource.getMessage(code, args, locale);
        }
        catch (Exception ignore) {
            return code;
        }
    }
}

