/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.util;

import cfca.sadk.tls.java.security.CFCAAlgorithmConstraints;
import cfca.sadk.tls.javax.net.ssl.CFCAExtendedSSLSession;
import cfca.sadk.tls.javax.net.ssl.CFCASNIHostName;
import cfca.sadk.tls.javax.net.ssl.CFCASNIServerName;
import cfca.sadk.tls.javax.net.ssl.CFCASSLEngine;
import cfca.sadk.tls.javax.net.ssl.CFCASSLSocket;
import cfca.sadk.tls.javax.net.ssl.CFCASSLTransfer;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.validator.TLSValidator;
import cfca.sadk.tls.util.TLSDeviceConf;
import cfca.sadk.tls.util.TLSLoggings;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import sun.security.util.HostnameChecker;

public final class CFCASSLHelper {
    public static final String noAlternativeName = "No subject alternative names present";
    private static boolean checkUrlMatchCertIdentity = TLSDeviceConf.checkIdentity;

    private CFCASSLHelper() {
    }

    public static void setCheckUrlMatchCertIdentity(boolean checkUrlMatchCertIdentity) {
        TLSLoggings.ENVIRONMENT_LOGGER.info("checkUrlMatchCertIdentity: {}", (Object)checkUrlMatchCertIdentity);
        CFCASSLHelper.checkUrlMatchCertIdentity = checkUrlMatchCertIdentity;
    }

    public static boolean isCheckUrlMatchCertIdentity() {
        return checkUrlMatchCertIdentity;
    }

    public static final X509Certificate[] validate(TLSValidator validator, X509Certificate[] chain, CFCAAlgorithmConstraints constraints, String authType, boolean isClient) throws CertificateException {
        X509Certificate[] trustedChain = null;
        trustedChain = isClient ? CFCASSLHelper.validate(validator, chain, constraints, null) : CFCASSLHelper.validate(validator, chain, constraints, authType);
        return trustedChain;
    }

    private static final X509Certificate[] validate(TLSValidator validator, X509Certificate[] chain, CFCAAlgorithmConstraints constraints, String authType) throws CertificateException {
        return validator.validate(chain, null, constraints, authType);
    }

    public static final List<CFCASNIServerName> getRequestedServerNames(Socket socket) {
        CFCASSLSocket transfer = null;
        if (socket != null && socket.isConnected() && socket instanceof CFCASSLSocket) {
            transfer = (CFCASSLSocket)socket;
        }
        return CFCASSLHelper.getRequestedServerNames(transfer);
    }

    public static final List<CFCASNIServerName> getRequestedServerNames(SSLEngine engine) {
        CFCASSLTransfer transfer = null;
        if (engine != null && engine instanceof CFCASSLEngine) {
            transfer = (CFCASSLTransfer)((Object)engine);
        }
        return CFCASSLHelper.getRequestedServerNames(transfer);
    }

    public static final List<CFCASNIServerName> getRequestedServerNames(CFCASSLTransfer transfer) {
        List<CFCASNIServerName> sniList = null;
        if (transfer != null) {
            SSLSession session = transfer.getHandshakeSession();
            if (session != null && session instanceof CFCAExtendedSSLSession) {
                CFCAExtendedSSLSession extSession = (CFCAExtendedSSLSession)session;
                sniList = extSession.getRequestedServerNames();
            }
        } else {
            sniList = Collections.emptyList();
        }
        return sniList;
    }

    public static final void checkIdentity(SSLSession session, X509Certificate cert, String protocol, boolean isClient, List<CFCASNIServerName> sniNames) throws CertificateException {
        if (session != null) {
            String peerHost = session.getPeerHost();
            if (checkUrlMatchCertIdentity) {
                if (isClient) {
                    CFCASSLHelper.checkServerIdentity(cert, protocol, peerHost, sniNames);
                } else {
                    CFCASSLHelper.checkClientIdentity(cert, protocol, peerHost);
                }
            }
        }
    }

    private static final void checkServerIdentity(X509Certificate cert, String protocol, String peerHost, List<CFCASNIServerName> sniNames) throws CertificateException {
        String hostname = CFCASSLHelper.getHostNameFrom(sniNames);
        if (hostname != null) {
            try {
                CFCASSLHelper.checkIdentity(cert, protocol, hostname);
            }
            catch (CertificateException ce) {
                if (hostname.equalsIgnoreCase(peerHost)) {
                    throw ce;
                }
                CFCASSLHelper.checkIdentity(cert, protocol, peerHost);
            }
        }
    }

    private static final void checkClientIdentity(X509Certificate cert, String protocol, String peerHost) throws CertificateException {
        CFCASSLHelper.checkIdentity(cert, protocol, peerHost);
    }

    public static final void checkIdentity(X509Certificate cert, String protocol, String hostname) throws CertificateException {
        if (checkUrlMatchCertIdentity) {
            boolean check;
            boolean bl = check = hostname != null && hostname.length() != 0 && cert != null && protocol != null && protocol.length() != 0;
            if (check) {
                if (hostname.length() > 2 && hostname.charAt(0) == '[' && hostname.charAt(hostname.length() - 1) == ']') {
                    hostname = hostname.substring(1, hostname.length() - 1);
                }
                int checkerType = 0;
                if (protocol.equalsIgnoreCase("HTTPS") || protocol.equalsIgnoreCase("TCP")) {
                    checkerType = 1;
                } else if (protocol.equalsIgnoreCase("LDAP") || protocol.equalsIgnoreCase("LDAPS")) {
                    checkerType = 2;
                } else {
                    throw new CertificateException("Unknown identification algorithm: " + protocol);
                }
                HostnameChecker.getInstance((byte)checkerType).match(hostname, cert);
            }
        }
    }

    private static final String getHostNameFrom(List<CFCASNIServerName> sniNames) {
        String hostname;
        block1: {
            CFCASNIServerName sniName;
            hostname = null;
            if (sniNames == null) break block1;
            Iterator<CFCASNIServerName> i$ = sniNames.iterator();
            while (i$.hasNext() && (hostname = CFCASSLHelper.getHostNameFrom(sniName = i$.next())) == null) {
            }
        }
        return hostname;
    }

    private static final String getHostNameFrom(CFCASNIServerName sniName) {
        if (sniName == null) {
            return null;
        }
        if (sniName.getType() != 0) {
            return null;
        }
        String hostname = null;
        if (sniName instanceof CFCASNIHostName) {
            hostname = ((CFCASNIHostName)sniName).getAsciiName();
        } else {
            try {
                hostname = new CFCASNIHostName(sniName.getEncoded()).getAsciiName();
            }
            catch (IllegalArgumentException e) {
                Debugger.check.debug("Illegal server name: {}", (Object)sniName);
                hostname = null;
            }
        }
        return hostname;
    }

    public static final Set<X509Certificate> getTrustedCerts(KeyStore keystore) {
        Set<X509Certificate> trustedCerts = null;
        try {
            if (keystore != null) {
                trustedCerts = new HashSet<X509Certificate>();
                Enumeration<String> e = keystore.aliases();
                while (e.hasMoreElements()) {
                    Certificate[] certs;
                    String alias = e.nextElement();
                    if (keystore.isCertificateEntry(alias)) {
                        Certificate cert = keystore.getCertificate(alias);
                        if (!(cert instanceof X509Certificate)) continue;
                        trustedCerts.add((X509Certificate)cert);
                        continue;
                    }
                    if (!keystore.isKeyEntry(alias) || (certs = keystore.getCertificateChain(alias)) == null || certs.length <= 0 || !(certs[0] instanceof X509Certificate)) continue;
                    trustedCerts.add((X509Certificate)certs[0]);
                }
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        if (trustedCerts == null) {
            trustedCerts = Collections.emptySet();
        }
        return trustedCerts;
    }
}

