/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.BarcodeParameters;
import com.aspose.words.Document;
import com.aspose.words.Field;
import com.aspose.words.IBarcodeGenerator;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.zz2D;
import com.aspose.words.zz2F;
import com.aspose.words.zz2H;
import com.aspose.words.zz3Z;
import com.aspose.words.zzZSM;
import java.awt.image.BufferedImage;

public class FieldDisplayBarcode
extends Field
implements zzZSM {
    private void zzZ(BarcodeParameters barcodeParameters) throws Exception {
        barcodeParameters.setBarcodeType(this.getBarcodeType());
        barcodeParameters.setBarcodeValue(this.getBarcodeValue());
        barcodeParameters.setSymbolHeight(this.getSymbolHeight());
        barcodeParameters.setForegroundColor(this.getForegroundColor());
        barcodeParameters.setBackgroundColor(this.getBackgroundColor());
        barcodeParameters.setSymbolRotation(this.getSymbolRotation());
        barcodeParameters.setScalingFactor(this.getScalingFactor());
        barcodeParameters.setPosCodeStyle(this.getPosCodeStyle());
        barcodeParameters.setCaseCodeStyle(this.getCaseCodeStyle());
        barcodeParameters.setErrorCorrectionLevel(this.getErrorCorrectionLevel());
        barcodeParameters.setDisplayText(this.getDisplayText());
        barcodeParameters.setAddStartStopChar(this.getAddStartStopChar());
        barcodeParameters.setFixCheckDigit(this.getFixCheckDigit());
    }

    @Override
    zz2H zzZS3() throws Exception {
        IBarcodeGenerator iBarcodeGenerator = ((Document)this.getDocument()).getFieldOptions().getBarcodeGenerator();
        if (iBarcodeGenerator == null) {
            return new zz2D(this, "Error! Bar code generator is not set.");
        }
        this.remove(1);
        Shape shape = new Shape(this.getDocument(), 75);
        this.getEnd().getParentNode().insertBefore(shape, this.getEnd());
        BarcodeParameters barcodeParameters = new BarcodeParameters();
        this.zzZ(barcodeParameters);
        BufferedImage bufferedImage = iBarcodeGenerator.getBarcodeImage(barcodeParameters);
        if (bufferedImage == null) {
            return new zz2D(this, "Error! Image was not generated.");
        }
        shape.getImageData().setImage(bufferedImage);
        return new zz2F(this);
    }

    public String getBarcodeValue() throws Exception {
        return this.zzZRO().zzKi(0);
    }

    public void setBarcodeValue(String value) throws Exception {
        this.zzZRO().zzI(0, value);
    }

    public String getBarcodeType() throws Exception {
        return this.zzZRO().zzKi(1);
    }

    public void setBarcodeType(String value) throws Exception {
        this.zzZRO().zzI(1, value);
    }

    public String getSymbolHeight() throws Exception {
        return this.zzZRO().zzQJ("\\h");
    }

    public void setSymbolHeight(String value) throws Exception {
        this.zzZRO().zzZU("\\h", value);
    }

    public String getSymbolRotation() throws Exception {
        return this.zzZRO().zzQJ("\\r");
    }

    public void setSymbolRotation(String value) throws Exception {
        this.zzZRO().zzZU("\\r", value);
    }

    public String getScalingFactor() throws Exception {
        return this.zzZRO().zzQJ("\\s");
    }

    public void setScalingFactor(String value) throws Exception {
        this.zzZRO().zzZU("\\s", value);
    }

    public String getForegroundColor() throws Exception {
        return this.zzZRO().zzQJ("\\f");
    }

    public void setForegroundColor(String value) throws Exception {
        this.zzZRO().zzZU("\\f", value);
    }

    public String getBackgroundColor() throws Exception {
        return this.zzZRO().zzQJ("\\b");
    }

    public void setBackgroundColor(String value) throws Exception {
        this.zzZRO().zzZU("\\b", value);
    }

    public String getPosCodeStyle() throws Exception {
        return this.zzZRO().zzQJ("\\p");
    }

    public void setPosCodeStyle(String value) throws Exception {
        this.zzZRO().zzZU("\\p", value);
    }

    public String getCaseCodeStyle() throws Exception {
        return this.zzZRO().zzQJ("\\c");
    }

    public void setCaseCodeStyle(String value) throws Exception {
        this.zzZRO().zzZU("\\c", value);
    }

    public String getErrorCorrectionLevel() throws Exception {
        return this.zzZRO().zzQJ("\\q");
    }

    public void setErrorCorrectionLevel(String value) throws Exception {
        this.zzZRO().zzZU("\\q", value);
    }

    public boolean getDisplayText() throws Exception {
        return this.zzZRO().zzQM("\\t");
    }

    public void setDisplayText(boolean value) throws Exception {
        this.zzZRO().zzA("\\t", value);
    }

    public boolean getAddStartStopChar() throws Exception {
        return this.zzZRO().zzQM("\\d");
    }

    public void setAddStartStopChar(boolean value) throws Exception {
        this.zzZRO().zzA("\\d", value);
    }

    public boolean getFixCheckDigit() throws Exception {
        return this.zzZRO().zzQM("\\x");
    }

    public void setFixCheckDigit(boolean value) throws Exception {
        this.zzZRO().zzA("\\x", value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public int getSwitchType(String switchName) {
        return zz3Z.getSwitchType(switchName);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public int getTranslatableArgumentType(int index) {
        return 0;
    }
}

