/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.io.source.ByteUtils;
import cfca.sadk.com.itextpdf.io.util.MessageFormatUtil;
import cfca.sadk.com.itextpdf.kernel.Version;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfIndirectReference;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfOutputStream;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfStream;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.TreeSet;

class PdfXrefTable
implements Serializable {
    private static Logger businessLog = LoggerFactory.getLogger(PdfXrefTable.class);
    public static final int maxXrefSize = 1000000;
    private static final long serialVersionUID = 4171655392492002944L;
    private static final int INITIAL_CAPACITY = 32;
    private static final int MAX_GENERATION = 65535;
    private static final byte[] freeXRefEntry = ByteUtils.getIsoBytes("f \n");
    private static final byte[] inUseXRefEntry = ByteUtils.getIsoBytes("n \n");
    private PdfIndirectReference[] xref;
    private int count = 0;
    private final TreeSet<Integer> freeReferences;

    public PdfXrefTable() {
        this(32);
    }

    public PdfXrefTable(int capacity) {
        if (capacity < 1) {
            capacity = 32;
        }
        this.xref = new PdfIndirectReference[capacity];
        this.freeReferences = new TreeSet();
        this.add(new PdfIndirectReference(null, 0, 65535, 0L).setState((short)2));
    }

    public PdfIndirectReference add(PdfIndirectReference reference) {
        if (reference == null) {
            return null;
        }
        int objNr = reference.getObjNumber();
        this.count = Math.max(this.count, objNr);
        this.ensureCount(objNr);
        this.xref[objNr] = reference;
        return reference;
    }

    public int size() {
        return this.count + 1;
    }

    public PdfIndirectReference get(int index) {
        if (index > this.count) {
            return null;
        }
        return this.xref[index];
    }

    protected PdfIndirectReference createNextIndirectReference(PdfDocument document) {
        PdfIndirectReference reference = new PdfIndirectReference(document, ++this.count);
        this.add(reference);
        return reference.setState((short)8);
    }

    PdfIndirectReference createNewIndirectReference(PdfDocument document) {
        PdfIndirectReference reference = new PdfIndirectReference(document, ++this.count);
        this.add(reference);
        return reference.setState((short)8);
    }

    protected void freeReference(PdfIndirectReference reference) {
        this.freeReference(reference, false);
    }

    void freeReference(PdfIndirectReference reference, boolean readingFreeReference) {
        reference.setOffset(0L);
        reference.setState((short)2);
        if (!reference.checkState((short)1) && reference.refersTo != null) {
            reference.refersTo.setIndirectReference(null).setState((short)64);
            reference.refersTo = null;
        }
        if (!readingFreeReference && reference.getGenNumber() < 65535) {
            ++reference.genNr;
        }
    }

    protected void setCapacity(int capacity) {
        if (capacity > this.xref.length) {
            this.extendXref(capacity);
        }
    }

    protected void writeXrefTableAndTrailer(PdfDocument document, PdfObject fileId, PdfObject crypto) throws IOException {
        PdfIndirectReference lastRef;
        PdfWriter writer = document.getWriter();
        for (int i = this.count; i > 0 && ((lastRef = this.xref[i]) == null || lastRef.isFree() && lastRef.getGenNumber() == 0 || !lastRef.checkState((short)1) && (!document.properties.appendMode || lastRef.checkState((short)8))); --i) {
            --this.count;
        }
        int lastFreeObjNr = 0;
        for (int i = this.count; i >= 0; --i) {
            PdfIndirectReference ref = this.xref[i];
            if (ref == null) {
                this.xref[i] = ref = new PdfIndirectReference(document, i, 0).setState((short)2);
            }
            if (!ref.isFree()) continue;
            ref.setOffset(lastFreeObjNr);
            lastFreeObjNr = i;
        }
        ArrayList<Integer> sections = new ArrayList<Integer>();
        int first = 0;
        int len = 1;
        for (int i = 1; i < this.size(); ++i) {
            PdfIndirectReference reference = this.xref[i];
            if (reference != null && document.properties.appendMode && !reference.checkState((short)8) && !reference.isFree()) {
                reference = null;
            }
            if (reference == null) {
                if (len > 0) {
                    sections.add(first);
                    sections.add(len);
                }
                len = 0;
                continue;
            }
            if (len > 0) {
                ++len;
                continue;
            }
            first = i;
            len = 1;
        }
        if (len > 0) {
            sections.add(first);
            sections.add(len);
        }
        if (document.properties.appendMode && sections.size() == 2 && (Integer)sections.get(1) == 1) {
            this.xref = null;
            return;
        }
        long startxref = writer.getCurrentPos();
        if (writer.isFullCompression()) {
            PdfStream xrefStream = new PdfStream().makeIndirect(document);
            xrefStream.makeIndirect(document);
            xrefStream.put(PdfName.Type, PdfName.XRef);
            xrefStream.put(PdfName.ID, fileId);
            if (crypto != null) {
                xrefStream.put(PdfName.Encrypt, crypto);
            }
            xrefStream.put(PdfName.Size, new PdfNumber(this.size()));
            ArrayList<PdfNumber> tmpArray = new ArrayList<PdfNumber>(3);
            tmpArray.add(new PdfNumber(1));
            tmpArray.add(new PdfNumber(4));
            tmpArray.add(new PdfNumber(2));
            xrefStream.put(PdfName.W, new PdfArray(tmpArray));
            xrefStream.put(PdfName.Info, (PdfObject)document.getDocumentInfo().getPdfObject());
            xrefStream.put(PdfName.Root, (PdfObject)document.getCatalog().getPdfObject());
            PdfArray index = new PdfArray();
            for (Integer section : sections) {
                index.add(new PdfNumber(section));
            }
            if (document.properties.appendMode) {
                PdfNumber lastXref = new PdfNumber(document.reader.getLastXref());
                xrefStream.put(PdfName.Prev, lastXref);
            }
            xrefStream.put(PdfName.Index, index);
            PdfXrefTable xrefTable = document.getXref();
            for (int k = 0; k < sections.size(); k += 2) {
                first = (Integer)sections.get(k);
                len = (Integer)sections.get(k + 1);
                for (int i = first; i < first + len; ++i) {
                    PdfIndirectReference reference = xrefTable.get(i);
                    if (reference == null) continue;
                    if (reference.isFree()) {
                        xrefStream.getOutputStream().write(0);
                        assert (reference.getOffset() < Integer.MAX_VALUE);
                        xrefStream.getOutputStream().write(PdfXrefTable.intToBytes((int)reference.getOffset()));
                        xrefStream.getOutputStream().write(PdfXrefTable.shortToBytes(reference.getGenNumber()));
                        continue;
                    }
                    if (reference.getObjStreamNumber() == 0) {
                        xrefStream.getOutputStream().write(1);
                        assert (reference.getOffset() < Integer.MAX_VALUE);
                        xrefStream.getOutputStream().write(PdfXrefTable.intToBytes((int)reference.getOffset()));
                        xrefStream.getOutputStream().write(PdfXrefTable.shortToBytes(reference.getGenNumber()));
                        continue;
                    }
                    xrefStream.getOutputStream().write(2);
                    xrefStream.getOutputStream().write(PdfXrefTable.intToBytes(reference.getObjStreamNumber()));
                    xrefStream.getOutputStream().write(PdfXrefTable.shortToBytes(reference.getIndex()));
                }
            }
            xrefStream.flush();
        } else {
            writer.writeString("xref\n");
            PdfXrefTable xrefTable = document.getXref();
            for (int k = 0; k < sections.size(); k += 2) {
                first = (Integer)sections.get(k);
                len = (Integer)sections.get(k + 1);
                ((PdfOutputStream)((PdfOutputStream)((PdfOutputStream)writer.writeInteger(first)).writeSpace()).writeInteger(len)).writeByte((byte)10);
                for (int i = first; i < first + len; ++i) {
                    PdfIndirectReference reference = xrefTable.get(i);
                    StringBuilder off = new StringBuilder("0000000000").append(reference.getOffset());
                    StringBuilder gen = new StringBuilder("00000").append(reference.getGenNumber());
                    ((PdfOutputStream)((PdfOutputStream)((PdfOutputStream)writer.writeString(off.substring(off.length() - 10, off.length()))).writeSpace()).writeString(gen.substring(gen.length() - 5, gen.length()))).writeSpace();
                    if (reference.isFree()) {
                        writer.writeBytes(freeXRefEntry);
                        continue;
                    }
                    writer.writeBytes(inUseXRefEntry);
                }
            }
            PdfDictionary trailer = document.getTrailer();
            trailer.remove(PdfName.W);
            trailer.remove(PdfName.Index);
            trailer.remove(PdfName.Type);
            trailer.remove(PdfName.Length);
            trailer.put(PdfName.Size, new PdfNumber(this.size()));
            trailer.put(PdfName.ID, fileId);
            if (crypto != null) {
                trailer.put(PdfName.Encrypt, crypto);
            }
            writer.writeString("trailer\n");
            if (document.properties.appendMode) {
                PdfNumber lastXref = new PdfNumber(document.reader.getLastXref());
                trailer.put(PdfName.Prev, lastXref);
            }
            writer.write(document.getTrailer());
            writer.write(10);
        }
        PdfXrefTable.writeKeyInfo(writer);
        ((PdfOutputStream)((PdfOutputStream)writer.writeString("startxref\n")).writeLong(startxref)).writeString("\n%%EOF\n");
        this.xref = null;
    }

    void clear() {
        if (this.xref != null) {
            for (int i = 1; i <= this.count && i < this.xref.length; ++i) {
                if (this.xref[i] != null && this.xref[i].isFree()) {
                    businessLog.warn("xref[" + i + "] is not clean!");
                    continue;
                }
                this.xref[i] = null;
            }
            this.count = 1;
        }
    }

    void clearAll() {
        this.xref = null;
        this.count = 0;
    }

    protected static void writeKeyInfo(PdfWriter writer) throws IOException {
        String platform = "";
        Version version = Version.getInstance();
        String k = version.getKey();
        if (k == null) {
            k = "iText";
        }
        writer.writeString(MessageFormatUtil.format("%{0}-{1}{2}\n", k, version.getRelease(), platform));
    }

    private void ensureCount(int count) {
        if (count >= this.xref.length) {
            this.extendXref(count << 1);
        }
    }

    private void extendXref(int capacity) {
        if (capacity > 1000000) {
            this.xref = null;
            String errorInfo = "capacity is more than 1000000";
            businessLog.error("#####" + errorInfo);
            throw new IllegalArgumentException(errorInfo);
        }
        PdfIndirectReference[] newXref = new PdfIndirectReference[capacity];
        System.arraycopy(this.xref, 0, newXref, 0, this.xref.length);
        this.xref = newXref;
    }

    private static byte[] shortToBytes(int n) {
        return new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
    }

    private static byte[] intToBytes(int n) {
        return new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
    }
}

