/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.tools.fontinfo;

import cfca.com.google.typography.font.sfntly.Font;
import cfca.com.google.typography.font.sfntly.Tag;
import cfca.com.google.typography.font.sfntly.math.Fixed1616;
import cfca.com.google.typography.font.sfntly.table.Table;
import cfca.com.google.typography.font.sfntly.table.core.CMap;
import cfca.com.google.typography.font.sfntly.table.core.CMapTable;
import cfca.com.google.typography.font.sfntly.table.core.FontHeaderTable;
import cfca.com.google.typography.font.sfntly.table.core.HorizontalHeaderTable;
import cfca.com.google.typography.font.sfntly.table.core.MaximumProfileTable;
import cfca.com.google.typography.font.sfntly.table.core.NameTable;
import cfca.com.google.typography.font.sfntly.table.core.OS2Table;
import cfca.com.google.typography.font.sfntly.table.truetype.CompositeGlyph;
import cfca.com.google.typography.font.sfntly.table.truetype.Glyph;
import cfca.com.google.typography.font.sfntly.table.truetype.GlyphTable;
import cfca.com.google.typography.font.sfntly.table.truetype.LocaTable;
import cfca.com.google.typography.font.tools.fontinfo.DataDisplayTable;
import cfca.com.google.typography.font.tools.fontinfo.FontUtils;
import cfca.com.google.typography.font.tools.fontinfo.UnicodeBlockData;
import com.ibm.icu.impl.IllegalIcuArgumentException;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.UnicodeSet;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;

public class FontInfo {
    private static final int CHECKSUM_LENGTH = 8;
    private static final DecimalFormat twoDecimalPlaces = new DecimalFormat("#.##");

    public static String sfntVersion(Font font) {
        double version = Fixed1616.doubleValue(font.sfntVersion());
        NumberFormat numberFormatter = NumberFormat.getInstance();
        numberFormatter.setMinimumFractionDigits(2);
        numberFormatter.setGroupingUsed(false);
        return numberFormatter.format(version);
    }

    public static DataDisplayTable listFontMetrics(Font font) {
        String[] header = new String[]{"Name", "Value"};
        DataDisplayTable.Align[] displayAlignment = new DataDisplayTable.Align[]{DataDisplayTable.Align.Left, DataDisplayTable.Align.Left};
        DataDisplayTable table = new DataDisplayTable(Arrays.asList(header));
        table.setAlignment(Arrays.asList(displayAlignment));
        FontHeaderTable headTable = (FontHeaderTable)FontUtils.getTable(font, Tag.head);
        HorizontalHeaderTable hheaTable = (HorizontalHeaderTable)FontUtils.getTable(font, Tag.hhea);
        OS2Table os2Table = (OS2Table)FontUtils.getTable(font, Tag.OS_2);
        table.add(Arrays.asList("Units per em", String.format("%d", headTable.unitsPerEm())));
        table.add(Arrays.asList("[xMin, xMax]", String.format("[%d, %d]", headTable.xMin(), headTable.xMax())));
        table.add(Arrays.asList("[yMin, yMax]", String.format("[%d, %d]", headTable.yMin(), headTable.yMax())));
        table.add(Arrays.asList("Smallest readable size (px per em)", String.format("%d", headTable.lowestRecPPEM())));
        table.add(Arrays.asList("hhea ascender", String.format("%d", hheaTable.ascender())));
        table.add(Arrays.asList("hhea descender", String.format("%d", hheaTable.descender())));
        table.add(Arrays.asList("hhea typographic line gap", String.format("%d", hheaTable.lineGap())));
        table.add(Arrays.asList("OS/2 Windows ascender", String.format("%d", os2Table.usWinAscent())));
        table.add(Arrays.asList("OS/2 Windows descender", String.format("%d", os2Table.usWinDescent())));
        table.add(Arrays.asList("OS/2 typographic ascender", String.format("%d", os2Table.sTypoAscender())));
        table.add(Arrays.asList("OS/2 typographic ascender", String.format("%d", os2Table.sTypoDescender())));
        table.add(Arrays.asList("OS/2 typographic line gap", String.format("%d", os2Table.sTypoLineGap())));
        return table;
    }

    public static DataDisplayTable listTables(Font font) {
        Table fontTable;
        String[] header = new String[]{"tag", "checksum", "length", "offset"};
        DataDisplayTable.Align[] displayAlignment = new DataDisplayTable.Align[]{DataDisplayTable.Align.Left, DataDisplayTable.Align.Right, DataDisplayTable.Align.Right, DataDisplayTable.Align.Right};
        DataDisplayTable table = new DataDisplayTable(Arrays.asList(header));
        table.setAlignment(Arrays.asList(displayAlignment));
        int fontSize = 0;
        Iterator<? extends Table> fontTableIter = font.iterator();
        while (fontTableIter.hasNext()) {
            fontTable = fontTableIter.next();
            fontSize += fontTable.headerLength();
        }
        fontTableIter = font.iterator();
        while (fontTableIter.hasNext()) {
            fontTable = fontTableIter.next();
            String name = Tag.stringValue(fontTable.headerTag());
            String checksum = String.format("0x%08X", fontTable.headerChecksum());
            int length = fontTable.headerLength();
            double lengthPercent = (double)length * 100.0 / (double)fontSize;
            int offset = fontTable.headerOffset();
            String[] data = new String[]{name, checksum, String.format("%s (%s%%)", length, twoDecimalPlaces.format(lengthPercent)), String.format("%d", offset)};
            table.add(Arrays.asList(data));
        }
        return table;
    }

    public static DataDisplayTable listNameEntries(Font font) {
        String[] header = new String[]{"Platform", "Encoding", "Language", "Name", "Value"};
        DataDisplayTable.Align[] displayAlignment = new DataDisplayTable.Align[]{DataDisplayTable.Align.Left, DataDisplayTable.Align.Left, DataDisplayTable.Align.Left, DataDisplayTable.Align.Left, DataDisplayTable.Align.Left};
        DataDisplayTable table = new DataDisplayTable(Arrays.asList(header));
        table.setAlignment(Arrays.asList(displayAlignment));
        NameTable nameTable = (NameTable)FontUtils.getTable(font, Tag.name);
        for (NameTable.NameEntry entry : nameTable) {
            String eidEntry = "";
            String lidEntry = "";
            switch (Font.PlatformId.valueOf(entry.platformId())) {
                case Unicode: {
                    eidEntry = Font.UnicodeEncodingId.valueOf(entry.encodingId()).toString();
                    lidEntry = NameTable.UnicodeLanguageId.valueOf(entry.languageId()).toString();
                    break;
                }
                case Macintosh: {
                    eidEntry = Font.MacintoshEncodingId.valueOf(entry.encodingId()).toString();
                    lidEntry = NameTable.MacintoshLanguageId.valueOf(entry.languageId()).toString();
                    break;
                }
                case Windows: {
                    eidEntry = Font.WindowsEncodingId.valueOf(entry.encodingId()).toString();
                    lidEntry = NameTable.WindowsLanguageId.valueOf(entry.languageId()).toString();
                    break;
                }
            }
            String[] data = new String[]{String.format("%s (id=%d)", Font.PlatformId.valueOf(entry.platformId()).toString(), entry.platformId()), String.format("%s (id=%d)", eidEntry, entry.encodingId()), String.format("%s (id=%d)", lidEntry, entry.languageId()), NameTable.NameId.valueOf(entry.nameId()).toString(), entry.name()};
            table.add(Arrays.asList(data));
        }
        return table;
    }

    public static DataDisplayTable listCmaps(Font font) {
        String[] header = new String[]{"Platform ID", "Encoding ID", "Format"};
        DataDisplayTable.Align[] displayAlignment = new DataDisplayTable.Align[]{DataDisplayTable.Align.Right, DataDisplayTable.Align.Right, DataDisplayTable.Align.Right};
        DataDisplayTable table = new DataDisplayTable(Arrays.asList(header));
        table.setAlignment(Arrays.asList(displayAlignment));
        CMapTable cmapTable = FontUtils.getCMapTable(font);
        for (CMap cmap : cmapTable) {
            String[] data = new String[]{String.format("%d", cmap.platformId()), String.format("%d", cmap.encodingId()), String.format("%d", cmap.format())};
            table.add(Arrays.asList(data));
        }
        return table;
    }

    public static int numChars(Font font) {
        int numChars = 0;
        CMap cmap = FontUtils.getUCSCMap(font);
        Iterator iterator = cmap.iterator();
        while (iterator.hasNext()) {
            int charId = (Integer)iterator.next();
            if (cmap.glyphId(charId) == 0) continue;
            ++numChars;
        }
        return numChars;
    }

    public static DataDisplayTable listChars(Font font) {
        String[] header = new String[]{"Code point", "Glyph ID", "Unicode-designated name for code point"};
        DataDisplayTable.Align[] displayAlignment = new DataDisplayTable.Align[]{DataDisplayTable.Align.Right, DataDisplayTable.Align.Right, DataDisplayTable.Align.Left};
        DataDisplayTable table = new DataDisplayTable(Arrays.asList(header));
        table.setAlignment(Arrays.asList(displayAlignment));
        CMap cmap = FontUtils.getUCSCMap(font);
        Iterator iterator = cmap.iterator();
        while (iterator.hasNext()) {
            int charId = (Integer)iterator.next();
            int glyphId = cmap.glyphId(charId);
            if (glyphId == 0) continue;
            String[] data = new String[]{FontUtils.getFormattedCodePointString(charId), String.format("%d", glyphId), UCharacter.getExtendedName((int)charId)};
            table.add(Arrays.asList(data));
        }
        return table;
    }

    public static DataDisplayTable listCharBlockCoverage(Font font) {
        String[] header = new String[]{"Block", "Coverage"};
        DataDisplayTable.Align[] displayAlignment = new DataDisplayTable.Align[]{DataDisplayTable.Align.Left, DataDisplayTable.Align.Right};
        DataDisplayTable table = new DataDisplayTable(Arrays.asList(header));
        table.setAlignment(Arrays.asList(displayAlignment));
        CMap cmap = FontUtils.getUCSCMap(font);
        int totalCount = 0;
        for (int i = 0; i < UnicodeBlockData.numBlocks(); ++i) {
            String block = UnicodeBlockData.getBlockName(i);
            UnicodeSet set = null;
            try {
                set = new UnicodeSet("[[:Block=" + (String)block + ":]-[:gc=Unassigned:]-[:gc=Control:]]");
            }
            catch (IllegalIcuArgumentException e) {
                continue;
            }
            int count = 0;
            for (String charStr : set) {
                if (cmap.glyphId(UCharacter.codePointAt((CharSequence)charStr, (int)0)) <= 0) continue;
                ++count;
            }
            if (count > 0) {
                table.add(Arrays.asList(String.format("%s [%s, %s]", block, UnicodeBlockData.getBlockStartCode(i), UnicodeBlockData.getBlockEndCode(i)), String.format("%d / %d", count, set.size())));
            }
            totalCount += count;
        }
        UnicodeSet controlSet = new UnicodeSet("[[:gc=Control:]]");
        for (String charStr : controlSet) {
            if (cmap.glyphId(UCharacter.codePointAt((CharSequence)charStr, (int)0)) <= 0) continue;
            ++totalCount;
        }
        int nonUnicodeCount = FontInfo.numChars(font) - totalCount;
        if (nonUnicodeCount > 0) {
            table.add(Arrays.asList("Unknown", String.format("%d", nonUnicodeCount)));
        }
        return table;
    }

    public static DataDisplayTable listScriptCoverage(Font font) {
        String[] header = new String[]{"Script", "Coverage"};
        DataDisplayTable.Align[] displayAlignment = new DataDisplayTable.Align[]{DataDisplayTable.Align.Left, DataDisplayTable.Align.Right};
        DataDisplayTable table = new DataDisplayTable(Arrays.asList(header));
        table.setAlignment(Arrays.asList(displayAlignment));
        HashMap<Integer, Integer> coveredScripts = new HashMap<Integer, Integer>();
        CMap cmap = FontUtils.getUCSCMap(font);
        Iterator iterator = cmap.iterator();
        while (iterator.hasNext()) {
            int charId = (Integer)iterator.next();
            if (cmap.glyphId(charId) == 0) continue;
            int scriptCode = UScript.getScript((int)charId);
            int scriptCount = 1;
            if (coveredScripts.containsKey(scriptCode)) {
                scriptCount += ((Integer)coveredScripts.get(scriptCode)).intValue();
            }
            coveredScripts.put(scriptCode, scriptCount);
        }
        TreeSet sortedScripts = new TreeSet(coveredScripts.keySet());
        int unknown = 0;
        for (Integer scriptCode : sortedScripts) {
            UnicodeSet scriptSet = null;
            String scriptName = UScript.getName((int)scriptCode);
            try {
                scriptSet = new UnicodeSet("[[:" + scriptName + ":]]");
            }
            catch (IllegalIcuArgumentException e) {
                unknown += ((Integer)coveredScripts.get(scriptCode)).intValue();
                continue;
            }
            table.add(Arrays.asList(scriptName, String.format("%d / %d", coveredScripts.get(scriptCode), scriptSet.size())));
        }
        if (unknown > 0) {
            table.add(Arrays.asList("Unsupported script", String.format("%d", unknown)));
        }
        return table;
    }

    public static DataDisplayTable listCharsNeededToCoverScript(Font font) {
        String[] header = new String[]{"Script", "Code Point", "Name"};
        DataDisplayTable.Align[] displayAlignment = new DataDisplayTable.Align[]{DataDisplayTable.Align.Left, DataDisplayTable.Align.Right, DataDisplayTable.Align.Left};
        DataDisplayTable table = new DataDisplayTable(Arrays.asList(header));
        table.setAlignment(Arrays.asList(displayAlignment));
        HashMap<Integer, UnicodeSet> coveredScripts = new HashMap<Integer, UnicodeSet>();
        CMap cmap = FontUtils.getUCSCMap(font);
        Iterator iterator = cmap.iterator();
        while (iterator.hasNext()) {
            int scriptCode;
            int charId = (Integer)iterator.next();
            if (cmap.glyphId(charId) == 0 || (scriptCode = UScript.getScript((int)charId)) == 103) continue;
            UnicodeSet scriptSet = null;
            if (!coveredScripts.containsKey(scriptCode)) {
                try {
                    scriptSet = new UnicodeSet("[[:" + UScript.getName((int)scriptCode) + ":]-[:gc=Unassigned:]-[:gc=Control:]]");
                }
                catch (IllegalIcuArgumentException e) {
                    continue;
                }
                coveredScripts.put(scriptCode, scriptSet);
            } else {
                scriptSet = (UnicodeSet)coveredScripts.get(scriptCode);
            }
            scriptSet.remove((CharSequence)UCharacter.toString((int)charId));
        }
        TreeSet sortedScripts = new TreeSet(coveredScripts.keySet());
        for (Integer scriptCode : sortedScripts) {
            UnicodeSet uSet = (UnicodeSet)coveredScripts.get(scriptCode);
            for (String charStr : uSet) {
                int codePoint = UCharacter.codePointAt((CharSequence)charStr, (int)0);
                table.add(Arrays.asList(String.format("%s", UScript.getName((int)scriptCode)), FontUtils.getFormattedCodePointString(codePoint), UCharacter.getExtendedName((int)codePoint)));
            }
        }
        return table;
    }

    public static int numGlyphs(Font font) {
        return ((MaximumProfileTable)FontUtils.getTable(font, Tag.maxp)).numGlyphs();
    }

    public static DataDisplayTable listGlyphDimensionBounds(Font font) {
        String[] header = new String[]{"Dimension", "Value"};
        DataDisplayTable.Align[] displayAlignment = new DataDisplayTable.Align[]{DataDisplayTable.Align.Left, DataDisplayTable.Align.Right};
        DataDisplayTable table = new DataDisplayTable(Arrays.asList(header));
        table.setAlignment(Arrays.asList(displayAlignment));
        LocaTable locaTable = FontUtils.getLocaTable(font);
        GlyphTable glyfTable = FontUtils.getGlyphTable(font);
        int xMin = Integer.MAX_VALUE;
        int yMin = Integer.MAX_VALUE;
        int xMax = Integer.MIN_VALUE;
        int yMax = Integer.MIN_VALUE;
        for (int i = 0; i < locaTable.numGlyphs(); ++i) {
            Glyph glyph = glyfTable.glyph(locaTable.glyphOffset(i), locaTable.glyphLength(i));
            if (glyph.xMin() < xMin) {
                xMin = glyph.xMin();
            }
            if (glyph.yMin() < yMin) {
                yMin = glyph.yMin();
            }
            if (glyph.xMax() > xMax) {
                xMax = glyph.xMax();
            }
            if (glyph.yMax() <= yMax) continue;
            yMax = glyph.yMax();
        }
        table.add(Arrays.asList("xMin", String.format("%d", xMin)));
        table.add(Arrays.asList("xMax", String.format("%d", xMax)));
        table.add(Arrays.asList("yMin", String.format("%d", yMin)));
        table.add(Arrays.asList("yMax", String.format("%d", yMax)));
        return table;
    }

    public static String hintingSize(Font font) {
        int instrSize = 0;
        LocaTable locaTable = FontUtils.getLocaTable(font);
        GlyphTable glyfTable = FontUtils.getGlyphTable(font);
        for (int i = 0; i < locaTable.numGlyphs(); ++i) {
            Glyph glyph = glyfTable.glyph(locaTable.glyphOffset(i), locaTable.glyphLength(i));
            instrSize += glyph.instructionSize();
        }
        double percentage = (double)instrSize * 100.0 / (double)glyfTable.headerLength();
        return String.format("%d bytes (%s%% of glyf table)", instrSize, twoDecimalPlaces.format(percentage));
    }

    public static DataDisplayTable listSubglyphFrequency(Font font) {
        HashMap<Integer, Integer> subglyphFreq = new HashMap<Integer, Integer>();
        String[] header = new String[]{"Glyph ID", "Frequency"};
        DataDisplayTable.Align[] displayAlignment = new DataDisplayTable.Align[]{DataDisplayTable.Align.Right, DataDisplayTable.Align.Right};
        DataDisplayTable table = new DataDisplayTable(Arrays.asList(header));
        table.setAlignment(Arrays.asList(displayAlignment));
        LocaTable locaTable = FontUtils.getLocaTable(font);
        GlyphTable glyfTable = FontUtils.getGlyphTable(font);
        for (int i = 0; i < locaTable.numGlyphs(); ++i) {
            Glyph glyph = glyfTable.glyph(locaTable.glyphOffset(i), locaTable.glyphLength(i));
            if (glyph.glyphType() != Glyph.GlyphType.Composite) continue;
            CompositeGlyph cGlyph = (CompositeGlyph)glyph;
            for (int j = 0; j < cGlyph.numGlyphs(); ++j) {
                int subglyphId = cGlyph.glyphIndex(j);
                int frequency = 1;
                if (subglyphFreq.containsKey(subglyphId)) {
                    frequency += ((Integer)subglyphFreq.get(subglyphId)).intValue();
                }
                subglyphFreq.put(subglyphId, frequency);
            }
        }
        boolean numSubglyphs = false;
        TreeSet sortedKeySet = new TreeSet(subglyphFreq.keySet());
        for (Integer key : sortedKeySet) {
            String[] data = new String[]{key.toString(), ((Integer)subglyphFreq.get(key)).toString()};
            table.add(Arrays.asList(data));
        }
        return table;
    }

    public static DataDisplayTable listUnmappedGlyphs(Font font) {
        String[] header = new String[]{"Glyph ID"};
        DataDisplayTable.Align[] displayAlignment = new DataDisplayTable.Align[]{DataDisplayTable.Align.Right};
        DataDisplayTable table = new DataDisplayTable(Arrays.asList(header));
        table.setAlignment(Arrays.asList(displayAlignment));
        HashSet<Integer> mappedGlyphs = new HashSet<Integer>();
        CMapTable cmapTable = FontUtils.getCMapTable(font);
        for (CMap cmap : cmapTable) {
            for (Integer codePoint : cmap) {
                mappedGlyphs.add(cmap.glyphId(codePoint));
            }
        }
        LocaTable locaTable = FontUtils.getLocaTable(font);
        for (int i = 0; i < locaTable.numGlyphs(); ++i) {
            if (mappedGlyphs.contains(i)) continue;
            table.add(Arrays.asList(String.format("%d", i)));
        }
        return table;
    }

    public static String listChars(Font font, String glyphs) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (glyphs != null) {
            String[] glyphidList = glyphs.split(" ");
            if (font != null) {
                try {
                    CMap cmap = FontUtils.getUCSCMap(font);
                    block2: for (int i = 0; i < glyphidList.length; ++i) {
                        int glyfid = Integer.parseInt(glyphidList[i]);
                        Iterator iterator = cmap.iterator();
                        while (iterator.hasNext()) {
                            int charId = (Integer)iterator.next();
                            int glyphId = cmap.glyphId(charId);
                            if (glyphId == 0 || glyfid != glyphId) continue;
                            sb.appendCodePoint(charId);
                            continue block2;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return sb.toString();
    }
}

